/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.modelingproject;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.modelingproject.AbstractRepresentationsFileJob;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.util.MarkerUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionHelper;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.resourcelistener.ISessionFileLoadingListener;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenRepresentationsFileJob
extends AbstractRepresentationsFileJob {
    public static final String JOB_LABEL = Messages.OpenRepresentationsFileJob_label;
    private URI representationsFileURI;
    private final boolean isDirectUserActionLoading;

    public OpenRepresentationsFileJob(URI representationsFileURI) {
        this(representationsFileURI, false);
    }

    public OpenRepresentationsFileJob(URI representationsFileURI, boolean isDirectUserActionLoading) {
        super(JOB_LABEL);
        this.representationsFileURI = representationsFileURI;
        this.isDirectUserActionLoading = isDirectUserActionLoading;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.setRule(MultiRule.combine((ISchedulingRule)this.getRule(), (ISchedulingRule)workspace.getRuleFactory().createRule((IResource)workspace.getRoot())));
    }

    public static void scheduleNewWhenPossible(URI representationsFileURI, boolean user) {
        OpenRepresentationsFileJob.scheduleNewWhenPossible(representationsFileURI, user, false);
    }

    public static void scheduleNewWhenPossible(URI representationsFileURI, boolean user, boolean isDirectUserActionLoading) {
        OpenRepresentationsFileJob job = new OpenRepresentationsFileJob(representationsFileURI, isDirectUserActionLoading);
        job.setUser(user);
        job.setPriority(20);
        job.schedule();
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            PlatformUI.getWorkbench().getProgressService().showInDialog(activeWorkbenchWindow.getShell(), (Job)job);
        }
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.OpenRepresentationsFileJob_loadingModelsTask, (int)100);
        IProject project = null;
        try {
            try {
                if (this.representationsFileURI.isPlatform()) {
                    String projectName = URI.decode((String)this.representationsFileURI.segment(1));
                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                }
                try {
                    if (project != null) {
                        project.deleteMarkers("org.eclipse.sirius.modelingMarker", false, 0);
                    }
                }
                catch (CoreException e) {
                    SiriusPlugin.getDefault().getLog().log(e.getStatus());
                }
                subMonitor.subTask(MessageFormat.format(Messages.OpenRepresentationsFileJob_loadingRepresentationFileTask, this.representationsFileURI.lastSegment()));
                Session session = this.performOpenSession((IProgressMonitor)subMonitor.newChild(90));
                if (session != null) {
                    monitor.subTask(MessageFormat.format(Messages.OpenRepresentationsFileJob_openingStartRepresentationTask, this.representationsFileURI.lastSegment()));
                    SessionHelper.openStartupRepresentations(session, (IProgressMonitor)subMonitor.newChild(10));
                }
            }
            catch (RuntimeException e) {
                String message = this.markeModelingProjectAsInvalid(project, e);
                throw new RuntimeException(message, e);
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private Session performOpenSession(IProgressMonitor monitor) {
        Session session = null;
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.OpenRepresentationsFileJob_loadRepresentationsTask, (int)16);
            if ("aird".equals(this.representationsFileURI.fileExtension())) {
                subMonitor.worked(1);
                subMonitor.subTask(MessageFormat.format(Messages.OpenRepresentationsFileJob_loadReferencedModelsTask, this.representationsFileURI.lastSegment()));
                session = SessionManager.INSTANCE.openSession(this.representationsFileURI, (IProgressMonitor)subMonitor.newChild(14), SiriusEditPlugin.getPlugin().getUiCallback(), this.isDirectUserActionLoading);
                if (session != null) {
                    Set<ISessionFileLoadingListener> sessionFileLoadingListeners = SiriusEditPlugin.getPlugin().getSessionFileLoadingListeners();
                    for (ISessionFileLoadingListener sessionFileLoadingListener : sessionFileLoadingListeners) {
                        sessionFileLoadingListener.notifySessionLoadedFromModelingProject(session);
                    }
                    IEditingSession editingSession = SessionUIManager.INSTANCE.getOrCreateUISession(session);
                    if (!editingSession.isOpen()) {
                        editingSession.open();
                    }
                }
                subMonitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
        return session;
    }

    private String markeModelingProjectAsInvalid(IProject project, RuntimeException exception) {
        String message = null;
        if (project != null) {
            Option optionalModelingProject;
            boolean isModelingProject = ModelingProject.hasModelingProjectNature((IProject)project);
            String errorDetail = exception != null ? (exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage()) : Messages.OpenRepresentationsFileJob_loadingProblem_defaultErrorDetail;
            message = isModelingProject ? MessageFormat.format(Messages.OpenRepresentationsFileJob_loadingProblem_modelingProject, project.getName(), errorDetail) : MessageFormat.format(Messages.OpenRepresentationsFileJob_loadingProblem_representationFile, this.representationsFileURI.toPlatformString(true), errorDetail);
            Optional optionalMarker = MarkerUtil.addMarkerFor((IResource)project, (String)message, (int)2, (String)"org.eclipse.sirius.modelingMarker");
            if (optionalMarker.isPresent() && exception instanceof Resource.Diagnostic) {
                MarkerUtil.setAttribute((IMarker)((IMarker)optionalMarker.get()), (String)"location", (Object)((Resource.Diagnostic)exception).getLocation());
            }
            if ((optionalModelingProject = ModelingProject.asModelingProject((IProject)project)).some()) {
                ((ModelingProject)optionalModelingProject.get()).setValid(false);
            }
        }
        ModelingProjectManager.INSTANCE.clearCache(this.representationsFileURI);
        return message;
    }

    public static boolean shouldWaitOtherJobs() {
        Job[] jobs = Job.getJobManager().find((Object)"org.eclipse.sirius.representationsFile");
        return jobs != null && jobs.length > 0;
    }

    protected static String getLocalizedMessage(Throwable exception) {
        String message = exception.getLocalizedMessage();
        if (message == null) {
            if (exception instanceof CoreException) {
                CoreException ce = (CoreException)exception;
                return ce.getStatus().getMessage();
            }
            message = Messages.OpenRepresentationsFileJob_unexpectedException;
        }
        return message;
    }

    protected static Throwable getCause(Throwable exception) {
        Throwable cause = null;
        if (exception != null) {
            if (exception instanceof CoreException) {
                CoreException ce = (CoreException)exception;
                cause = ce.getStatus().getException();
            } else {
                try {
                    Method causeMethod = exception.getClass().getMethod("getCause", new Class[0]);
                    Object o = causeMethod.invoke((Object)exception, new Object[0]);
                    if (o instanceof Throwable) {
                        cause = (Throwable)o;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            if (cause == null) {
                cause = exception;
            }
        }
        return cause;
    }
}

