/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.ui.internal.notification;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.common.ui.internal.notification.OneFont;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public final class FontCache {
    private static List<OneFont> existing = new ArrayList<OneFont>();

    private FontCache() {
    }

    public static void disposeAll() {
        for (OneFont of : existing) {
            if (of.getFont() == null || of.getFont().isDisposed()) continue;
            of.getFont().dispose();
        }
        existing.clear();
    }

    public static Font getFont(FontData fd) {
        OneFont of2;
        boolean disposed = false;
        OneFont toRemove = null;
        for (OneFont of2 : existing) {
            if (!of2.matches(fd)) continue;
            if (of2.getFont().isDisposed()) {
                disposed = true;
                toRemove = of2;
                break;
            }
            return of2.getFont();
        }
        if (disposed) {
            existing.remove(toRemove);
        }
        of2 = new OneFont(fd);
        existing.add(of2);
        return of2.getFont();
    }

    public static int getCount() {
        return existing.size();
    }

    public static Font getFont(Font font) {
        if (font != null && !font.isDisposed()) {
            FontData fd = font.getFontData()[0];
            return FontCache.getFont(fd);
        }
        return null;
    }

    public static Font getFont(String fontName, int height, int style) {
        OneFont of2;
        boolean disposed = false;
        OneFont toRemove = null;
        for (OneFont of2 : existing) {
            if (!of2.getName().equals(fontName) || of2.getHeight() != height || of2.getStyle() != style) continue;
            if (of2.getFont().isDisposed()) {
                disposed = true;
                toRemove = of2;
                break;
            }
            return of2.getFont();
        }
        if (disposed) {
            existing.remove(toRemove);
        }
        of2 = new OneFont(fontName, height, style);
        existing.add(of2);
        return of2.getFont();
    }
}

