/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.tools.codegenerator.ui.popupMenus;

import adaptorinterface.AdaptorInterface;
import adaptorinterface.Specification;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.lyo.tools.codegenerator.ui.Activator;
import org.eclipse.lyo.tools.codegenerator.ui.common.GenerateAll;
import org.eclipse.lyo.tools.codegenerator.ui.popupMenus.DialogServices;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

public class AcceleoGenerateCodegeneratorAction
extends ActionDelegate
implements IActionDelegate {
    protected List<IFile> files;

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.files = ((IStructuredSelection)selection).toList();
        }
    }

    public void generateAdaptorInterface(AdaptorInterface adaptorInterface) {
        File modelProjectFolder = DialogServices.getModellingProjectBaseFolder((EObject)adaptorInterface);
        File generationPath = DialogServices.getGenerationTargetFolder(modelProjectFolder);
        if (generationPath == null) {
            return;
        }
        try {
            GenerateAll generator = new GenerateAll(adaptorInterface, generationPath, this.getArguments());
            generator.doGenerate();
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.lyo.tools.codegenerator.ui", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            DialogServices.showMessage("Exception!", "an Exception occurred during the generation process. Please see the error log.");
        }
    }

    public void generateSpecification(Specification specification) {
        File modelProjectFolder = DialogServices.getModellingProjectBaseFolder((EObject)specification);
        File generationPath = DialogServices.getGenerationTargetFolder(modelProjectFolder);
        if (generationPath == null) {
            return;
        }
        try {
            GenerateAll generator = new GenerateAll(specification, generationPath, this.getArguments());
            generator.doGenerate();
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.lyo.tools.codegenerator.ui", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            DialogServices.showMessage("Exception!", "an Exception occurred during the generation process. Please see the error log.");
        }
    }

    public void run(IAction action) {
        if (this.files != null) {
            for (IFile model : this.files) {
                URI modelURI = URI.createPlatformResourceURI((String)model.getFullPath().toString(), (boolean)true);
                File modelProjectFolder = model.getProject().getLocation().toFile();
                File generationPath = DialogServices.getGenerationTargetFolder(modelProjectFolder);
                if (generationPath == null) {
                    return;
                }
                try {
                    GenerateAll generator = new GenerateAll(modelURI, generationPath, this.getArguments());
                    generator.doGenerate();
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.eclipse.lyo.tools.codegenerator.ui", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                    DialogServices.showMessage("Exception!", "an Exception occurred during the generation process. Please see the error log.");
                }
            }
        }
    }

    protected List<? extends Object> getArguments() {
        return new ArrayList();
    }
}

