/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.editing;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.common.tools.Messages;
import org.eclipse.sirius.common.tools.api.query.NotificationQuery;
import org.eclipse.sirius.common.tools.api.resource.FileModificationValidatorProvider;
import org.eclipse.sirius.common.tools.api.resource.IFileModificationValidator;

public class FileStatusPrecommitListener
extends ResourceSetListenerImpl {
    private final ArrayList<IFileModificationValidator> fileModificationValidators = FileModificationValidatorProvider.INSTANCE.getFileModificationValidator();

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        boolean defensiveEditValidation = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.common.ui", "DEFENSIVE_VALIDATE_EDIT", true, null);
        Command cmd = super.transactionAboutToCommit(event);
        if (defensiveEditValidation) {
            LinkedHashSet changedRes = Sets.newLinkedHashSet();
            if (!event.getTransaction().isReadOnly()) {
                for (Notification notif : Iterables.filter((Iterable)event.getNotifications(), Notification.class)) {
                    Resource res;
                    if (!(notif.getNotifier() instanceof EObject) || !this.resourceChange(res = ((EObject)notif.getNotifier()).eResource(), notif)) continue;
                    changedRes.add(res);
                }
            }
            HashBiMap files2Validate = HashBiMap.create();
            for (Resource nextResource : changedRes) {
                IFile file = WorkspaceSynchronizer.getFile((Resource)nextResource);
                if (file == null || !file.isReadOnly()) continue;
                files2Validate.put((Object)file, (Object)nextResource);
            }
            if (!files2Validate.isEmpty()) {
                RollbackException cancelException = new RollbackException((IStatus)new Status(8, "org.eclipse.sirius.common", Messages.FileStatusPrecommitListener_fileModificationValidationStatus));
                MultiStatus status = new MultiStatus("org.eclipse.sirius.common", 4, Messages.FileStatusPrecommitListener_fileModificationValidationStatus, (Throwable)cancelException);
                if (this.fileModificationValidators.isEmpty()) {
                    status.add(ResourcesPlugin.getWorkspace().validateEdit(files2Validate.keySet().toArray(new IFile[files2Validate.size()]), IWorkspace.VALIDATE_PROMPT));
                } else {
                    for (IFileModificationValidator fileModificationValidator : this.fileModificationValidators) {
                        IStatus validationStatus = fileModificationValidator.validateEdit(files2Validate.keySet());
                        if (validationStatus == null) continue;
                        status.add(validationStatus);
                    }
                }
                if (!status.isOK()) {
                    throw cancelException;
                }
            }
        }
        return cmd;
    }

    protected boolean resourceChange(Resource resource, Notification notif) {
        return resource != null && !new NotificationQuery(notif).isTransientNotification();
    }
}

