/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramActionBarContributor;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.HideDDiagramElementLabelAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.contributions.SiriusTabbarExtensionContributionFactory;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class HideDDiagramElementLabelActionContributionItem
extends SiriusTabbarExtensionContributionFactory.TabbarActionContributionItem
implements ISelectionListener {
    private boolean canEdit = true;

    public HideDDiagramElementLabelActionContributionItem(IWorkbenchPart part) {
        super((IAction)new HideDDiagramElementLabelAction(SiriusDiagramActionBarContributor.HIDE_LABEL), part);
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public void update(String propertyName) {
        this.updateCanEdit();
        boolean isEnabled = false;
        ISelection selection = this.representationPart.getSite().getPage().getSelection();
        if (selection instanceof IStructuredSelection) {
            isEnabled = HideDDiagramElementLabelAction.isEnabled(((IStructuredSelection)selection).toList());
        }
        this.getAction().setEnabled(isEnabled && this.canEdit);
        super.update(propertyName);
    }

    private void updateCanEdit() {
        DDiagramEditor editor;
        boolean canEditInstance = true;
        if (this.representationPart instanceof DDiagramEditor && (editor = (DDiagramEditor)this.representationPart) != null && editor.getRepresentation() != null) {
            DDiagram editorDiagram = (DDiagram)editor.getRepresentation();
            Resource sessionResource = editor.getSession().getSessionResource();
            if (sessionResource != null) {
                IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(sessionResource.getResourceSet());
                canEditInstance = permissionAuthority.canEditInstance((EObject)editorDiagram);
            }
        }
        this.setCanEdit(canEditInstance);
    }
}

