/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.gef.ui.internal.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;

public class DiamondFigure
extends NodeFigure
implements IPolygonAnchorableFigure {
    public DiamondFigure(Dimension dim) {
        this.setPreferredSize(dim);
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle r = new Rectangle();
        PointList pointList = new PointList();
        r.x = this.bounds.x;
        r.y = this.bounds.y;
        r.width = this.bounds.width - 1;
        r.height = this.bounds.height - 1;
        pointList.removeAllPoints();
        pointList.addPoint(r.x + r.width / 2, r.y);
        pointList.addPoint(r.x + r.width, r.y + r.height / 2);
        pointList.addPoint(r.x + r.width / 2, r.y + r.height);
        pointList.addPoint(r.x, r.y + r.height / 2);
        graphics.fillPolygon(pointList);
        graphics.drawPolygon(pointList);
    }

    public PointList getPolygonPoints() {
        PointList ptList = new PointList();
        ptList.addPoint(new Point(this.getBounds().x + this.getBounds().width / 2, this.getBounds().y));
        ptList.addPoint(new Point(this.getBounds().x + this.getBounds().width, this.getBounds().y + this.getBounds().height / 2));
        ptList.addPoint(new Point(this.getBounds().x + this.getBounds().width / 2, this.getBounds().y + this.getBounds().height));
        ptList.addPoint(new Point(this.getBounds().x, this.getBounds().y + this.getBounds().height / 2));
        ptList.addPoint(new Point(this.getBounds().x + this.getBounds().width / 2, this.getBounds().y));
        return ptList;
    }

    protected double getSlidableAnchorArea() {
        return 0.7;
    }
}

