/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task.operations;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.internal.helper.task.IDeletionTask;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.DeleteView;
import org.eclipse.sirius.viewpoint.description.tool.RemoveElement;

public class RemoveElementTask
extends AbstractOperationTask
implements IDeletionTask {
    private EObject toBeRemoved;
    private boolean deleteView;

    public RemoveElementTask(CommandContext context, ModelAccessor extPackage, RemoveElement op, IInterpreter interpreter) {
        super(context, extPackage, interpreter);
    }

    public RemoveElementTask(ModelAccessor extPackage, CommandContext context, DeleteView op, IInterpreter interpreter) {
        super(context, extPackage, interpreter);
        this.deleteView = true;
    }

    @Override
    public void execute() {
        this.toBeRemoved = this.context.getCurrentTarget();
        if (this.deleteView && !(this.toBeRemoved instanceof DRepresentationElement)) {
            SiriusPlugin.getDefault().warning(Messages.RemoveElementTask_notAViewErrorMsg, new IllegalArgumentException());
            return;
        }
        if (this.toBeRemoved != null && this.toBeRemoved.eContainingFeature() != null) {
            SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(this.toBeRemoved).eRemove(this.toBeRemoved);
        }
    }

    @Override
    public String getLabel() {
        return Messages.RemoveElementTask_label;
    }

    @Override
    public Collection<EObject> getDeletedElements() {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (this.toBeRemoved != null) {
            result.add(this.toBeRemoved);
            TreeIterator it = this.toBeRemoved.eAllContents();
            while (it.hasNext()) {
                result.add((EObject)it.next());
            }
        }
        return result;
    }
}

