/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.migration.resource;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public final class MigrationUtil {
    public static boolean ignoreVersionMismatch;
    public static final String MODELER_DESCRIPTION_FILE_EXTENSION_V3 = "air";
    private static final String UTF_8 = "UTF-8";
    private static final String DOT = ".";

    private MigrationUtil() {
    }

    public static EClass findEClass(EPackage root, String className) {
        EClassifier found = root.getEClassifier(className);
        EClass clazz = null;
        if (found instanceof EClass) {
            clazz = (EClass)found;
        } else {
            for (EPackage subPackage : root.getESubpackages()) {
                found = MigrationUtil.findEClass(subPackage, className);
                if (found == null) continue;
                return (EClass)found;
            }
        }
        return clazz;
    }

    public static EStructuralFeature getEStructuralFeature(Map<String, String> featureMappings, EClass eClass, String name) {
        String className = eClass.getName();
        String featureName = String.valueOf(className) + DOT + name;
        if (featureMappings.containsKey(featureName) || featureMappings.containsKey(name)) {
            String qualifiedAttributeName = featureMappings.get(featureName);
            if (qualifiedAttributeName == null) {
                qualifiedAttributeName = featureMappings.get(name);
            }
            String[] decomposedName = qualifiedAttributeName.split(Pattern.quote(DOT));
            assert (decomposedName.length == 2) : Messages.MigrationUtil_invalidMappingErrorMsg;
            EStructuralFeature result = null;
            EClass classifier = MigrationUtil.findEClass(eClass.getEPackage(), decomposedName[0]);
            result = classifier.getEStructuralFeature(decomposedName[1]);
            return result;
        }
        return null;
    }

    public static Map<String, String> loadProperties(Class<?> clazz, String resourceName) {
        Properties result;
        block12: {
            result = new Properties();
            BufferedInputStream in = new BufferedInputStream(clazz.getResourceAsStream(resourceName));
            try {
                try {
                    result.load(in);
                }
                catch (IOException e) {
                    SiriusPlugin.getDefault().error(Messages.MigrationUtil_IOErrorMsg, e);
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e2) {
                        SiriusPlugin.getDefault().error(Messages.MigrationUtil_IOErrorMsg, e2);
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    SiriusPlugin.getDefault().error(Messages.MigrationUtil_IOErrorMsg, e);
                }
                throw throwable;
            }
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                SiriusPlugin.getDefault().error(Messages.MigrationUtil_IOErrorMsg, e);
            }
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : result.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            resultMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return resultMap;
    }

    public static String getContents(File file, IProgressMonitor monitor) {
        monitor.subTask(Messages.MigrationUtil_loadingMsg);
        if (file.length() > Integer.MAX_VALUE) {
            SiriusPlugin.getDefault().error(Messages.MigrationUtil_toBigErrorMsg, null);
        } else {
            byte[] b;
            block24: {
                int fileLenght = (int)file.length();
                b = new byte[fileLenght];
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    int total = 0;
                    while ((long)total < file.length()) {
                        int result = ((InputStream)in).read(b, total, fileLenght - total);
                        if (result != -1) {
                            total += result;
                            continue;
                        }
                        break;
                    }
                }
                catch (FileNotFoundException e) {
                    SiriusPlugin.getDefault().error(e.getMessage(), e);
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e2) {
                            SiriusPlugin.getDefault().error(e2.getMessage(), e2);
                        }
                    }
                    break block24;
                }
                catch (IOException e) {
                    try {
                        SiriusPlugin.getDefault().error(e.getMessage(), e);
                        break block24;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (in != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException e3) {
                                SiriusPlugin.getDefault().error(e3.getMessage(), e3);
                            }
                        }
                    }
                }
                if (in == null) break block24;
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    SiriusPlugin.getDefault().error(e.getMessage(), e);
                }
            }
            monitor.worked(1);
            try {
                return new String(b, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                SiriusPlugin.getDefault().error(e.getMessage(), e);
            }
        }
        monitor.worked(1);
        return "";
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void persitContents(File file, String contents) {
        OutputStream outputStream = null;
        try {
            try {
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                outputStream.write(contents.getBytes(UTF_8));
                return;
            }
            catch (FileNotFoundException e) {
                SiriusPlugin.getDefault().error(e.getMessage(), e);
                if (outputStream == null) return;
                try {
                    outputStream.close();
                    return;
                }
                catch (IOException e2) {
                    SiriusPlugin.getDefault().error(e2.getMessage(), e2);
                }
                return;
            }
            catch (UnsupportedEncodingException e) {
                SiriusPlugin.getDefault().error(e.getMessage(), e);
                if (outputStream == null) return;
                try {
                    outputStream.close();
                    return;
                }
                catch (IOException e3) {
                    SiriusPlugin.getDefault().error(e3.getMessage(), e3);
                }
                return;
            }
            catch (IOException e) {
                SiriusPlugin.getDefault().error(e.getMessage(), e);
                if (outputStream == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    outputStream.close();
                    return;
                }
                catch (IOException e4) {
                    SiriusPlugin.getDefault().error(e4.getMessage(), e4);
                }
                return;
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    SiriusPlugin.getDefault().error(e.getMessage(), e);
                }
            }
        }
    }

    public static abstract class AbstractMigrationResourceHandler
    extends BasicResourceHandler {
        public void postLoad(XMLResource resource, InputStream inputStream, Map<?, ?> options) {
            super.postLoad(resource, inputStream, options);
            this.handleUnknownData(resource);
        }

        protected void handleUnknownData(XMLResource resource) {
            Map extMap = resource.getEObjectToExtensionMap();
            for (Map.Entry entry : extMap.entrySet()) {
                this.handleUnknownData((EObject)entry.getKey(), (AnyType)entry.getValue());
            }
        }

        private void handleUnknownData(EObject eObj, AnyType unknownData) {
            this.handleUnknownFeatures(eObj, unknownData.getMixed());
            this.handleUnknownFeatures(eObj, unknownData.getAnyAttribute());
        }

        private void handleUnknownFeatures(EObject owner, FeatureMap featureMap) {
            Iterator iter = featureMap.iterator();
            while (iter.hasNext()) {
                FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
                if (!this.handleFeature(owner, entry)) continue;
                iter.remove();
            }
        }

        protected abstract boolean handleFeature(EObject var1, FeatureMap.Entry var2);
    }
}

