/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistryListener;
import org.eclipse.sirius.ext.base.Option;

public class DynamicVSMLoader
implements ViewpointRegistryListener {
    private final ViewpointRegistry registry;
    private final ResourceSet resourceSet;
    private final Set<URI> requiredViewpoints = Sets.newHashSet();
    private final Set<URI> requiredProviders = Sets.newHashSet();
    private final Set<URI> protectedResources = Sets.newHashSet();
    private Runnable errorHandler;

    public DynamicVSMLoader(ResourceSet resourceSet, ViewpointRegistry registry) {
        this.resourceSet = (ResourceSet)Preconditions.checkNotNull((Object)resourceSet);
        this.registry = (ViewpointRegistry)Preconditions.checkNotNull((Object)registry);
        this.registry.addListener(this);
    }

    public ViewpointRegistry getRegistry() {
        return this.registry;
    }

    public Set<URI> getRequiredViewpoints() {
        return this.requiredViewpoints;
    }

    public synchronized void setErrorHandler(Runnable errorHandler) {
        this.errorHandler = errorHandler;
    }

    public synchronized void protect(URI uri) {
        this.protectedResources.add((URI)Preconditions.checkNotNull((Object)uri));
    }

    public synchronized void unprotect(URI uri) {
        this.protectedResources.remove(Preconditions.checkNotNull((Object)uri));
    }

    public synchronized void require(URI viewpoint) {
        Preconditions.checkNotNull((Object)viewpoint);
        Option<URI> provider = this.registry.getProvider(viewpoint);
        Preconditions.checkState((boolean)provider.some(), (Object)MessageFormat.format("The specified viewpoint {0} is not available.", viewpoint.toString()));
        boolean added = this.requiredViewpoints.add(viewpoint);
        if (added) {
            this.refresh();
        }
    }

    public synchronized void unrequire(URI viewpoint) {
        boolean removed = this.requiredViewpoints.remove(Preconditions.checkNotNull((Object)viewpoint));
        if (removed) {
            this.refresh();
        }
    }

    public void dispose() {
        this.registry.removeListener(this);
    }

    @Override
    public synchronized void registryChanged(ViewpointRegistry reg, Set<URI> removed, Set<URI> added, Set<URI> changed) {
        assert (reg == this.registry);
        Sets.SetView absentRequirements = Sets.intersection(this.requiredViewpoints, removed);
        if (!absentRequirements.isEmpty()) {
            if (this.errorHandler != null) {
                this.errorHandler.run();
            } else {
                throw new IllegalStateException("The required viewpoints " + Joiner.on((String)", ").join((Iterable)absentRequirements) + " are not available anymore.");
            }
        }
        this.refresh();
    }

    private void refresh() {
        Set<URI> providers = this.computeRequiredProviders();
        Set<Resource> maybeUnneeded = this.getAndUnloadPotentialUnneededProviders(providers);
        this.loadAndResolve(providers);
        this.removeUnneededResources(maybeUnneeded);
        this.setRequiredProviders(providers);
    }

    private Set<URI> computeRequiredProviders() {
        HashSet newProviders = Sets.newHashSet();
        for (URI uri : this.requiredViewpoints) {
            Option<URI> provider = this.registry.getProvider(uri);
            assert (provider.some());
            newProviders.add((URI)provider.get());
        }
        return newProviders;
    }

    private Set<Resource> getAndUnloadPotentialUnneededProviders(Set<URI> required) {
        HashSet maybeUnneeded = Sets.newHashSet();
        for (Resource res : this.resourceSet.getResources()) {
            if (required.contains(res.getURI()) || !res.getURI().isPlatform() || this.protectedResources.contains(res.getURI())) continue;
            maybeUnneeded.add(res);
            res.unload();
        }
        return maybeUnneeded;
    }

    private void loadAndResolve(Set<URI> providers) {
        for (URI uri : providers) {
            if (this.requiredProviders.contains(uri)) continue;
            Resource res = this.resourceSet.getResource(uri, true);
            EcoreUtil.resolveAll((Resource)res);
        }
    }

    private void removeUnneededResources(Set<Resource> maybeUnneeded) {
        for (Resource resource : maybeUnneeded) {
            if (resource.isLoaded()) continue;
            this.resourceSet.getResources().remove((Object)resource);
        }
    }

    private void setRequiredProviders(Set<URI> newProviders) {
        this.requiredProviders.clear();
        this.requiredProviders.addAll(newProviders);
    }
}

