/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.dialect.marker;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.ui.tools.internal.views.common.SessionLabelProvider;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.ide.IGotoMarker;

public class TraceabilityMarkerNavigationProvider
implements IGotoMarker {
    public static final String INTERNAL_REPRESENTATION_URI = "DIAGRAM_URI";
    public static final String REPRESENTATION_ELEMENT_ID = "REPRESENTATION_ELEMENT_ID";
    public static final String REPRESENTATION_URI = "REPRESENTATION_URI";
    public static final String TRACEABILITY_SEMANTIC_ELEMENT_URI_ATTRIBUTE = "uri";
    private static final String TRACEABILITY_INTERNAL_ATTRIBUTE = "traceab_viewpoint_ghost";
    private Option<DialectEditor> currentEditor = Options.newNone();
    private DialectEditor editorToFocus;
    private DRepresentation representationToFocus;
    private DRepresentationElement representationElementToSelect;
    private Session currentSession;

    public TraceabilityMarkerNavigationProvider(DialectEditor editor) {
        this.currentEditor = Options.newSome((Object)editor);
        Session foundSession = null;
        for (IEditingSession uiSession : SessionUIManager.INSTANCE.getUISessions()) {
            if (!this.currentEditor.some() || !uiSession.handleEditor((IEditorPart)this.currentEditor.get())) continue;
            foundSession = uiSession.getSession();
        }
        if (foundSession == null) {
            String editorTitle = "";
            if (this.currentEditor.some()) {
                editorTitle = ((DialectEditor)this.currentEditor.get()).getTitle();
            }
            throw new IllegalArgumentException(MessageFormat.format(Messages.TraceabilityMarkerNavigationProvider_noSessionFoundError, editorTitle));
        }
        this.currentSession = foundSession;
    }

    public TraceabilityMarkerNavigationProvider(Session session) {
        this.currentSession = session;
    }

    public static boolean isTraceabilityMarker(IMarker marker) {
        String elementURI = marker.getAttribute(TRACEABILITY_SEMANTIC_ELEMENT_URI_ATTRIBUTE, null);
        String internalAttribute = marker.getAttribute(TRACEABILITY_INTERNAL_ATTRIBUTE, null);
        return elementURI != null && internalAttribute == null;
    }

    public void gotoMarker(final IMarker marker) {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TraceabilityMarkerNavigationProvider.this.gotoMarkerInUIThread(marker);
                }
            });
        } else {
            this.gotoMarkerInUIThread(marker);
        }
    }

    protected void gotoMarkerInUIThread(IMarker marker) {
        if (this.isMasterEditorCall() || !this.currentEditor.some()) {
            TransactionalEditingDomain editingDomain = this.currentSession.getTransactionalEditingDomain();
            EObject semanticElement = null;
            String traceabilityAttribute = marker.getAttribute(TRACEABILITY_SEMANTIC_ELEMENT_URI_ATTRIBUTE, null);
            if (traceabilityAttribute != null) {
                URI uri = URI.createURI((String)traceabilityAttribute);
                semanticElement = editingDomain.getResourceSet().getEObject(uri, true);
                boolean foundEditor = false;
                IEditorPart activeEditor = EclipseUIUtil.getActiveEditor();
                if (activeEditor instanceof DialectEditor && ((DialectEditor)activeEditor).getRepresentation() != null) {
                    foundEditor = this.searchInEditor((DialectEditor)activeEditor, semanticElement);
                }
                if (!foundEditor) {
                    foundEditor = this.searchInAllOpenedEditorOnCurrentActiveSession(semanticElement);
                }
                if (foundEditor) {
                    this.setFocusOnEditor(marker);
                } else {
                    this.searchInAllRepresentationsOfCurrentActiveSession(marker, semanticElement);
                }
            }
        }
    }

    private boolean isMasterEditorCall() {
        IWorkbenchPage activePage = EclipseUIUtil.getActivePage();
        if (this.currentEditor.some() && activePage != null) {
            IEditorReference[] editorReferences;
            IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                if (editorRef.getEditor(false) instanceof DialectEditor) {
                    return editorRef.getEditor(false).equals(this.currentEditor.get());
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean searchInEditor(DialectEditor editor, EObject semanticElement) {
        boolean foundEditor = false;
        if (editor.getRepresentation().eCrossReferences().contains((Object)semanticElement)) {
            foundEditor = true;
        } else {
            for (DRepresentationElement representationElement : editor.getRepresentation().getRepresentationElements()) {
                if (!this.representationElementReferencesSemanticElement(representationElement, semanticElement)) continue;
                this.representationElementToSelect = representationElement;
                foundEditor = true;
                break;
            }
        }
        if (foundEditor) {
            this.editorToFocus = editor;
            this.representationToFocus = editor.getRepresentation();
        }
        return foundEditor;
    }

    private boolean representationElementReferencesSemanticElement(DRepresentationElement representationElement, EObject semanticElement) {
        return representationElement.eCrossReferences().contains((Object)semanticElement);
    }

    private void setFocusOnEditor(IMarker marker) {
        block20: {
            Resource resource = this.representationToFocus.eResource();
            URI uri = resource.getURI();
            uri = resource.getResourceSet().getURIConverter().normalize(uri);
            IWorkspaceRoot res = null;
            if (uri.isPlatformPlugin()) {
                String pluginResourceString = uri.toString();
                if (pluginResourceString != null) {
                    res = ResourcesPlugin.getWorkspace().getRoot();
                }
            } else {
                String platformResourceString = uri.toPlatformString(true);
                if (platformResourceString != null) {
                    res = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourceString));
                }
            }
            if (res != null) {
                IMarker shadowMarker = null;
                try {
                    try {
                        shadowMarker = res.createMarker(marker.getType());
                        shadowMarker.setAttribute(TRACEABILITY_SEMANTIC_ELEMENT_URI_ATTRIBUTE, (Object)EcoreUtil.getURI((EObject)this.representationToFocus).toString());
                        if (this.representationElementToSelect != null) {
                            shadowMarker.setAttribute(REPRESENTATION_ELEMENT_ID, (Object)resource.getURIFragment((EObject)this.representationElementToSelect).toString());
                        }
                        shadowMarker.setAttribute(REPRESENTATION_URI, (Object)EcoreUtil.getURI((EObject)this.representationToFocus).toString());
                        shadowMarker.setAttribute(TRACEABILITY_INTERNAL_ATTRIBUTE, (Object)"active");
                        this.editorToFocus.setFocus();
                        this.editorToFocus.gotoMarker(shadowMarker);
                    }
                    catch (CoreException coreException) {
                        if (shadowMarker != null) {
                            try {
                                shadowMarker.delete();
                            }
                            catch (CoreException coreException2) {}
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (shadowMarker != null) {
                        try {
                            shadowMarker.delete();
                        }
                        catch (CoreException coreException) {}
                    }
                    throw throwable;
                }
                if (shadowMarker != null) {
                    try {
                        shadowMarker.delete();
                    }
                    catch (CoreException coreException) {}
                }
            }
        }
    }

    private boolean searchInAllOpenedEditorOnCurrentActiveSession(EObject semanticElement) {
        boolean found = false;
        IEditorReference[] editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < editorReferences.length && !found) {
            IEditingSession uiCurrentSession;
            DialectEditor editor;
            IEditorPart openedEditor = editorReferences[i].getEditor(false);
            if (openedEditor instanceof DialectEditor && this.currentSession != null && (editor = (uiCurrentSession = SessionUIManager.INSTANCE.getOrCreateUISession(this.currentSession)).getEditor(((DialectEditor)openedEditor).getRepresentation())) != null) {
                found = this.searchInEditor((DialectEditor)openedEditor, semanticElement);
            }
            ++i;
        }
        return found;
    }

    private void searchInAllRepresentationsOfCurrentActiveSession(IMarker initialMarker, EObject semanticElement) {
        if (this.currentSession != null) {
            LinkedHashSet candidateRepresentations = Sets.newLinkedHashSet();
            HashMap representationToElements = Maps.newHashMap();
            block0: for (DRepresentation representation : DialectManager.INSTANCE.getAllRepresentations(this.currentSession)) {
                if (representation.eCrossReferences().contains((Object)semanticElement)) {
                    candidateRepresentations.add(representation);
                    break;
                }
                for (DRepresentationElement representationElement : representation.getRepresentationElements()) {
                    if (!this.representationElementReferencesSemanticElement(representationElement, semanticElement)) continue;
                    candidateRepresentations.add(representation);
                    representationToElements.put(representation, representationElement);
                    continue block0;
                }
            }
            this.askUserForRepresentationsToOpen(initialMarker, candidateRepresentations, representationToElements, semanticElement);
        }
    }

    private void askUserForRepresentationsToOpen(final IMarker initialMarker, Set<DRepresentation> candidateRepresentations, final Map<DRepresentation, DRepresentationElement> representationToElements, EObject semanticElement) {
        if (!candidateRepresentations.isEmpty()) {
            Object[] selectedRepresentations = new Object[]{};
            if (candidateRepresentations.size() > 1) {
                RepresentationToOpenDialog dialog = new RepresentationToOpenDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.currentSession, candidateRepresentations, semanticElement);
                dialog.setInput(this.currentSession);
                int result = dialog.open();
                if (result == 0) {
                    selectedRepresentations = dialog.getResult();
                }
            } else {
                selectedRepresentations = candidateRepresentations.toArray();
            }
            if (selectedRepresentations.length > 0) {
                final IEditingSession uiSession = SessionUIManager.INSTANCE.getOrCreateUISession(this.currentSession);
                Object[] objectArray = selectedRepresentations;
                int n = selectedRepresentations.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selectedRepresentation2 = objectArray[n2];
                    final DRepresentation selectedRepresentation = (DRepresentation)selectedRepresentation2;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IEditorPart editor = DialectUIManager.INSTANCE.openEditor(TraceabilityMarkerNavigationProvider.this.currentSession, selectedRepresentation, (IProgressMonitor)new NullProgressMonitor());
                            if (editor != null && uiSession != null) {
                                uiSession.attachEditor((DialectEditor)editor);
                            }
                            TraceabilityMarkerNavigationProvider.this.editorToFocus = (DialectEditor)editor;
                            TraceabilityMarkerNavigationProvider.this.representationToFocus = selectedRepresentation;
                            TraceabilityMarkerNavigationProvider.this.representationElementToSelect = (DRepresentationElement)representationToElements.get(selectedRepresentation);
                            TraceabilityMarkerNavigationProvider.this.setFocusOnEditor(initialMarker);
                        }
                    });
                    ++n2;
                }
            }
        }
    }

    private class CandidateRepresentationContentProvider
    implements ITreeContentProvider {
        private Set<DRepresentation> candidateRepresentations;
        private Session session;

        CandidateRepresentationContentProvider(AdapterFactory createAdapterFactory, Set<DRepresentation> representations, Session session) {
            this.candidateRepresentations = representations;
            this.session = session;
        }

        public Object[] getElements(Object inputElement) {
            return this.candidateRepresentations.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Session) {
                return this.candidateRepresentations.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return this.session;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Session;
        }
    }

    private class RepresentationToOpenDialog
    extends CheckedTreeSelectionDialog {
        RepresentationToOpenDialog(Shell parent, Session session, Set<DRepresentation> candidateRepresentations, EObject semanticElement) {
            super(parent, (ILabelProvider)new SessionLabelProvider(ViewHelper.INSTANCE.createAdapterFactory()), (ITreeContentProvider)new CandidateRepresentationContentProvider(ViewHelper.INSTANCE.createAdapterFactory(), candidateRepresentations, session));
            SessionLabelProvider labelProvider = new SessionLabelProvider(ViewHelper.INSTANCE.createAdapterFactory());
            String objectName = labelProvider.getText(semanticElement);
            this.setTitle(MessageFormat.format(Messages.TraceabilityMarkerNavigationProvider_dialogTitle, objectName));
            this.setMessage(MessageFormat.format(Messages.TraceabilityMarkerNavigationProvider_dialogMessage, objectName));
        }
    }
}

