/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.dialect.editor;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.sirius.business.internal.session.danalysis.DanglingRefRemovalTrigger;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class DialectEditorCloserFilter
extends NotificationFilter.Custom {
    private DRepresentationDescriptor dRepDescriptor;

    public DialectEditorCloserFilter(DRepresentationDescriptor dRepresentationDescriptor) {
        Assert.isNotNull((Object)dRepresentationDescriptor);
        this.dRepDescriptor = dRepresentationDescriptor;
    }

    public boolean matches(Notification notification) {
        return !notification.isTouch() && (this.isTargetUnset(notification) || this.isRepresentationDeletion(notification) || this.isTargetDetachment(notification));
    }

    private void resolveDRepDescriptorProxy(Notification notification) {
        if (this.dRepDescriptor.eIsProxy()) {
            this.dRepDescriptor = Optional.ofNullable(notification.getNotifier()).filter(EObject.class::isInstance).map(EObject.class::cast).map(eObject -> eObject.eResource()).map(eResource -> eResource.getResourceSet()).map(resourceSet -> resourceSet.getEObject(EcoreUtil.getURI((EObject)this.dRepDescriptor), false)).filter(DRepresentationDescriptor.class::isInstance).map(DRepresentationDescriptor.class::cast).orElse(this.dRepDescriptor);
        }
    }

    private boolean isTargetUnset(Notification notification) {
        boolean remove;
        boolean bl = remove = notification.getEventType() == 4 || notification.getEventType() == 2;
        return remove && notification.getNotifier() == this.dRepDescriptor && notification.getFeature() == ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__TARGET;
    }

    private boolean isRepresentationDeletion(Notification notification) {
        boolean representationDeleted = false;
        this.resolveDRepDescriptorProxy(notification);
        if (notification.getFeature() == ViewpointPackage.Literals.DVIEW__OWNED_REPRESENTATION_DESCRIPTORS && this.wasInOldValue(notification, (EObject)this.dRepDescriptor)) {
            representationDeleted = !(this.dRepDescriptor.eContainer() instanceof DView);
        } else if (notification.getFeature() == ViewpointPackage.Literals.DANALYSIS__OWNED_VIEWS && this.wasInOldValue(notification, this.dRepDescriptor.eContainer())) {
            representationDeleted = this.dRepDescriptor.eContainer() == null || this.dRepDescriptor.eContainer() == null || !(this.dRepDescriptor.eContainer().eContainer() instanceof DView);
        } else if (notification.getFeature() == ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__REPRESENTATION) {
            representationDeleted = notification.getNewValue() == null && notification.getOldValue() != null && notification.getNotifier() == this.dRepDescriptor;
        }
        return representationDeleted;
    }

    private boolean wasInOldValue(Notification notification, EObject eObject) {
        boolean isCurrentDRepresentationRemove = false;
        int eventType = notification.getEventType();
        if (eventType == 4 || eventType == 2 || eventType == 6) {
            isCurrentDRepresentationRemove = this.isInOldValue(notification, eObject);
        }
        return isCurrentDRepresentationRemove;
    }

    private boolean isInOldValue(Notification notification, EObject obj) {
        if (notification.getOldValue() instanceof Collection) {
            return ((Collection)notification.getOldValue()).contains(obj);
        }
        return notification.getOldValue() == obj;
    }

    private boolean isTargetDetachment(Notification notification) {
        boolean detachedTarget = false;
        if (DanglingRefRemovalTrigger.IS_DETACHMENT.apply((Object)notification)) {
            this.resolveDRepDescriptorProxy(notification);
            DRepresentation representation = this.dRepDescriptor.getRepresentation();
            if (representation instanceof DSemanticDecorator) {
                EObject target = ((DSemanticDecorator)this.dRepDescriptor.getRepresentation()).getTarget();
                detachedTarget = this.isInOldValue(notification, target) && target.eContainer() == null;
            }
        }
        return detachedTarget;
    }
}

