/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;

public class UserInterfaceManager {
    private Map<Class<? extends RefactoringProcessor>, Tuple> fMap = new HashMap<Class<? extends RefactoringProcessor>, Tuple>();

    protected void put(Class<? extends RefactoringProcessor> processor, Class<? extends UserInterfaceStarter> starter, Class<? extends RefactoringWizard> wizard) {
        this.fMap.put(processor, new Tuple(starter, wizard));
    }

    public UserInterfaceStarter getStarter(Refactoring refactoring) {
        RefactoringProcessor processor = (RefactoringProcessor)refactoring.getAdapter(RefactoringProcessor.class);
        if (processor == null) {
            return null;
        }
        Tuple tuple = this.fMap.get(processor.getClass());
        if (tuple == null) {
            return null;
        }
        try {
            UserInterfaceStarter starter = (UserInterfaceStarter)tuple.starter.newInstance();
            Class wizardClass = tuple.wizard;
            Constructor constructor = wizardClass.getConstructor(Refactoring.class);
            RefactoringWizard wizard = (RefactoringWizard)constructor.newInstance(refactoring);
            starter.initialize(wizard);
            return starter;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    private static class Tuple {
        private Class<? extends UserInterfaceStarter> starter;
        private Class<? extends RefactoringWizard> wizard;

        public Tuple(Class<? extends UserInterfaceStarter> s, Class<? extends RefactoringWizard> w) {
            this.starter = s;
            this.wizard = w;
        }
    }
}

