/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.delegate;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicSettingDelegate;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.delegate.OCLDelegateDomain;
import org.eclipse.ocl.ecore.delegate.OCLDelegateException;
import org.eclipse.ocl.ecore.delegate.SettingBehavior;
import org.eclipse.ocl.ecore.delegate.ValueConverter;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.osgi.util.NLS;

public class OCLSettingDelegate
extends BasicSettingDelegate.Stateless {
    protected final OCLDelegateDomain delegateDomain;
    private OCLExpression derivation;
    private ValueConverter converter;

    public OCLSettingDelegate(OCLDelegateDomain delegateDomain, EStructuralFeature structuralFeature) {
        super(structuralFeature);
        this.delegateDomain = delegateDomain;
        this.converter = structuralFeature.isMany() ? ValueConverter.LIST : ValueConverter.VERBATIM;
    }

    protected Object get(InternalEObject owner, boolean resolve, boolean coreType) {
        OCL ocl = this.delegateDomain.getOCL();
        if (this.derivation == null) {
            this.derivation = SettingBehavior.INSTANCE.getFeatureBody(ocl, this.eStructuralFeature);
        }
        if (this.derivation == null) {
            String message = NLS.bind((String)OCLMessages.MissingDerivationForSettingDelegate_ERROR_, (Object)this.getFeatureName());
            throw new OCLDelegateException(message);
        }
        Query query = ocl.createQuery(this.derivation);
        Object result = query.evaluate((Object)owner);
        if (ocl.isInvalid(result)) {
            String message = NLS.bind((String)OCLMessages.EvaluationResultIsInvalid_ERROR_, (Object)this.getFeatureName());
            throw new OCLDelegateException(message);
        }
        return this.converter.convert(ocl, result);
    }

    public String getFeatureName() {
        return String.valueOf(this.eStructuralFeature.getEContainingClass().getEPackage().getName()) + "::" + this.eStructuralFeature.getEContainingClass().getName() + "." + this.eStructuralFeature.getName();
    }

    protected boolean isSet(InternalEObject owner) {
        return false;
    }

    public String toString() {
        return "<" + this.delegateDomain.getURI() + ":setting> " + this.getFeatureName();
    }

    public static class Changeable
    extends OCLSettingDelegate {
        private Map<InternalEObject, Object> valueMap = null;

        public Changeable(OCLDelegateDomain delegateDomain, EStructuralFeature structuralFeature) {
            super(delegateDomain, structuralFeature);
        }

        protected Object get(InternalEObject owner, boolean resolve, boolean coreType) {
            if (this.valueMap != null && this.valueMap.containsKey(owner)) {
                return this.valueMap.get(owner);
            }
            return super.get(owner, resolve, coreType);
        }

        protected boolean isSet(InternalEObject owner) {
            return this.valueMap != null && this.valueMap.containsKey(owner);
        }

        protected void set(InternalEObject owner, Object newValue) {
            if (owner != null) {
                if (this.valueMap == null) {
                    this.valueMap = new HashMap<InternalEObject, Object>();
                }
                this.valueMap.put(owner, newValue);
            }
        }

        protected void unset(InternalEObject owner) {
            if (this.valueMap != null) {
                this.valueMap.remove(owner);
            }
        }
    }
}

