/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.query;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.util.Range;

public class RangeComparator
implements Comparator<ISequenceElement>,
Serializable {
    private static final long serialVersionUID = -8968333614931292746L;

    @Override
    public int compare(ISequenceElement sequenceElement1, ISequenceElement sequenceElement2) {
        Range sequenceElement1Range = RangeHelper.verticalRange(sequenceElement1.getProperLogicalBounds());
        Range sequenceElement2Range = RangeHelper.verticalRange(sequenceElement2.getProperLogicalBounds());
        int comparison = sequenceElement1Range.getLowerBound() - sequenceElement2Range.getLowerBound();
        if (comparison == 0 && sequenceElement1 instanceof ISequenceEvent && sequenceElement2 instanceof ISequenceEvent) {
            ISequenceEvent sequenceEvent1 = (ISequenceEvent)sequenceElement1;
            ISequenceEvent sequenceEvent2 = (ISequenceEvent)sequenceElement2;
            SequenceDiagram sequenceDiagram = sequenceElement1.getDiagram();
            List<EventEnd> sequenceEvent1EventEnds = sequenceDiagram.findEnds(sequenceEvent1);
            List<EventEnd> sequenceEvent2EventEnds = sequenceDiagram.findEnds(sequenceEvent2);
            if (!sequenceEvent1EventEnds.isEmpty() && !sequenceEvent2EventEnds.isEmpty()) {
                EventEnd firstEventEndOfSequenceEvent1 = sequenceEvent1EventEnds.get(0);
                EventEnd firstEventEndOfSequenceEvent2 = sequenceEvent2EventEnds.get(0);
                EList<EventEnd> eventEnds = sequenceDiagram.getSequenceDDiagram().getGraphicalOrdering().getEventEnds();
                comparison = eventEnds.indexOf(firstEventEndOfSequenceEvent1) - eventEnds.indexOf(firstEventEndOfSequenceEvent2);
            }
        }
        return comparison;
    }
}

