/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.EObjectCouple;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.query.ContainerMappingQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.IContainerMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.SiriusElementMappingSpecOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DiagramElementMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.StyleHelper;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

public final class ContainerMappingHelper {
    private IInterpreter interpreter;

    public ContainerMappingHelper(IInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public static Collection<NodeMapping> getAllNodeMappings(ContainerMapping self) {
        return Sets.union((Set)Sets.newLinkedHashSet(self.getSubNodeMappings()), (Set)Sets.newLinkedHashSet(self.getReusedNodeMappings()));
    }

    public static Collection<ContainerMapping> getAllContainerMappings(ContainerMapping self) {
        return Sets.union((Set)Sets.newLinkedHashSet(self.getSubContainerMappings()), (Set)Sets.newLinkedHashSet(self.getReusedContainerMappings()));
    }

    public static void clearDNodesDone(IContainerMappingExt self) {
        self.getViewContainerDone().clear();
        self.getCandidatesCache().clear();
    }

    public static EList<DDiagramElement> findDNodeFromEObject(IContainerMappingExt self, EObject object) {
        BasicEList result = self.getViewContainerDone().get(object);
        if (result == null) {
            result = new BasicEList();
        }
        return result;
    }

    public static void addDoneNode(IContainerMappingExt self, DSemanticDecorator node) {
        BasicEList list = self.getViewContainerDone().get(node.getTarget());
        if (list == null) {
            list = new BasicEList();
            self.getViewContainerDone().put(node.getTarget(), (EList<DSemanticDecorator>)list);
        }
        list.add((Object)node);
    }

    public static EList<EObject> getNodesCandidates(IContainerMappingExt self, EObject semanticOrigin, EObject container, EObject containerView) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.GET_CONTAINER_CANDIDATES_KEY);
        DDiagram diagram = null;
        if (containerView instanceof DDiagramElement) {
            diagram = ((DDiagramElement)containerView).getParentDiagram();
        } else if (containerView instanceof DDiagram) {
            diagram = (DDiagram)containerView;
        }
        EObject safeContainer = container == null ? semanticOrigin : container;
        EObjectCouple couple = new EObjectCouple(semanticOrigin, safeContainer, RefreshIdsHolder.getOrCreateHolder((EObject)diagram));
        UniqueEList result = self.getCandidatesCache().get(couple);
        if (result == null) {
            result = new UniqueEList();
            Iterator<EObject> it = DiagramElementMappingHelper.getSemanticIterator(self, semanticOrigin, diagram);
            if (self.getDomainClass() != null) {
                while (it.hasNext()) {
                    EObject eObj = it.next();
                    if (!ContainerMappingHelper.isInstanceOf(eObj, self.getDomainClass()) || !SiriusElementMappingSpecOperations.checkPrecondition(self, eObj, safeContainer, containerView)) continue;
                    result.add((Object)eObj);
                }
            } else {
                SiriusPlugin.getDefault().error(Messages.ContainerMappingHelper_nodeCreationErrorMsg, (Throwable)new RuntimeException());
            }
            self.getCandidatesCache().put(couple, (EList<EObject>)result);
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.GET_CONTAINER_CANDIDATES_KEY);
        return result;
    }

    public DDiagramElementContainer createContainer(IContainerMappingExt self, EObject modelElement, EObject container, DDiagram dDiagram) {
        ContainerStyle containerStyle;
        DDiagramElementContainer newContainer = null;
        if (new ContainerMappingQuery(self).isListContainer()) {
            newContainer = DiagramFactory.eINSTANCE.createDNodeList();
        } else {
            newContainer = DiagramFactory.eINSTANCE.createDNodeContainer();
            DNodeContainer nodeContainer = DiagramFactory.eINSTANCE.createDNodeContainer();
            nodeContainer.setChildrenPresentation(self.getChildrenPresentation());
            newContainer = nodeContainer;
        }
        ContainerStyleDescription style = (ContainerStyleDescription)new MappingHelper(this.interpreter).getBestStyleDescription(self, modelElement, newContainer, container, dDiagram);
        newContainer.setTarget(modelElement);
        newContainer.setActualMapping(self);
        DiagramElementMappingHelper.refreshSemanticElements(self, newContainer, this.interpreter);
        this.interpreter.setVariable("diagram", (Object)dDiagram);
        this.interpreter.setVariable("view", (Object)newContainer);
        if (style != null && style.getLabelExpression() != null) {
            try {
                String name = this.interpreter.evaluateString(modelElement, style.getLabelExpression());
                newContainer.setName(name);
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression(), (Throwable)e);
            }
        }
        if ((containerStyle = (ContainerStyle)new MappingHelper(this.interpreter).getBestStyle(self, modelElement, newContainer, container, dDiagram)) != null) {
            newContainer.setOwnedStyle(containerStyle);
        }
        if (newContainer.getOwnedStyle() != null) {
            Option noPreviousStyle = Options.newNone();
            new StyleHelper(this.interpreter).refreshStyle(newContainer.getOwnedStyle(), (Option<? extends Style>)noPreviousStyle);
        }
        self.addDoneNode((DSemanticDecorator)newContainer);
        this.interpreter.unSetVariable("view");
        this.interpreter.unSetVariable("diagram");
        self.createBorderingNodes(modelElement, newContainer, Collections.EMPTY_LIST, dDiagram);
        return newContainer;
    }

    public void updateContainer(IContainerMappingExt self, DDiagramElementContainer container) {
        DSemanticDecorator cContainer = (DSemanticDecorator)container.eContainer();
        ContainerStyleDescription style = null;
        if (cContainer != null) {
            style = (ContainerStyleDescription)new MappingHelper(this.interpreter).getBestStyleDescription(self, container.getTarget(), container, container, container.getParentDiagram());
        }
        this.interpreter.setVariable("view", (Object)container);
        if (style != null && style.getLabelExpression() != null) {
            try {
                String name = this.interpreter.evaluateString(container.getTarget(), style.getLabelExpression());
                container.setName(name);
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression(), (Throwable)e);
            }
        }
        if (style != null && style.getTooltipExpression() != null) {
            try {
                try {
                    this.interpreter.setVariable("view", (Object)container);
                    String tooltip = this.interpreter.evaluateString(container.getTarget(), style.getTooltipExpression());
                    container.setTooltipText(tooltip);
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)style, (EStructuralFeature)StylePackage.eINSTANCE.getTooltipStyleDescription_TooltipExpression(), (Throwable)e);
                    this.interpreter.unSetVariable("view");
                }
            }
            finally {
                this.interpreter.unSetVariable("view");
            }
        }
        DiagramElementMappingHelper.refreshSemanticElements(self, container, this.interpreter);
        EObject containerVariable = null;
        if (container.eContainer() instanceof DSemanticDecorator) {
            containerVariable = ((DSemanticDecorator)container.eContainer()).getTarget();
        }
        Style currentStyle = container.getStyle();
        Style bestStyle = new MappingHelper(this.interpreter).getBestStyle(self, container.getTarget(), container, containerVariable, container.getParentDiagram());
        StyleHelper sHelper = new StyleHelper(this.interpreter);
        if (currentStyle == null) {
            sHelper.setAndRefreshStyle(container, null, bestStyle);
        } else if (currentStyle.getCustomFeatures().isEmpty()) {
            if (currentStyle.getDescription() != bestStyle.getDescription() || !currentStyle.equals(bestStyle)) {
                sHelper.setAndRefreshStyle(container, currentStyle, bestStyle);
            } else {
                sHelper.refreshStyle(currentStyle);
            }
        }
        self.addDoneNode((DSemanticDecorator)container);
    }

    public static EList<DiagramElementMapping> getAllMappings(ContainerMapping self) {
        BasicEList allMappings = new BasicEList();
        allMappings.addAll(self.getAllContainerMappings());
        allMappings.addAll(self.getAllNodeMappings());
        allMappings.addAll(self.getAllBorderedNodeMappings());
        return new BasicEList.UnmodifiableEList(allMappings.size(), allMappings.toArray());
    }

    private static boolean isInstanceOf(EObject eObj, String typename) {
        return SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(eObj).eInstanceOf(eObj, typename);
    }
}

