/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.wizards.page;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class DiagramSelectionWizardPage
extends WizardPage {
    private static final int CODE_OK = 0;
    private static final int CODE_NO_SEL = 1;
    private static final int CODE_ERROR = 2;
    private Composite pageComposite;
    private CheckboxTreeViewer treeViewer;
    private DView root;
    private ViewerFilter diagramSelectionFilter;

    public DiagramSelectionWizardPage(DView root) {
        super(Messages.DiagramSelectionWizardPage_title);
        this.initialize(root, new DiagramSelectionFilter());
    }

    public DiagramSelectionWizardPage(DView root, ViewerFilter diagramSelectionFilter) {
        super(Messages.DiagramSelectionWizardPage_title);
        this.initialize(root, diagramSelectionFilter);
    }

    private void initialize(DView aRoot, ViewerFilter aDiagramSelectionFilter) {
        this.root = aRoot;
        this.setPageComplete(false);
        this.diagramSelectionFilter = aDiagramSelectionFilter;
        this.setMessage(Messages.DiagramSelectionWizardPage_message, 1);
        if (this.root.getViewpoint() != null && !StringUtil.isEmpty((String)new IdentifiedElementQuery((IdentifiedElement)this.root.getViewpoint()).getLabel())) {
            this.setTitle(MessageFormat.format(Messages.DiagramSelectionWizardPage_titleFor, new IdentifiedElementQuery((IdentifiedElement)this.root.getViewpoint()).getLabel()));
        } else {
            this.setTitle(Messages.DiagramSelectionWizardPage_title);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.pageComposite = new Composite(parent, 0);
        this.pageComposite.setLayout((Layout)new GridLayout());
        this.pageComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.treeViewer = this.createTreeViewer(this.pageComposite);
        this.treeViewer.setInput(this.root.getModels().iterator().next());
        this.treeViewer.addFilter(this.diagramSelectionFilter);
        this.treeViewer.expandAll();
        this.treeViewer.collapseAll();
        this.setControl((Control)this.pageComposite);
    }

    private CheckboxTreeViewer createTreeViewer(Composite parent) {
        DescDiagramSelectionTreeViewer viewer = new DescDiagramSelectionTreeViewer(parent, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.getTree().setHeaderVisible(false);
        viewer.getTree().setLinesVisible(false);
        viewer.addCheckStateListener(new SiriusDiagramSelectionCheckStateListener());
        viewer.setContentProvider((IContentProvider)new SemanticDViewContentProvider(this.root));
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory));
        return viewer;
    }

    private int checkSelection(Collection<?> selectedItems) {
        int result = 0;
        if (selectedItems.isEmpty()) {
            result = 1;
        } else {
            for (Object next : selectedItems) {
                if (next instanceof DDiagram) continue;
                result = 2;
            }
        }
        return result;
    }

    public Collection<?> getSelectedElements() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(Arrays.asList(this.treeViewer.getCheckedElements()));
        result.removeAll(Arrays.asList(this.treeViewer.getGrayedElements()));
        return result;
    }

    public DView getRoot() {
        return this.root;
    }

    public boolean canFlipToNextPage() {
        return this.getNextPage() != null;
    }

    public static class DescDiagramSelectionTreeViewer
    extends ContainerCheckedTreeViewer {
        public DescDiagramSelectionTreeViewer(Composite parent) {
            super(parent);
        }

        public DescDiagramSelectionTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        public DescDiagramSelectionTreeViewer(Tree tree) {
            super(tree);
        }

        protected void doCheckStateChanged(Object element) {
            Widget item = this.findItem(element);
            if (item instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)item;
                if (!(element instanceof DDiagram)) {
                    boolean result = this.updateChildrenItems(treeItem, treeItem.getChecked());
                    if (result) {
                        treeItem.setGrayed(true);
                    } else {
                        treeItem.setGrayed(false);
                    }
                    treeItem.setChecked(result);
                }
                this.updateParentItems(treeItem);
            }
        }

        private void updateParentItems(TreeItem item) {
            if (item != null && !(item.getData() instanceof DDiagram)) {
                Item[] children = this.getChildren((Widget)item);
                boolean containsChecked = false;
                Item[] itemArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Item element = itemArray[n2];
                    TreeItem curr = (TreeItem)element;
                    containsChecked = containsChecked || curr.getChecked();
                    ++n2;
                }
                item.setChecked(containsChecked);
                item.setGrayed(containsChecked);
            }
            if (item != null) {
                this.updateParentItems(item.getParentItem());
            }
        }

        private boolean updateChildrenItems(TreeItem parent, boolean state) {
            Item[] children;
            boolean result = false;
            Item[] itemArray = children = this.getChildren((Widget)parent);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Item element = itemArray[n2];
                TreeItem curr = (TreeItem)element;
                if (curr.getData() instanceof DDiagram && (curr.getChecked() != state || curr.getGrayed())) {
                    curr.setChecked(state);
                    curr.setGrayed(false);
                    result = result || state;
                    result = result || this.updateChildrenItems(curr, state);
                } else if (curr.getData() != null && (curr.getChecked() != state || curr.getGrayed())) {
                    boolean childrenResult = this.updateChildrenItems(curr, state);
                    if (childrenResult) {
                        curr.setChecked(true);
                        curr.setGrayed(true);
                    } else {
                        curr.setChecked(false);
                        curr.setGrayed(false);
                    }
                    result = result || childrenResult;
                }
                ++n2;
            }
            return result;
        }
    }

    private class DiagramSelectionFilter
    extends ViewerFilter {
        private DiagramSelectionFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof EObject && DiagramSelectionWizardPage.this.treeViewer.getContentProvider() != null) {
                EObject eObject = (EObject)element;
                boolean resultForThis = this.baseSelect(eObject);
                Object[] children = ((ITreeContentProvider)DiagramSelectionWizardPage.this.treeViewer.getContentProvider()).getChildren(element);
                if (children != null) {
                    int i = 0;
                    while (i < children.length && !resultForThis) {
                        resultForThis = this.select(viewer, element, children[i]);
                        ++i;
                    }
                }
                return resultForThis;
            }
            return false;
        }

        private boolean baseSelect(Object element) {
            return element instanceof DDiagram;
        }
    }

    private static final class SemanticDViewContentProvider
    implements ICommonContentProvider {
        private static Object[] empty = new Object[0];
        private DView representationContainer;
        private AdapterFactoryContentProvider semanticProvider;

        SemanticDViewContentProvider(DView functionnalAnalysis) {
            this.representationContainer = functionnalAnalysis;
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            this.semanticProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
        }

        public void init(ICommonContentExtensionSite config) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof EObject && !(parentElement instanceof DDiagram)) {
                EObject parent = (EObject)parentElement;
                Collection<DRepresentation> representations = this.findRepresentations(parent);
                Object[] semantic = this.semanticProvider.getChildren(parentElement);
                Object[] result = new Object[representations.size() + semantic.length];
                int i = 0;
                Iterator<DRepresentation> iterRepresentation = representations.iterator();
                while (iterRepresentation.hasNext()) {
                    result[i++] = iterRepresentation.next();
                }
                System.arraycopy(semantic, 0, result, representations.size(), semantic.length);
                return result;
            }
            return empty;
        }

        public Object getParent(Object element) {
            if (element instanceof EObject) {
                EObject current = (EObject)element;
                EObject parent = current instanceof DSemanticDiagram ? ((DSemanticDiagram)current).getTarget() : current.eContainer();
                return parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
            this.semanticProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void restoreState(IMemento memento) {
        }

        public void saveState(IMemento memento) {
        }

        private Collection<DRepresentation> findRepresentations(EObject semanticElement) {
            if (semanticElement == null) {
                return Collections.emptySet();
            }
            HashSet<DRepresentation> result = new HashSet<DRepresentation>();
            for (DRepresentation representation : new DViewQuery(this.representationContainer).getLoadedRepresentations()) {
                if (!(representation instanceof DSemanticDecorator) || !semanticElement.equals(((DSemanticDecorator)representation).getTarget())) continue;
                result.add(representation);
            }
            return result;
        }
    }

    private class SiriusDiagramSelectionCheckStateListener
    implements ICheckStateListener {
        private SiriusDiagramSelectionCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            int result = DiagramSelectionWizardPage.this.checkSelection(DiagramSelectionWizardPage.this.getSelectedElements());
            switch (result) {
                case 0: {
                    DiagramSelectionWizardPage.this.setMessage(Messages.DiagramSelectionWizardPage_message, 1);
                    DiagramSelectionWizardPage.this.setPageComplete(true);
                    break;
                }
                case 1: {
                    DiagramSelectionWizardPage.this.setMessage(Messages.DiagramSelectionWizardPage_message, 1);
                    DiagramSelectionWizardPage.this.setPageComplete(false);
                    break;
                }
                case 2: {
                    DiagramSelectionWizardPage.this.setMessage(Messages.SiriusDiagramSelectionCheckStateListener_errorMsg, 3);
                    DiagramSelectionWizardPage.this.setPageComplete(false);
                    break;
                }
                default: {
                    DiagramSelectionWizardPage.this.setMessage(Messages.SiriusDiagramSelectionCheckStateListener_unknwonCodeResult, 3);
                    DiagramSelectionWizardPage.this.setPageComplete(false);
                }
            }
        }
    }
}

