/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.WrappingCommandIgnoringAffectedFiles;
import org.eclipse.sirius.ecore.extender.business.api.permission.exception.LockedInstanceException;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class DDiagramCommandStack
extends DiagramCommandStack {
    public DDiagramCommandStack(IDiagramEditDomain diagramEditDomain) {
        super(diagramEditDomain);
    }

    public void execute(Command command, IProgressMonitor monitor) {
        if (command == null || !command.canExecute()) {
            return;
        }
        ICommand original = DiagramCommandStack.getICommand((Command)command);
        this.execute(this.getWrappingCommandIgnoringAffectedFiles(original), monitor);
    }

    protected void execute(ICommand command, IProgressMonitor progressMonitor) {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        try {
            command.addContext(this.getUndoContext());
            this.getOperationHistory().execute((IUndoableOperation)command, monitor, null);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof LockedInstanceException) {
                SiriusPlugin.getDefault().warning(cause.getMessage(), (Exception)((LockedInstanceException)cause));
            }
            this.defaultLog(e);
        }
    }

    private void defaultLog(ExecutionException e) {
        Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"execute", (Throwable)e);
        Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)4, (String)"execute", (Throwable)e);
    }

    private ICommand getWrappingCommandIgnoringAffectedFiles(ICommand original) {
        return new WrappingCommandIgnoringAffectedFiles(original);
    }
}

