/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.operation;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public abstract class ComparisonHelper {
    public final void sort(List<? extends View> views) {
        final List<? extends RepresentationElementMapping> allMappings = this.getMappingsToSort();
        Function<View, Integer> mappingIndex = new Function<View, Integer>(){

            public Integer apply(View view) {
                EObject element;
                if (view != null && (element = view.getElement()) instanceof DMappingBased) {
                    RepresentationElementMapping mapping = ((DMappingBased)element).getMapping();
                    return allMappings.indexOf(mapping);
                }
                return Integer.MAX_VALUE;
            }
        };
        final HashMap indices = Maps.newHashMap();
        List<? extends DRepresentationElement> elements = this.getDElementsToSort();
        int i = 0;
        for (DRepresentationElement dRepresentationElement : elements) {
            indices.put(dRepresentationElement, i);
            ++i;
        }
        Function<View, Integer> function = new Function<View, Integer>(){

            public Integer apply(View view) {
                EObject sem;
                if (view != null && (sem = ViewUtil.resolveSemanticElement((View)view)) != null && indices.containsKey(sem)) {
                    return (Integer)indices.get(sem);
                }
                return Integer.MAX_VALUE;
            }
        };
        Collections.sort(views, Ordering.natural().onResultOf((Function)mappingIndex).compound((Comparator)Ordering.natural().onResultOf((Function)function)));
    }

    protected abstract List<? extends DRepresentationElement> getDElementsToSort();

    protected abstract List<? extends RepresentationElementMapping> getMappingsToSort();
}

