/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.verticalruler;

import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class OpenOverriddenTemplateAction
extends Action {
    private AcceleoEditor editor;
    private IMarker marker;

    public OpenOverriddenTemplateAction(AcceleoEditor acceleoEditor, IMarker overrideMarker) {
        this.editor = acceleoEditor;
        this.marker = overrideMarker;
    }

    public void run() {
        Template template;
        EList overrides;
        CSTNode cstNode;
        int start = MarkerUtilities.getCharStart((IMarker)this.marker);
        int end = MarkerUtilities.getCharEnd((IMarker)this.marker);
        EObject res = null;
        ASTNode astNode = this.editor.getContent().getResolvedASTNode(start, end);
        if (astNode != null) {
            res = OpenDeclarationUtils.findDeclarationFromAST(astNode);
        }
        if (res == null && (cstNode = this.editor.getContent().getCSTNode(start, end)) != null) {
            res = OpenDeclarationUtils.findDeclarationFromCST(this.editor, astNode, cstNode);
        }
        if (res instanceof Template && (overrides = (template = (Template)res).getOverrides()).size() > 0) {
            Template overriddenTemplate = (Template)overrides.get(0);
            OpenDeclarationUtils.showEObject(this.editor.getSite().getPage(), this.getFileURI((EObject)overriddenTemplate), OpenDeclarationUtils.createRegion((EObject)overriddenTemplate), (EObject)overriddenTemplate);
        }
    }

    public URI getFileURI(EObject eObj) {
        URI res = null;
        if (eObj != null && eObj.eResource() != null) {
            res = eObj.eResource().getURI();
        }
        return res;
    }
}

