/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.cst;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.acceleo.common.internal.utils.AcceleoDynamicMetamodelResourceSetImpl;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.common.internal.utils.compatibility.AcceleoOCLReflection;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.internal.parser.AcceleoParserMessages;
import org.eclipse.acceleo.internal.parser.IAcceleoParserProblemsConstants;
import org.eclipse.acceleo.internal.parser.cst.CSTParserBlock;
import org.eclipse.acceleo.internal.parser.cst.utils.ISequence;
import org.eclipse.acceleo.internal.parser.cst.utils.ParserUtils;
import org.eclipse.acceleo.internal.parser.cst.utils.Region;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.internal.parser.cst.utils.SequenceBlock;
import org.eclipse.acceleo.internal.parser.documentation.utils.DocumentationUtils;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.parser.cst.Block;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.Comment;
import org.eclipse.acceleo.parser.cst.CstFactory;
import org.eclipse.acceleo.parser.cst.Documentation;
import org.eclipse.acceleo.parser.cst.InitSection;
import org.eclipse.acceleo.parser.cst.Macro;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.Module;
import org.eclipse.acceleo.parser.cst.ModuleElement;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.acceleo.parser.cst.Query;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.TemplateOverridesValue;
import org.eclipse.acceleo.parser.cst.TextExpression;
import org.eclipse.acceleo.parser.cst.TypedModel;
import org.eclipse.acceleo.parser.cst.Variable;
import org.eclipse.acceleo.parser.cst.VisibilityKind;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class CSTParser {
    protected static final List<String> ACCELEO_KEYWORDS = Arrays.asList("after", "before", "comment", "else", "elseif", "elselet", "encoding", "extends", "file", "for", "if", "import", "let", "macro", "module", "overrides", "post", "protected", "query", "self", "super", "template", "trace", "private", "protected", "public");
    private static final String MISSING_CHARACTER_KEY = "Parser.MissingCharacter";
    private static final String INVALID_STMT_HEADER = "CSTParser.InvalidStatementHeader";
    private static final String INVALID_STMT = "CSTParser.InvalidStatement";
    protected final AcceleoSourceBuffer source;
    protected final SequenceBlock pLiteral;
    protected final SequenceBlock pComment;
    protected final SequenceBlock pParenthesis;
    protected final SequenceBlock pBrackets;
    protected final Sequence pComma;
    protected final Sequence pSemicolon;
    protected final Sequence pPipe;
    protected final Sequence pGuard;
    protected final Sequence pPost;
    protected final SequenceBlock pModule;
    protected final SequenceBlock pImport;
    protected final SequenceBlock pTemplate;
    protected final SequenceBlock pMacro;
    protected final SequenceBlock pQuery;
    protected final SequenceBlock pDocumentation;
    protected final CSTParserBlock pBlock;

    public CSTParser(AcceleoSourceBuffer source) {
        this.source = source;
        Sequence literalEscape = new Sequence("\\'");
        this.pLiteral = new SequenceBlock(new Sequence("'"), new Sequence("'"), literalEscape, false, null);
        this.pComment = ParserUtils.createAcceleoSequenceBlock(false, "comment", null, null);
        this.pParenthesis = new SequenceBlock(new Sequence("("), new Sequence(")"), null, true, new SequenceBlock[]{this.pLiteral});
        this.pBrackets = new SequenceBlock(new Sequence("{"), new Sequence("}"), null, true, new SequenceBlock[]{this.pLiteral});
        this.pComma = new Sequence(",");
        this.pSemicolon = new Sequence(";");
        this.pPipe = new Sequence("|");
        this.pGuard = new Sequence("?");
        this.pPost = new Sequence("post");
        this.pModule = ParserUtils.createAcceleoSequenceBlock(true, "module", new SequenceBlock[]{this.pLiteral}, null);
        this.pImport = ParserUtils.createAcceleoSequenceBlock(true, "import", new SequenceBlock[]{this.pLiteral}, null);
        this.pTemplate = ParserUtils.createAcceleoSequenceBlock(false, "template", new SequenceBlock[]{this.pLiteral, this.pParenthesis}, new SequenceBlock[]{this.pComment});
        this.pMacro = ParserUtils.createAcceleoSequenceBlock(false, "macro", new SequenceBlock[]{this.pLiteral, this.pParenthesis}, new SequenceBlock[]{this.pComment});
        this.pQuery = ParserUtils.createAcceleoSequenceBlock(false, "query", new SequenceBlock[]{this.pLiteral, this.pParenthesis}, new SequenceBlock[]{this.pComment});
        this.pDocumentation = ParserUtils.createAcceleoSequenceBlock(true, "**", null, null);
        this.pBlock = new CSTParserBlock(this);
    }

    public AcceleoSourceBuffer getSource() {
        return this.source;
    }

    public CSTParserBlock getPBlock() {
        return this.pBlock;
    }

    protected void setPositions(CSTNode eCSTNode, int posBegin, int posEnd) {
        if (eCSTNode instanceof TextExpression || eCSTNode instanceof Block) {
            eCSTNode.setStartPosition(posBegin);
            eCSTNode.setEndPosition(posEnd);
        } else {
            int[] pos = this.source.trim(posBegin, posEnd);
            if (pos[0] == pos[1] && posBegin != posEnd) {
                eCSTNode.setStartPosition(posBegin);
                eCSTNode.setEndPosition(posEnd);
            } else {
                eCSTNode.setStartPosition(pos[0]);
                eCSTNode.setEndPosition(pos[1]);
            }
        }
    }

    public Module parse() {
        if (this.source.getBuffer() == null || this.source.getBuffer().length() == 0) {
            this.logProblem(AcceleoParserMessages.getString("CSTParser.EmptyBuffer"), 0, -1);
        } else {
            Region bH = this.pModule.searchBeginHeader(this.source.getBuffer(), 0, this.source.getBuffer().length());
            if (bH.b() == -1) {
                this.logProblem(AcceleoParserMessages.getString("CSTParser.MissingModule"), 0, -1);
            } else {
                Region eH = this.pModule.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bH, this.source.getBuffer().length());
                if (eH.b() == -1) {
                    this.logProblem(AcceleoParserMessages.getString("CSTParser.MissingModuleEnd"), bH.b(), bH.e());
                } else {
                    Module eModule = CstFactory.eINSTANCE.createModule();
                    this.setPositions(eModule, bH.b(), this.source.getBuffer().length());
                    List<Comment> commentsBeforeModule = this.parseBeforeModule(eModule);
                    this.computeModuleDocumentation(commentsBeforeModule, eModule);
                    this.parseModuleHeader(bH.e(), eH.b(), eModule);
                    this.parseModuleBody(eH.e(), this.source.getBuffer().length(), eModule);
                    this.checkModuleImports(eModule);
                    this.checkModuleExtends(eModule);
                    return eModule;
                }
            }
        }
        return null;
    }

    private void checkModuleImports(Module eModule) {
        ArrayList<String> importedValues = new ArrayList<String>();
        EList<ModuleImportsValue> imports = eModule.getImports();
        for (ModuleImportsValue moduleImportsValue : imports) {
            if (importedValues.contains(moduleImportsValue.getName())) {
                this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.ModuleAlreadyImports", moduleImportsValue.getName()), moduleImportsValue.getStartPosition(), moduleImportsValue.getEndPosition());
                continue;
            }
            importedValues.add(moduleImportsValue.getName());
        }
    }

    private void checkModuleExtends(Module eModule) {
        ArrayList<String> extendedValues = new ArrayList<String>();
        EList<ModuleExtendsValue> extendedModules = eModule.getExtends();
        for (ModuleExtendsValue moduleExtendsValue : extendedModules) {
            if (extendedValues.contains(moduleExtendsValue.getName())) {
                this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.ModuleAlreadyExtends", moduleExtendsValue.getName()), moduleExtendsValue.getStartPosition(), moduleExtendsValue.getEndPosition());
                continue;
            }
            extendedValues.add(moduleExtendsValue.getName());
        }
    }

    private void computeModuleDocumentation(List<Comment> commentsBeforeModule, Module eModule) {
        Documentation documentation;
        StringBuffer documentationBody;
        Sequence bSequence;
        Region b;
        Comment comment;
        if (commentsBeforeModule.size() > 0 && (comment = commentsBeforeModule.get(commentsBeforeModule.size() - 1)) instanceof Documentation && (b = (bSequence = new Sequence("[", "**", "encoding", "=")).search(documentationBody = new StringBuffer((documentation = (Documentation)comment).getBody()))).e() == -1) {
            eModule.setDocumentation(documentation);
        }
    }

    public Documentation parseModuleDocumentation(int posBegin, Module eModule) {
        if (this.source.getBuffer() == null || this.source.getBuffer().length() == 0) {
            this.logProblem(AcceleoParserMessages.getString("CSTParser.EmptyBuffer"), 0, -1);
        } else {
            Region bH = this.pModule.searchBeginHeader(this.source.getBuffer(), 0, this.source.getBuffer().length());
            if (bH.b() == -1) {
                this.logProblem(AcceleoParserMessages.getString("CSTParser.MissingModule"), 0, -1);
            } else {
                Region eH = this.pModule.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bH, this.source.getBuffer().length());
                if (eH.b() == -1) {
                    this.logProblem(AcceleoParserMessages.getString("CSTParser.MissingModuleEnd"), bH.b(), bH.e());
                } else {
                    this.setPositions(eModule, bH.b(), this.source.getBuffer().length());
                    List<Comment> commentsBeforeModule = this.parseBeforeModule(eModule);
                    this.computeModuleDocumentation(commentsBeforeModule, eModule);
                    return eModule.getDocumentation();
                }
            }
        }
        return null;
    }

    private List<Comment> parseBeforeModule(Module eModule) {
        int currentPosition = 0;
        ArrayList<Comment> commentBeforeModuleHeader = new ArrayList<Comment>();
        while (currentPosition < eModule.getStartPosition() && currentPosition != -1) {
            Comment eComment;
            Documentation eDocumentation;
            Region docBH = this.pDocumentation.searchBeginHeader(this.source.getBuffer(), currentPosition, eModule.getStartPosition());
            Region comBH = this.pComment.searchBeginHeader(this.source.getBuffer(), currentPosition, eModule.getStartPosition());
            if (docBH.b() == -1 && comBH.b() == -1) {
                this.parseWhitespaceArea(currentPosition, eModule.getStartPosition());
                currentPosition = -1;
                continue;
            }
            if (docBH.b() != -1 && comBH.b() != -1) {
                if (docBH.b() < comBH.b()) {
                    eDocumentation = this.parseDocumentationBeforeModule(docBH, eModule.getStartPosition());
                    if (eDocumentation != null) {
                        commentBeforeModuleHeader.add(eDocumentation);
                        this.parseWhitespaceArea(currentPosition, eDocumentation.getStartPosition());
                        currentPosition = eDocumentation.getEndPosition();
                        continue;
                    }
                    currentPosition = this.source.getBuffer().indexOf("[", docBH.e() + 1);
                    continue;
                }
                if (docBH.b() <= comBH.b()) continue;
                eComment = this.parseCommentBeforeModule(comBH, eModule.getStartPosition());
                if (eComment != null) {
                    commentBeforeModuleHeader.add(eComment);
                    this.parseWhitespaceArea(currentPosition, eComment.getStartPosition());
                    currentPosition = eComment.getEndPosition();
                    continue;
                }
                currentPosition = this.source.getBuffer().indexOf("[", comBH.e() + 1);
                continue;
            }
            if (docBH.b() != -1 && comBH.b() == -1) {
                eDocumentation = this.parseDocumentationBeforeModule(docBH, eModule.getStartPosition());
                if (eDocumentation != null) {
                    commentBeforeModuleHeader.add(eDocumentation);
                    this.parseWhitespaceArea(currentPosition, eDocumentation.getStartPosition());
                    currentPosition = eDocumentation.getEndPosition();
                    continue;
                }
                currentPosition = this.source.getBuffer().indexOf("[", docBH.e() + 1);
                continue;
            }
            if (docBH.b() != -1 || comBH.b() == -1) continue;
            eComment = this.parseCommentBeforeModule(comBH, eModule.getStartPosition());
            if (eComment != null) {
                commentBeforeModuleHeader.add(eComment);
                this.parseWhitespaceArea(currentPosition, eComment.getStartPosition());
                currentPosition = eComment.getEndPosition();
                continue;
            }
            currentPosition = this.source.getBuffer().indexOf("[", comBH.e() + 1);
        }
        return commentBeforeModuleHeader;
    }

    private void parseWhitespaceArea(int startPosition, int endPosition) {
        String substring = this.source.getBuffer().substring(startPosition, endPosition);
        Pattern p = Pattern.compile("\\S");
        Matcher matcher = p.matcher(substring);
        boolean found = matcher.find();
        if (found) {
            this.logWarning(AcceleoParserMessages.getString("AcceleoParser.Warning.TextBetweenCommentAndModule"), startPosition, endPosition);
        }
    }

    private Comment parseCommentBeforeModule(Region beginHeader, int moduleStartPosition) {
        Comment comment;
        Region eH = this.pComment.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, moduleStartPosition);
        if (eH.b() == -1) {
            this.logProblem(AcceleoParserMessages.getString(INVALID_STMT_HEADER, "comment"), beginHeader.b(), beginHeader.e());
            comment = null;
        } else if (eH.getSequence() == this.pComment.getEndHeaderBody()) {
            Comment eComment = CstFactory.eINSTANCE.createComment();
            this.setPositions(eComment, beginHeader.b(), eH.e());
            eComment.setBody(this.source.getBuffer().substring(beginHeader.e(), eH.b()));
            DocumentationUtils.parseToDoFixMe(this.source, eComment.getStartPosition(), eComment.getEndPosition(), DocumentationUtils.CommentType.COMMENT_IN_HEADER);
            comment = eComment;
        } else {
            Region eB = this.pComment.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, moduleStartPosition);
            if (eB.b() == -1) {
                this.logProblem(AcceleoParserMessages.getString(INVALID_STMT, "comment"), beginHeader.b(), beginHeader.e());
                comment = null;
            } else {
                Comment eComment = CstFactory.eINSTANCE.createComment();
                this.setPositions(eComment, beginHeader.b(), eB.e());
                eComment.setBody(this.source.getBuffer().substring(eH.e(), eB.b()));
                DocumentationUtils.parseToDoFixMe(this.source, eComment.getStartPosition(), eComment.getEndPosition(), DocumentationUtils.CommentType.COMMENT_WITH_END_HEADER);
                comment = eComment;
            }
        }
        return comment;
    }

    private Documentation parseDocumentationBeforeModule(Region beginHeader, int moduleStartPosition) {
        Documentation eDocumentation;
        Region eH = this.pDocumentation.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, moduleStartPosition);
        if (eH.b() == -1) {
            this.logProblem(AcceleoParserMessages.getString(INVALID_STMT_HEADER, "**"), beginHeader.b(), beginHeader.e());
            eDocumentation = null;
        } else if (eH.getSequence() == this.pDocumentation.getEndHeaderBody()) {
            eDocumentation = CstFactory.eINSTANCE.createDocumentation();
            this.setPositions(eDocumentation, beginHeader.b(), eH.e());
            String body = this.parseDocumentationBody(this.source.getBuffer().substring(beginHeader.e(), eH.b()));
            eDocumentation.setBody(body);
            DocumentationUtils.parseToDoFixMe(this.source, eDocumentation.getStartPosition(), eDocumentation.getEndPosition(), DocumentationUtils.CommentType.DOCUMENTATION);
        } else {
            this.logProblem(AcceleoParserMessages.getString(INVALID_STMT, "**"), beginHeader.b(), beginHeader.e());
            eDocumentation = null;
        }
        return eDocumentation;
    }

    private String parseDocumentationBody(String documentationBody) {
        StringBuffer buffer = new StringBuffer();
        String str = "";
        BufferedReader reader = new BufferedReader(new StringReader(documentationBody));
        try {
            while ((str = reader.readLine()) != null) {
                if (str.trim().startsWith("*")) {
                    str = String.valueOf(str.substring(str.indexOf("*") + 1)) + System.getProperty("line.separator");
                    buffer.append(String.valueOf(str.trim()) + System.getProperty("line.separator"));
                    continue;
                }
                if (str.endsWith("*")) {
                    str = String.valueOf(str.substring(0, str.lastIndexOf("*"))) + System.getProperty("line.separator");
                    buffer.append(String.valueOf(str.trim()) + System.getProperty("line.separator"));
                    continue;
                }
                buffer.append(String.valueOf(str) + System.getProperty("line.separator"));
            }
        }
        catch (IOException iOException) {}
        return buffer.toString();
    }

    public void parseModuleHeader(int posBegin, int posEnd, Module eModule) {
        Region bH = this.pParenthesis.searchBeginHeader(this.source.getBuffer(), posBegin, posEnd);
        if (bH.b() == -1) {
            this.logProblem(AcceleoParserMessages.getString("CSTParser.MissingMetamodel"), posBegin, posEnd);
            String name = this.source.getBuffer().substring(posBegin, posEnd).trim();
            if (ACCELEO_KEYWORDS.contains(name) || AcceleoOCLReflection.getReservedKeywords().contains(name)) {
                this.logWarning(AcceleoParserMessages.getString("CSTParser.InvalidModuleName"), posBegin, posEnd);
            }
            eModule.setName(name);
            if (this.source.getFile() != null && !this.checkModuleDefinition(name, this.source.getFile())) {
                this.logProblem(AcceleoParserMessages.getString("CSTParser.InvalidModuleDefinition", name), posBegin, posEnd);
            }
        } else {
            Region eH = this.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bH, posEnd);
            if (eH.b() == -1) {
                this.logProblem(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bH.b(), bH.e());
            } else {
                this.parseModuleHeaderTypedModels(bH.e(), eH.b(), eModule);
                int eExtend = this.parseModuleHeaderExtends(eH.e(), posEnd, eModule);
                if (this.source.getBuffer().substring(eExtend, posEnd).trim().length() > 0) {
                    this.logProblem(IAcceleoParserProblemsConstants.SYNTAX_TEXT_NOT_VALID, eExtend, posEnd);
                }
            }
            String name = this.source.getBuffer().substring(posBegin, bH.b()).trim();
            if (ACCELEO_KEYWORDS.contains(name) || AcceleoOCLReflection.getReservedKeywords().contains(name)) {
                this.logWarning(AcceleoParserMessages.getString("CSTParser.InvalidModuleName", name), posBegin, bH.b());
            }
            eModule.setName(name);
            if (this.source.getFile() != null && !this.checkModuleDefinition(name, this.source.getFile())) {
                this.logProblem(AcceleoParserMessages.getString("CSTParser.InvalidModuleDefinition", name), posBegin, bH.b());
            }
        }
    }

    private boolean checkModuleDefinition(String name, File file) {
        StringTokenizer st = new StringTokenizer(String.valueOf(name) + "." + "mtl", "::");
        String[] segments = new String[st.countTokens()];
        int i = 0;
        while (i < segments.length) {
            segments[i] = st.nextToken();
            ++i;
        }
        boolean result = true;
        File current = file;
        int i2 = segments.length - 1;
        while (result && i2 >= 0) {
            if (current == null || current.getName() == null || !current.getName().equals(segments[i2])) {
                result = false;
            } else {
                current = current.getParentFile();
            }
            --i2;
        }
        return result;
    }

    private void parseModuleHeaderTypedModels(int posBegin, int posEnd, Module eModule) {
        int currentPos = posBegin;
        String substring = this.source.getBuffer().substring(posBegin, posEnd);
        if ("".equals(substring.trim())) {
            this.logProblem(AcceleoParserMessages.getString("CSTParser.MissingMetamodel"), eModule.getStartPosition(), eModule.getEndPosition());
        }
        while (currentPos != posEnd) {
            Region comma = this.pComma.search(this.source.getBuffer(), currentPos, posEnd, null, new SequenceBlock[]{this.pLiteral});
            int e = comma.b() == -1 ? posEnd : comma.b();
            TypedModel typedModel = this.checkEPackages(currentPos, e);
            eModule.getInput().add((Object)typedModel);
            currentPos = comma.b() == -1 ? posEnd : comma.e();
        }
    }

    private TypedModel checkEPackages(int currentPos, int endPos) {
        TypedModel res = CstFactory.eINSTANCE.createTypedModel();
        this.setPositions(res, currentPos, endPos);
        String ePackageKey = this.source.getBuffer().substring(currentPos, endPos).trim();
        EPackage ePackage = ModelUtils.getEPackage((String)ePackageKey);
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        if (ePackage == null && ePackageKey.startsWith("'") && ePackageKey.endsWith("'")) {
            ePackage = ModelUtils.getEPackage((String)(ePackageKey = ePackageKey.substring("'".length(), ePackageKey.length() - "'".length())));
            if (ePackage == null) {
                ArrayList ePackageKeys = new ArrayList();
                try {
                    ePackageKeys.addAll(AcceleoPackageRegistry.INSTANCE.registerEcorePackages(ePackageKey, AcceleoDynamicMetamodelResourceSetImpl.DYNAMIC_METAMODEL_RESOURCE_SET));
                }
                catch (WrappedException wrappedException) {}
                for (String key : ePackageKeys) {
                    EPackage ePkg = ModelUtils.getEPackage((String)key);
                    if (ePkg == null) continue;
                    ePackages.add(ePkg);
                }
                if (ePackages.size() == 0) {
                    this.logProblem(AcceleoParserMessages.getString("CSTParser.MetamodelNotFound"), currentPos, endPos);
                }
            } else {
                ePackages.add(ePackage);
            }
        } else if (ePackage != null) {
            ePackages.add(ePackage);
        }
        for (EPackage ePkg : ePackages) {
            res.getTakesTypesFrom().add((Object)ePkg);
            res.getTakesTypesFrom().addAll(this.getAllSubpackages(ePkg));
        }
        return res;
    }

    private int parseModuleHeaderExtends(int posBegin, int posEnd, Module eModule) {
        int bExtend = ParserUtils.shiftKeyword(this.source.getBuffer(), posBegin, posEnd, "extends", true);
        boolean errorFound = false;
        if (bExtend != posBegin) {
            while (bExtend != posEnd && !errorFound) {
                ModuleExtendsValue eModuleExtendsValue;
                Region comma = this.pComma.search(this.source.getBuffer(), bExtend, posEnd, null, new SequenceBlock[]{this.pLiteral});
                if (comma.b() == -1) {
                    eModuleExtendsValue = CstFactory.eINSTANCE.createModuleExtendsValue();
                    String trimmedText = this.source.getBuffer().substring(bExtend, posEnd).trim();
                    int indexOfSpace = trimmedText.indexOf(" ");
                    if (indexOfSpace == -1) {
                        eModuleExtendsValue.setName(trimmedText);
                        eModule.getExtends().add((Object)eModuleExtendsValue);
                        this.setPositions(eModuleExtendsValue, bExtend, posEnd);
                        bExtend = posEnd;
                    } else {
                        int indexOfSpaceInTrimmedText = this.source.getBuffer().indexOf(trimmedText, bExtend) + indexOfSpace;
                        eModuleExtendsValue.setName(this.source.getBuffer().substring(bExtend, indexOfSpaceInTrimmedText).trim());
                        eModule.getExtends().add((Object)eModuleExtendsValue);
                        this.setPositions(eModuleExtendsValue, bExtend, indexOfSpaceInTrimmedText);
                        bExtend = indexOfSpaceInTrimmedText;
                        errorFound = true;
                    }
                    if (eModuleExtendsValue.getName() == null || eModuleExtendsValue.getName().contains("::")) continue;
                    this.logWarning(AcceleoParserMessages.getString("CSTParser.UnqualifiedExtend"), eModuleExtendsValue.getStartPosition(), eModuleExtendsValue.getEndPosition());
                    continue;
                }
                eModuleExtendsValue = CstFactory.eINSTANCE.createModuleExtendsValue();
                this.setPositions(eModuleExtendsValue, bExtend, comma.b());
                eModuleExtendsValue.setName(this.source.getBuffer().substring(bExtend, comma.b()).trim());
                eModule.getExtends().add((Object)eModuleExtendsValue);
                bExtend = comma.e();
                if (eModuleExtendsValue.getName() == null || eModuleExtendsValue.getName().contains("::")) continue;
                this.logWarning(AcceleoParserMessages.getString("CSTParser.UnqualifiedExtend"), eModuleExtendsValue.getStartPosition(), eModuleExtendsValue.getEndPosition());
            }
        }
        return bExtend;
    }

    private Collection<EPackage> getAllSubpackages(EPackage ePackage) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (EPackage eSubpackage : ePackage.getESubpackages()) {
            result.add(eSubpackage);
            result.addAll(this.getAllSubpackages(eSubpackage));
        }
        return result;
    }

    public void parseModuleBody(int posBegin, int posEnd, Module eModule) {
        int currentPosBegin = posBegin;
        ISequence[] pModuleElements = new SequenceBlock[]{this.pComment, this.pImport, this.pTemplate, this.pMacro, this.pQuery, this.pDocumentation};
        Region[] positions = Region.createPositions(pModuleElements.length);
        while (currentPosBegin > -1 && currentPosBegin < posEnd) {
            int i = ParserUtils.getNextSequence(this.source.getBuffer(), currentPosBegin, posEnd, pModuleElements, positions);
            if (i == -1) {
                if (this.source.getBuffer().substring(currentPosBegin, posEnd).trim().length() > 0) {
                    this.logProblem(AcceleoParserMessages.getString("CSTParser.InvalidModel"), currentPosBegin, posEnd);
                }
                currentPosBegin = -1;
                continue;
            }
            ISequence pModuleElement = pModuleElements[i];
            Region bH = positions[i];
            if (this.source.getBuffer().substring(currentPosBegin, bH.b()).trim().length() > 0) {
                this.logProblem(AcceleoParserMessages.getString("CSTParser.InvalidModuleElement"), currentPosBegin, bH.b());
            }
            currentPosBegin = pModuleElement == this.pComment ? this.parseCommentEnding(bH, posEnd, eModule) : (pModuleElement == this.pImport ? this.parseImportEnding(bH, posEnd, eModule) : (pModuleElement == this.pTemplate ? this.parseTemplateEnding(bH, posEnd, eModule) : (pModuleElement == this.pMacro ? this.parseMacroEnding(bH, posEnd, eModule) : (pModuleElement == this.pQuery ? this.parseQueryEnding(bH, posEnd, eModule) : (pModuleElement == this.pDocumentation ? this.parseDocumentationEnding(bH, posEnd, eModule) : -1)))));
        }
    }

    private int parseDocumentationEnding(Region beginHeader, int posEnd, Module eModule) {
        int posBegin;
        Region eH = this.pDocumentation.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.logProblem(AcceleoParserMessages.getString(INVALID_STMT_HEADER, "**"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else {
            Documentation eDocumentation = CstFactory.eINSTANCE.createDocumentation();
            this.setPositions(eDocumentation, beginHeader.b(), eH.e());
            String body = this.parseDocumentationBody(this.source.getBuffer().substring(beginHeader.e(), eH.b()));
            eDocumentation.setBody(body);
            DocumentationUtils.parseToDoFixMe(this.source, eDocumentation.getStartPosition(), eDocumentation.getEndPosition(), DocumentationUtils.CommentType.DOCUMENTATION);
            eModule.getOwnedModuleElement().add((Object)eDocumentation);
            posBegin = eH.e();
        }
        return posBegin;
    }

    private int parseCommentEnding(Region beginHeader, int posEnd, Module eModule) {
        int posBegin;
        Region eH = this.pComment.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.logProblem(AcceleoParserMessages.getString(INVALID_STMT_HEADER, "comment"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pComment.getEndHeaderBody()) {
            Comment eComment = CstFactory.eINSTANCE.createComment();
            this.setPositions(eComment, beginHeader.b(), eH.e());
            eComment.setBody(this.source.getBuffer().substring(beginHeader.e(), eH.b()));
            DocumentationUtils.parseToDoFixMe(this.source, eComment.getStartPosition(), eComment.getEndPosition(), DocumentationUtils.CommentType.COMMENT_IN_HEADER);
            eModule.getOwnedModuleElement().add((Object)eComment);
            posBegin = eH.e();
        } else {
            Region eB = this.pComment.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.logProblem(AcceleoParserMessages.getString(INVALID_STMT, "comment"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                Comment eComment = CstFactory.eINSTANCE.createComment();
                this.setPositions(eComment, beginHeader.b(), eB.e());
                eComment.setBody(this.source.getBuffer().substring(eH.e(), eB.b()));
                DocumentationUtils.parseToDoFixMe(this.source, eComment.getStartPosition(), eComment.getEndPosition(), DocumentationUtils.CommentType.COMMENT_WITH_END_HEADER);
                eModule.getOwnedModuleElement().add((Object)eComment);
                posBegin = eB.e();
            }
        }
        return posBegin;
    }

    private int parseImportEnding(Region beginHeader, int posEnd, Module eModule) {
        int posBegin;
        Region eH = this.pImport.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.logProblem(AcceleoParserMessages.getString(INVALID_STMT_HEADER, "import"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else {
            ModuleImportsValue eModuleImportsValue = CstFactory.eINSTANCE.createModuleImportsValue();
            this.setPositions(eModuleImportsValue, beginHeader.e(), eH.b());
            eModuleImportsValue.setName(this.source.getBuffer().substring(beginHeader.e(), eH.b()).trim());
            if (eModuleImportsValue.getName() != null && !eModuleImportsValue.getName().contains("::")) {
                this.logWarning(AcceleoParserMessages.getString("CSTParser.UnqualifiedImport"), beginHeader.e(), eH.b());
            }
            eModule.getImports().add((Object)eModuleImportsValue);
            posBegin = eH.e();
        }
        return posBegin;
    }

    private int parseTemplateEnding(Region beginHeader, int posEnd, Module eModule) {
        int posBegin;
        Region eH = this.pTemplate.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.logProblem(AcceleoParserMessages.getString(INVALID_STMT_HEADER, "template"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pTemplate.getEndHeaderBody()) {
            posBegin = eH.e();
            Template eTemplate = CstFactory.eINSTANCE.createTemplate();
            this.setPositions(eTemplate, beginHeader.b(), eH.e());
            eModule.getOwnedModuleElement().add((Object)eTemplate);
            this.parseTemplateHeader(beginHeader.e(), eH.b(), eTemplate);
        } else {
            Region eB = this.pTemplate.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.logProblem(AcceleoParserMessages.getString(INVALID_STMT, "template"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                posBegin = eB.e();
                Template eTemplate = CstFactory.eINSTANCE.createTemplate();
                this.setPositions(eTemplate, beginHeader.b(), eB.e());
                eModule.getOwnedModuleElement().add((Object)eTemplate);
                this.parseTemplateHeader(beginHeader.e(), eH.b(), eTemplate);
                this.parseTemplateBody(eH.e(), eB.b(), eTemplate);
            }
        }
        return posBegin;
    }

    private int parseMacroEnding(Region beginHeader, int posEnd, Module eModule) {
        int posBegin;
        Region eH = this.pMacro.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.logProblem(AcceleoParserMessages.getString(INVALID_STMT_HEADER, "macro"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pMacro.getEndHeaderBody()) {
            posBegin = eH.e();
            Macro eMacro = CstFactory.eINSTANCE.createMacro();
            this.setPositions(eMacro, beginHeader.b(), eH.e());
            eModule.getOwnedModuleElement().add((Object)eMacro);
            this.parseMacroHeader(beginHeader.e(), eH.b(), eMacro);
        } else {
            Region eB = this.pMacro.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.logProblem(AcceleoParserMessages.getString(INVALID_STMT, "macro"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                posBegin = eB.e();
                Macro eMacro = CstFactory.eINSTANCE.createMacro();
                this.setPositions(eMacro, beginHeader.b(), eB.e());
                eModule.getOwnedModuleElement().add((Object)eMacro);
                this.parseMacroHeader(beginHeader.e(), eH.b(), eMacro);
                this.parseMacroBody(eH.e(), eB.b(), eMacro);
            }
        }
        return posBegin;
    }

    private int parseQueryEnding(Region beginHeader, int posEnd, Module eModule) {
        int posBegin;
        Region eH = this.pQuery.searchEndHeaderAtBeginHeader(this.source.getBuffer(), beginHeader, posEnd);
        if (eH.b() == -1) {
            this.logProblem(AcceleoParserMessages.getString(INVALID_STMT_HEADER, "query"), beginHeader.b(), beginHeader.e());
            posBegin = -1;
        } else if (eH.getSequence() == this.pQuery.getEndHeaderBody()) {
            posBegin = eH.e();
            Query eQuery = CstFactory.eINSTANCE.createQuery();
            this.setPositions(eQuery, beginHeader.b(), eH.e());
            eModule.getOwnedModuleElement().add((Object)eQuery);
            this.parseQueryHeader(beginHeader.e(), eH.b(), eQuery);
        } else {
            Region eB = this.pQuery.searchEndBodyAtEndHeader(this.source.getBuffer(), eH, posEnd);
            if (eB.b() == -1) {
                this.logProblem(AcceleoParserMessages.getString("CSTParser.InvalidQuery"), beginHeader.b(), beginHeader.e());
                posBegin = -1;
            } else {
                this.logProblem(AcceleoParserMessages.getString("CSTParser.InvalidQuery"), beginHeader.b(), eB.e());
                posBegin = eB.e();
                Query eQuery = CstFactory.eINSTANCE.createQuery();
                this.setPositions(eQuery, beginHeader.b(), eB.e());
                eModule.getOwnedModuleElement().add((Object)eQuery);
                this.parseQueryHeader(beginHeader.e(), eH.b(), eQuery);
            }
        }
        return posBegin;
    }

    public void parseTemplateHeader(int posBegin, int posEnd, Template eTemplate) {
        int posShift = this.shiftVisibility(posBegin, posEnd, eTemplate);
        Region bH = this.pParenthesis.searchBeginHeader(this.source.getBuffer(), posShift, posEnd);
        if (bH.b() == -1) {
            this.logProblem(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_ARE_REQUIRED, posShift, posEnd);
            String name = this.source.getBuffer().substring(posShift, posEnd).trim();
            if (!ParserUtils.isIdentifier(name)) {
                this.logProblem(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_NAME_NOT_VALID) + name, posShift, posEnd);
            }
            eTemplate.setName(name);
            if (ACCELEO_KEYWORDS.contains(name) || AcceleoOCLReflection.getReservedKeywords().contains(name)) {
                this.logWarning(AcceleoParserMessages.getString("CSTParser.InvalidTemplateName", name), posShift, posEnd);
            }
        } else {
            String name = this.source.getBuffer().substring(posShift, bH.b()).trim();
            if (!ParserUtils.isIdentifier(name)) {
                this.logProblem(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_NAME_NOT_VALID) + name, posShift, bH.b());
            }
            if (ACCELEO_KEYWORDS.contains(name) || AcceleoOCLReflection.getReservedKeywords().contains(name)) {
                this.logWarning(AcceleoParserMessages.getString("CSTParser.InvalidTemplateName", name), posShift, bH.b());
            }
            eTemplate.setName(name);
            Region eH = this.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bH, posEnd);
            if (eH.b() == -1) {
                this.logProblem(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bH.b(), bH.e());
            } else {
                Variable[] eVariables = this.createVariablesCommaSeparator(bH.e(), eH.b());
                int i = 0;
                while (eVariables != null && i < eVariables.length) {
                    Variable eVariable = eVariables[i];
                    if (eVariable != null) {
                        eTemplate.getParameter().add((Object)eVariable);
                    }
                    ++i;
                }
                int currentPosBegin = eH.e();
                int currentPosEnd = this.parseTemplateHeaderIndexOfGuardOrPostOrBrackets(currentPosBegin, posEnd);
                currentPosBegin = this.parseTemplateHeaderOverrides(currentPosBegin, currentPosEnd, eTemplate);
                currentPosEnd = posEnd;
                currentPosBegin = this.parseTemplateHeaderGuard(currentPosBegin, currentPosEnd, posEnd, eTemplate);
                currentPosBegin = this.parseTemplateHeaderPost(currentPosBegin, currentPosEnd, posEnd, eTemplate);
                currentPosBegin = this.shiftInitSectionBody(currentPosBegin, currentPosEnd, eTemplate);
                if (this.source.getBuffer().substring(currentPosBegin, posEnd).trim().length() > 0) {
                    this.logProblem(IAcceleoParserProblemsConstants.SYNTAX_TEXT_NOT_VALID, currentPosBegin, posEnd);
                }
                if (eTemplate.getParameter().isEmpty()) {
                    this.logWarning(AcceleoParserMessages.getString("CSTParser.MissingParameters"), eTemplate.getStartPosition(), eTemplate.getEndPosition());
                }
            }
        }
    }

    private int parseTemplateHeaderIndexOfGuardOrPostOrBrackets(int posBegin, int posEnd) {
        int currentPosEnd = posEnd;
        Region guard = this.pGuard.search(this.source.getBuffer(), posBegin, currentPosEnd, null, new SequenceBlock[]{this.pLiteral});
        if (guard.b() > -1) {
            currentPosEnd = guard.b();
        } else {
            Region post = this.pPost.search(this.source.getBuffer(), posBegin, currentPosEnd, null, new SequenceBlock[]{this.pLiteral});
            if (post.b() > -1) {
                currentPosEnd = post.b();
            } else {
                Region bracket = this.pBrackets.search(this.source.getBuffer(), posBegin, currentPosEnd, null, new SequenceBlock[]{this.pLiteral});
                if (bracket.b() > -1) {
                    currentPosEnd = bracket.b();
                }
            }
        }
        return currentPosEnd;
    }

    private int parseTemplateHeaderOverrides(int posBegin, int posEnd, Template eTemplate) {
        int currentPosBegin = posBegin;
        int bOverride = ParserUtils.shiftKeyword(this.source.getBuffer(), currentPosBegin, posEnd, "overrides", true);
        if (bOverride != currentPosBegin) {
            currentPosBegin = bOverride;
            while (currentPosBegin != posEnd) {
                TemplateOverridesValue eTemplateOverridesValue;
                Region comma = this.pComma.search(this.source.getBuffer(), currentPosBegin, posEnd, null, new SequenceBlock[]{this.pLiteral});
                if (comma.b() == -1) {
                    eTemplateOverridesValue = CstFactory.eINSTANCE.createTemplateOverridesValue();
                    this.setPositions(eTemplateOverridesValue, currentPosBegin, posEnd);
                    eTemplateOverridesValue.setName(this.source.getBuffer().substring(currentPosBegin, posEnd).trim());
                    eTemplate.getOverrides().add((Object)eTemplateOverridesValue);
                    currentPosBegin = posEnd;
                    continue;
                }
                eTemplateOverridesValue = CstFactory.eINSTANCE.createTemplateOverridesValue();
                this.setPositions(eTemplateOverridesValue, currentPosBegin, comma.b());
                eTemplateOverridesValue.setName(this.source.getBuffer().substring(currentPosBegin, comma.b()).trim());
                eTemplate.getOverrides().add((Object)eTemplateOverridesValue);
                currentPosBegin = comma.e();
            }
        }
        return currentPosBegin;
    }

    private int parseTemplateHeaderGuard(int posBegin, int posEnd, int headerPosEnd, Template eTemplate) {
        int currentPos = posBegin;
        int bGuard = ParserUtils.shiftKeyword(this.source.getBuffer(), currentPos, posEnd, "?", false);
        if (bGuard != currentPos) {
            currentPos = bGuard;
            if (ParserUtils.shiftKeyword(this.source.getBuffer(), currentPos, posEnd, "(", false) == currentPos) {
                this.logProblem(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_ARE_REQUIRED, currentPos, posEnd);
                currentPos = headerPosEnd;
            } else {
                Region bHParenthesis = this.pParenthesis.searchBeginHeader(this.source.getBuffer(), currentPos, posEnd);
                Region eHParenthesis = this.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bHParenthesis, posEnd);
                if (eHParenthesis.b() == -1) {
                    this.logProblem(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bHParenthesis.b(), bHParenthesis.e());
                    currentPos = headerPosEnd;
                } else {
                    ModelExpression eGuard = CstFactory.eINSTANCE.createModelExpression();
                    this.setPositions(eGuard, bHParenthesis.e(), eHParenthesis.b());
                    eTemplate.setGuard(eGuard);
                    this.pBlock.parseExpressionHeader(bHParenthesis.e(), eHParenthesis.b(), eGuard);
                    currentPos = eHParenthesis.e();
                }
            }
        }
        return currentPos;
    }

    private int parseTemplateHeaderPost(int posBegin, int posEnd, int headerPosEnd, Template eTemplate) {
        int currentPos = posBegin;
        int bPost = ParserUtils.shiftKeyword(this.source.getBuffer(), currentPos, posEnd, "post", false);
        if (bPost != currentPos) {
            currentPos = bPost;
            if (ParserUtils.shiftKeyword(this.source.getBuffer(), currentPos, posEnd, "(", false) == currentPos) {
                this.logProblem(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_ARE_REQUIRED, currentPos, posEnd);
                currentPos = headerPosEnd;
            } else {
                Region bHParenthesis = this.pParenthesis.searchBeginHeader(this.source.getBuffer(), currentPos, posEnd);
                Region eHParenthesis = this.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bHParenthesis, posEnd);
                if (eHParenthesis.b() == -1) {
                    this.logProblem(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bHParenthesis.b(), bHParenthesis.e());
                    currentPos = headerPosEnd;
                } else {
                    ModelExpression ePost = CstFactory.eINSTANCE.createModelExpression();
                    this.setPositions(ePost, bHParenthesis.e(), eHParenthesis.b());
                    eTemplate.setPost(ePost);
                    this.pBlock.parseExpressionHeader(bHParenthesis.e(), eHParenthesis.b(), ePost);
                    currentPos = eHParenthesis.e();
                }
            }
        }
        return currentPos;
    }

    private int shiftVisibility(int posBegin, int posEnd, ModuleElement eModuleElement) {
        int b = posBegin;
        int posShift = ParserUtils.shiftKeyword(this.source.getBuffer(), posBegin, posEnd, "private", true);
        if (b != posShift) {
            eModuleElement.setVisibility(VisibilityKind.PRIVATE);
        } else {
            posShift = ParserUtils.shiftKeyword(this.source.getBuffer(), posShift, posEnd, "protected", true);
            if (b != posShift) {
                eModuleElement.setVisibility(VisibilityKind.PROTECTED);
            } else {
                posShift = ParserUtils.shiftKeyword(this.source.getBuffer(), posShift, posEnd, "public", true);
                if (b != posShift) {
                    eModuleElement.setVisibility(VisibilityKind.PUBLIC);
                } else {
                    this.logWarning(AcceleoParserMessages.getString("CSTParser.MissingVisibility"), eModuleElement.getStartPosition(), eModuleElement.getStartPosition());
                }
            }
        }
        return posShift;
    }

    protected int shiftInitSectionBody(int posBegin, int posEnd, Block eBlock) {
        if (ParserUtils.shiftKeyword(this.source.getBuffer(), posBegin, posEnd, "{", false) != posBegin) {
            int posResult;
            Region bHBrackets = this.pBrackets.searchBeginHeader(this.source.getBuffer(), posBegin, posEnd);
            Region eHBrackets = this.pBrackets.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bHBrackets, posEnd);
            if (eHBrackets.b() == -1) {
                this.logProblem(AcceleoParserMessages.getString("CSTParser.MissingClosingBracket"), bHBrackets.b(), bHBrackets.e());
                posResult = posEnd;
            } else {
                InitSection eInitSection = CstFactory.eINSTANCE.createInitSection();
                this.setPositions(eInitSection, bHBrackets.b(), eHBrackets.e());
                eBlock.setInit(eInitSection);
                boolean semicolonFound = this.shiftInitSectionBodyCreatesVariables(bHBrackets.e(), eHBrackets.b(), eInitSection);
                if (!semicolonFound) {
                    this.logProblem(AcceleoParserMessages.getString(MISSING_CHARACTER_KEY, ";"), bHBrackets.e(), eHBrackets.b());
                }
                posResult = eHBrackets.e();
            }
            return posResult;
        }
        return posBegin;
    }

    private boolean shiftInitSectionBodyCreatesVariables(int posBegin, int posEnd, InitSection eInitSection) {
        List<Region> positions = this.pSemicolon.split(this.source.getBuffer(), posBegin, posEnd, true, null, null);
        boolean semicolonFound = false;
        int i = 0;
        while (i < positions.size()) {
            Variable eVariable;
            Region variablePos = positions.get(i);
            String text = this.source.getBuffer().substring(variablePos.b(), variablePos.e()).trim();
            if (text.equals(";")) {
                if (!semicolonFound) {
                    semicolonFound = true;
                }
            } else if (text.length() > 0 && (eVariable = this.createVariable(variablePos.b(), variablePos.e())) != null) {
                eInitSection.getVariable().add((Object)eVariable);
            }
            ++i;
        }
        return semicolonFound;
    }

    protected Variable[] createVariablesCommaSeparator(int posBegin, int posEnd) {
        List<Region> positions = this.pComma.split(this.source.getBuffer(), posBegin, posEnd, false, null, null);
        Variable[] eVariables = new Variable[positions.size()];
        ArrayList<String> variableNames = new ArrayList<String>();
        int i = 0;
        while (i < eVariables.length) {
            Variable eVariable;
            Region variablePos = positions.get(i);
            eVariables[i] = eVariable = this.createVariable(variablePos.b(), variablePos.e());
            if (eVariable != null) {
                if (!variableNames.contains(eVariable.getName())) {
                    variableNames.add(eVariable.getName());
                } else {
                    this.logProblem(AcceleoParserMessages.getString("CSTParser.DuplicatedVariable", eVariable.getName()), variablePos.b(), variablePos.e());
                }
            }
            ++i;
        }
        return eVariables;
    }

    public Variable createVariable(int posBegin, int posEnd) {
        Variable eVariable;
        String variableBuffer = this.source.getBuffer().substring(posBegin, posEnd);
        int bDot = variableBuffer.indexOf(":");
        if (bDot == -1) {
            this.logProblem(AcceleoParserMessages.getString("CSTParser.InvalidVariable", variableBuffer.trim()), posBegin, posEnd);
            eVariable = null;
        } else {
            String name = variableBuffer.substring(0, bDot);
            String type = variableBuffer.substring(bDot + ":".length());
            eVariable = CstFactory.eINSTANCE.createVariable();
            this.setPositions(eVariable, posBegin, posEnd);
            int bInit = variableBuffer.indexOf("=", bDot + ":".length());
            if (bInit != -1) {
                type = variableBuffer.substring(bDot + ":".length(), bInit);
                String initExpression = variableBuffer.substring(bInit + "=".length());
                ModelExpression eInitExpression = CstFactory.eINSTANCE.createModelExpression();
                this.setPositions(eInitExpression, posBegin + bInit + "=".length(), posEnd);
                eVariable.setInitExpression(eInitExpression);
                eInitExpression.setBody(initExpression);
                this.pBlock.parseExpressionHeader(posBegin + bInit + "=".length(), posEnd, eInitExpression);
            }
            eVariable.setName(name.trim());
            if (!ParserUtils.isIdentifier(name.trim())) {
                this.logProblem(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_NAME_NOT_VALID) + name.trim(), posBegin, posEnd);
            }
            if (ACCELEO_KEYWORDS.contains(name.trim()) || AcceleoOCLReflection.getReservedKeywords().contains(name.trim())) {
                this.logWarning(AcceleoParserMessages.getString("CSTParser.InvalidVariableName", name), posBegin, posEnd);
            }
            eVariable.setType(type.trim());
        }
        return eVariable;
    }

    protected Module getModule(EObject eObject) {
        EObject current = eObject;
        while (current != null) {
            if (current instanceof Module) {
                return (Module)current;
            }
            current = current.eContainer();
        }
        return null;
    }

    public void parseTemplateBody(int posBegin, int posEnd, Template eTemplate) {
        this.pBlock.parse(posBegin, posEnd, eTemplate);
    }

    public void parseQueryHeader(int posBegin, int posEnd, Query eQuery) {
        int posShift = this.shiftVisibility(posBegin, posEnd, eQuery);
        Region bH = this.pParenthesis.searchBeginHeader(this.source.getBuffer(), posShift, posEnd);
        if (bH.b() == -1) {
            this.logProblem(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_ARE_REQUIRED, posShift, posEnd);
            String name = this.source.getBuffer().substring(posShift, posEnd).trim();
            if (!ParserUtils.isIdentifier(name)) {
                this.logProblem(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_NAME_NOT_VALID) + name, posShift, posEnd);
            }
            if (ACCELEO_KEYWORDS.contains(name) || AcceleoOCLReflection.getReservedKeywords().contains(name)) {
                this.logWarning(AcceleoParserMessages.getString("CSTParser.InvalidQueryName", name), posShift, posEnd);
            }
            eQuery.setName(name);
        } else {
            String name = this.source.getBuffer().substring(posShift, bH.b()).trim();
            if (!ParserUtils.isIdentifier(name)) {
                this.logProblem(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_NAME_NOT_VALID) + name, posShift, bH.b());
            }
            if (ACCELEO_KEYWORDS.contains(name) || AcceleoOCLReflection.getReservedKeywords().contains(name)) {
                this.logWarning(AcceleoParserMessages.getString("CSTParser.InvalidQueryName", name), posShift, bH.b());
            }
            eQuery.setName(name);
            Region eH = this.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bH, posEnd);
            if (eH.b() == -1) {
                this.logProblem(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bH.b(), bH.e());
            } else {
                String bodyText;
                int bInit;
                Variable[] eVariables = this.createVariablesCommaSeparator(bH.e(), eH.b());
                int i = 0;
                while (eVariables != null && i < eVariables.length) {
                    Variable eVariable = eVariables[i];
                    if (eVariable != null) {
                        eQuery.getParameter().add((Object)eVariable);
                    }
                    ++i;
                }
                int currentPosBegin = eH.e();
                int eDot = ParserUtils.shiftKeyword(this.source.getBuffer(), currentPosBegin, posEnd, ":", false);
                if (eDot == currentPosBegin) {
                    this.logProblem(AcceleoParserMessages.getString(MISSING_CHARACTER_KEY, ":"), currentPosBegin, posEnd);
                }
                if ((bInit = (bodyText = this.source.getBuffer().substring(eDot, posEnd)).indexOf("=")) != -1) {
                    String type = bodyText.substring(0, bInit).trim();
                    eQuery.setType(type);
                    String initExpression = bodyText.substring(bInit + "=".length());
                    ModelExpression eExpression = CstFactory.eINSTANCE.createModelExpression();
                    this.setPositions(eExpression, eDot + bInit + "=".length(), posEnd);
                    eQuery.setExpression(eExpression);
                    eExpression.setBody(initExpression);
                    this.pBlock.parseExpressionHeader(eDot + bInit + "=".length(), posEnd, eExpression);
                } else {
                    this.logProblem(AcceleoParserMessages.getString(MISSING_CHARACTER_KEY, "="), currentPosBegin, posEnd);
                }
                if (eQuery.getParameter().isEmpty()) {
                    this.logWarning(AcceleoParserMessages.getString("CSTParser.MissingParameters"), eQuery.getStartPosition(), eQuery.getEndPosition());
                }
            }
        }
    }

    public void parseMacroHeader(int posBegin, int posEnd, Macro eMacro) {
        int posShift = this.shiftVisibility(posBegin, posEnd, eMacro);
        Region bH = this.pParenthesis.searchBeginHeader(this.source.getBuffer(), posShift, posEnd);
        if (bH.b() == -1) {
            this.logProblem(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_ARE_REQUIRED, posShift, posEnd);
            String name = this.source.getBuffer().substring(posShift, posEnd).trim();
            if (!ParserUtils.isIdentifier(name)) {
                this.logProblem(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_NAME_NOT_VALID) + name, posShift, posEnd);
            }
            eMacro.setName(name);
            if (ACCELEO_KEYWORDS.contains(name) || AcceleoOCLReflection.getReservedKeywords().contains(name)) {
                this.logWarning(AcceleoParserMessages.getString("CSTParser.InvalidMacroName", name), posShift, posEnd);
            }
        } else {
            Region eH;
            String name = this.source.getBuffer().substring(posShift, bH.b()).trim();
            if (!ParserUtils.isIdentifier(name)) {
                this.logProblem(String.valueOf(IAcceleoParserProblemsConstants.SYNTAX_NAME_NOT_VALID) + name, posShift, bH.b());
            }
            eMacro.setName(name);
            if (ACCELEO_KEYWORDS.contains(name) || AcceleoOCLReflection.getReservedKeywords().contains(name)) {
                this.logWarning(AcceleoParserMessages.getString("CSTParser.InvalidMacroName", name), posShift, bH.b());
            }
            if ((eH = this.pParenthesis.searchEndHeaderAtBeginHeader(this.source.getBuffer(), bH, posEnd)).b() == -1) {
                this.logProblem(IAcceleoParserProblemsConstants.SYNTAX_PARENTHESIS_NOT_TERMINATED, bH.b(), bH.e());
            } else {
                Variable[] eVariables = this.createVariablesCommaSeparator(bH.e(), eH.b());
                int i = 0;
                while (eVariables != null && i < eVariables.length) {
                    Variable eVariable = eVariables[i];
                    if (eVariable != null) {
                        eMacro.getParameter().add((Object)eVariable);
                    }
                    ++i;
                }
                int currentPosBegin = eH.e();
                int eDot = ParserUtils.shiftKeyword(this.source.getBuffer(), currentPosBegin, posEnd, ":", false);
                if (eDot == currentPosBegin) {
                    this.logProblem(AcceleoParserMessages.getString(MISSING_CHARACTER_KEY, ":"), currentPosBegin, posEnd);
                }
                String type = this.source.getBuffer().substring(eDot, posEnd).trim();
                eMacro.setType(type);
            }
        }
    }

    public void parseMacroBody(int posBegin, int posEnd, Macro eMacro) {
        this.pBlock.parse(posBegin, posEnd, eMacro);
    }

    protected void logProblem(String message, int posBegin, int posEnd) {
        this.source.logProblem(message, posBegin, posEnd);
    }

    protected void logWarning(String message, int posBegin, int posEnd) {
        this.source.logWarning(message, posBegin, posEnd);
    }

    protected void logInfo(String message, int posBegin, int posEnd) {
        this.source.logInfo(message, posBegin, posEnd);
    }
}

