/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.batik.util.DoublyLinkedList;
import org.apache.batik.util.HaltingThread;

public class RunnableQueue
implements Runnable {
    public static final RunnableQueueState RUNNING = new RunnableQueueState("Running");
    public static final RunnableQueueState SUSPENDING = new RunnableQueueState("Suspending");
    public static final RunnableQueueState SUSPENDED = new RunnableQueueState("Suspended");
    protected volatile RunnableQueueState state;
    protected final Object stateLock = new Object();
    protected boolean wasResumed;
    private final DoublyLinkedList list = new DoublyLinkedList();
    protected int preemptCount;
    protected RunHandler runHandler;
    protected volatile HaltingThread runnableQueueThread;
    private IdleRunnable idleRunnable;
    private long idleRunnableWaitTime;
    private static volatile int threadCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RunnableQueue createRunnableQueue() {
        RunnableQueue runnableQueue;
        RunnableQueue runnableQueue2 = runnableQueue = new RunnableQueue();
        synchronized (runnableQueue2) {
            HaltingThread haltingThread = new HaltingThread(runnableQueue, "RunnableQueue-" + threadCount++);
            haltingThread.setDaemon(true);
            haltingThread.start();
            while (runnableQueue.getThread() == null) {
                try {
                    runnableQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return runnableQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block53: {
            var1_1 = this;
            synchronized (var1_1) {
                this.runnableQueueThread = (HaltingThread)Thread.currentThread();
                this.notify();
            }
            block37: while (true) {
                while (!HaltingThread.hasBeenHalted()) {
                    var3_4 = false;
                    var4_7 = false;
                    var5_8 = this.stateLock;
                    synchronized (var5_8) {
                        if (this.state != RunnableQueue.RUNNING) {
                            this.state = RunnableQueue.SUSPENDED;
                            var3_4 = true;
                        }
                    }
                    if (var3_4) {
                        this.executionSuspended();
                    }
                    var5_8 = this.stateLock;
                    synchronized (var5_8) {
                        while (this.state != RunnableQueue.RUNNING) {
                            this.state = RunnableQueue.SUSPENDED;
                            this.stateLock.notifyAll();
                            try {
                                this.stateLock.wait();
                            }
                            catch (InterruptedException var6_14) {}
                        }
                        if (this.wasResumed) {
                            this.wasResumed = false;
                            var4_7 = true;
                        }
                    }
                    if (var4_7) {
                        this.executionResumed();
                    }
                    var5_8 = this.list;
                    synchronized (var5_8) {
                        if (this.state == RunnableQueue.SUSPENDING) {
                            continue;
                        }
                        var1_1 = (Link)this.list.pop();
                        if (this.preemptCount != 0) {
                            --this.preemptCount;
                        }
                        if (var1_1 != null) ** GOTO lbl67
                        if (this.idleRunnable != null && (this.idleRunnableWaitTime = this.idleRunnable.getWaitTime()) < System.currentTimeMillis()) {
                            var2_3 = this.idleRunnable;
                        } else {
                            try {
                                if (this.idleRunnable != null && this.idleRunnableWaitTime != 0x7FFFFFFFFFFFFFFFL) {
                                    var6_15 = this.idleRunnableWaitTime - System.currentTimeMillis();
                                    if (var6_15 > 0L) {
                                        this.list.wait(var6_15);
                                    }
                                } else {
                                    this.list.wait();
                                }
                            }
                            catch (InterruptedException var6_16) {
                                // empty catch block
                            }
                            continue;
lbl67:
                            // 1 sources

                            var2_3 = Link.access$100((Link)var1_1);
                        }
                    }
                    try {
                        this.runnableStart(var2_3);
                        var2_3.run();
                    }
                    catch (ThreadDeath var5_9) {
                        throw var5_9;
                    }
                    catch (Throwable var5_10) {
                        var5_10.printStackTrace();
                    }
                    if (var1_1 != null) {
                        var1_1.unlock();
                    }
                    try {
                        this.runnableInvoked(var2_3);
                        continue block37;
                    }
                    catch (ThreadDeath var5_11) {
                        throw var5_11;
                    }
                    catch (Throwable var5_12) {
                        var5_12.printStackTrace();
                    }
                }
                break block53;
                {
                    continue block37;
                    break;
                }
                break;
            }
            finally {
                while (true) {
                    var3_6 = this.list;
                    synchronized (var3_6) {
                        var1_1 = (Link)this.list.pop();
                    }
                    if (var1_1 == null) break;
                    var1_1.unlock();
                }
                var3_6 = this;
                synchronized (var3_6) {
                    this.runnableQueueThread = null;
                }
            }
        }
    }

    public HaltingThread getThread() {
        return this.runnableQueueThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable runnable) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.push(new Link(runnable));
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(Runnable runnable) throws InterruptedException {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        if (this.runnableQueueThread == Thread.currentThread()) {
            throw new IllegalStateException("Cannot be called from the RunnableQueue thread");
        }
        LockableLink lockableLink = new LockableLink(runnable);
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.push(lockableLink);
            this.list.notify();
        }
        lockableLink.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preemptLater(Runnable runnable) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.add(this.preemptCount, new Link(runnable));
            ++this.preemptCount;
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preemptAndWait(Runnable runnable) throws InterruptedException {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        if (this.runnableQueueThread == Thread.currentThread()) {
            throw new IllegalStateException("Cannot be called from the RunnableQueue thread");
        }
        LockableLink lockableLink = new LockableLink(runnable);
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.add(this.preemptCount, lockableLink);
            ++this.preemptCount;
            this.list.notify();
        }
        lockableLink.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunnableQueueState getQueueState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendExecution(boolean bl) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.wasResumed = false;
            if (this.state == SUSPENDED) {
                this.stateLock.notifyAll();
                return;
            }
            if (this.state == RUNNING) {
                this.state = SUSPENDING;
                DoublyLinkedList doublyLinkedList = this.list;
                synchronized (doublyLinkedList) {
                    this.list.notify();
                }
            }
            if (bl) {
                while (this.state == SUSPENDING) {
                    try {
                        this.stateLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeExecution() {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.wasResumed = true;
            if (this.state != RUNNING) {
                this.state = RUNNING;
                this.stateLock.notifyAll();
            }
        }
    }

    public Object getIteratorLock() {
        return this.list;
    }

    public Iterator iterator() {
        return new Iterator(){
            Link head;
            Link link;
            {
                this.head = (Link)RunnableQueue.this.list.getHead();
            }

            @Override
            public boolean hasNext() {
                if (this.head == null) {
                    return false;
                }
                if (this.link == null) {
                    return true;
                }
                return this.link != this.head;
            }

            public Object next() {
                if (this.head == null || this.head == this.link) {
                    throw new NoSuchElementException();
                }
                if (this.link == null) {
                    this.link = (Link)this.head.getNext();
                    return this.head.runnable;
                }
                Runnable runnable = this.link.runnable;
                this.link = (Link)this.link.getNext();
                return runnable;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public synchronized void setRunHandler(RunHandler runHandler) {
        this.runHandler = runHandler;
    }

    public synchronized RunHandler getRunHandler() {
        return this.runHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdleRunnable(IdleRunnable idleRunnable) {
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.idleRunnable = idleRunnable;
            this.idleRunnableWaitTime = 0L;
            this.list.notify();
        }
    }

    protected synchronized void executionSuspended() {
        if (this.runHandler != null) {
            this.runHandler.executionSuspended(this);
        }
    }

    protected synchronized void executionResumed() {
        if (this.runHandler != null) {
            this.runHandler.executionResumed(this);
        }
    }

    protected synchronized void runnableStart(Runnable runnable) {
        if (this.runHandler != null) {
            this.runHandler.runnableStart(this, runnable);
        }
    }

    protected synchronized void runnableInvoked(Runnable runnable) {
        if (this.runHandler != null) {
            this.runHandler.runnableInvoked(this, runnable);
        }
    }

    public static interface IdleRunnable
    extends Runnable {
        public long getWaitTime();
    }

    protected static class Link
    extends DoublyLinkedList.Node {
        private final Runnable runnable;

        public Link(Runnable runnable) {
            this.runnable = runnable;
        }

        public void unlock() {
        }
    }

    protected static class LockableLink
    extends Link {
        private volatile boolean locked;

        public LockableLink(Runnable runnable) {
            super(runnable);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public synchronized void lock() throws InterruptedException {
            this.locked = true;
            this.notify();
            this.wait();
        }

        @Override
        public synchronized void unlock() {
            while (!this.locked) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.locked = false;
            this.notify();
        }
    }

    public static interface RunHandler {
        public void runnableStart(RunnableQueue var1, Runnable var2);

        public void runnableInvoked(RunnableQueue var1, Runnable var2);

        public void executionSuspended(RunnableQueue var1);

        public void executionResumed(RunnableQueue var1);
    }

    public static class RunHandlerAdapter
    implements RunHandler {
        @Override
        public void runnableStart(RunnableQueue runnableQueue, Runnable runnable) {
        }

        @Override
        public void runnableInvoked(RunnableQueue runnableQueue, Runnable runnable) {
        }

        @Override
        public void executionSuspended(RunnableQueue runnableQueue) {
        }

        @Override
        public void executionResumed(RunnableQueue runnableQueue) {
        }
    }

    public static final class RunnableQueueState {
        private final String value;

        private RunnableQueueState(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "[RunnableQueueState: " + this.value + ']';
        }
    }
}

