/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint;

import com.google.common.collect.Maps;
import java.util.Map;

public final class RGBValues {
    private static final Map<String, RGBValues> INTERN = Maps.newHashMap();
    public static final RGBValues DEFAULT_GRAY = new RGBValues(209, 209, 209);
    private static final String SEPARATOR = ",";
    private int red;
    private int green;
    private int blue;

    private RGBValues(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.blue;
        result = 31 * result + this.green;
        result = 31 * result + this.red;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RGBValues other = (RGBValues)obj;
        if (this.blue != other.blue) {
            return false;
        }
        if (this.green != other.green) {
            return false;
        }
        return this.red == other.red;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.red);
        result.append(SEPARATOR);
        result.append(this.green);
        result.append(SEPARATOR);
        result.append(this.blue);
        return result.toString();
    }

    public static RGBValues create(int r, int g, int b) {
        String key = RGBValues.computeKey(r, g, b);
        RGBValues found = INTERN.get(key);
        if (found == null) {
            found = new RGBValues(r, g, b);
            INTERN.put(key, found);
        }
        return found;
    }

    private static String computeKey(int r, int g, int b) {
        return String.valueOf(r) + SEPARATOR + g + SEPARATOR + b;
    }

    public static RGBValues integerToRGBValues(int color) {
        return RGBValues.create(color & 0xFF, (color & 0xFF00) >> 8, (color & 0xFF0000) >> 16);
    }
}

