/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.provider.Messages;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.AbstractTransactionalTableAction;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class AbstractHideRevealAction<T extends EObject>
extends AbstractTransactionalTableAction {
    public AbstractHideRevealAction(DTable dTable, String text, ImageDescriptor image, TransactionalEditingDomain editingDomain, ITableCommandFactory tableCommandFactory) {
        super(dTable, text, image, editingDomain, tableCommandFactory);
    }

    public void run() {
        Collection<T> visibleElements = this.getInitialVisibleElements();
        SelectionDialog dlg = this.createSelectionDialog();
        dlg.setBlockOnOpen(true);
        dlg.setTitle(this.getTitle());
        dlg.setMessage(this.getMessage());
        dlg.setInitialSelections(visibleElements.toArray());
        dlg.setHelpAvailable(false);
        dlg.open();
        if (dlg.getReturnCode() == 0 && dlg.getResult() != null) {
            ArrayList newVisibles = Lists.newArrayList((Object[])dlg.getResult());
            CompoundCommand compoundCommand = new CompoundCommand(MessageFormat.format(Messages.Action_setValues, this.getSetVisibleMethodName()));
            for (EObject element : this.getAllElements()) {
                boolean visible = newVisibles.contains(element);
                if (!(visible ^ this.isVisibleElement(element))) continue;
                compoundCommand.append(this.getTableCommandFactory().buildSetValue(element, this.getSetVisibleMethodName(), (Object)visible));
            }
            this.getEditingDomain().getCommandStack().execute((Command)compoundCommand);
        }
    }

    protected abstract String getSetVisibleMethodName();

    protected abstract Collection<T> getInitialVisibleElements();

    protected abstract String getTitle();

    protected abstract String getMessage();

    protected abstract List<T> getAllElements();

    protected abstract SelectionDialog createSelectionDialog();

    protected abstract boolean isVisibleElement(T var1);
}

