/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class FatJarPackagerUtil {
    static final String ANTSCRIPT_EXTENSION = "xml";

    private FatJarPackagerUtil() {
    }

    public static boolean askToCreateAntScriptDirectory(Shell parent, File directory) {
        if (parent == null) {
            return false;
        }
        return FatJarPackagerUtil.queryDialog(parent, FatJarPackagerMessages.FatJarPackage_confirmCreate_title, Messages.format(FatJarPackagerMessages.FatJarPackageAntScript_confirmCreate_message, BasicElementLabels.getPathLabel((File)directory)));
    }

    private static boolean queryDialog(final Shell parent, final String title, final String message) {
        Display display = parent.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        final boolean[] returnValue = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                returnValue[0] = MessageDialog.openQuestion((Shell)parent, (String)title, (String)message);
            }
        };
        display.syncExec(runnable);
        return returnValue[0];
    }

    public static byte[] readInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int cnt = is.read(buf);
        while (cnt > 0) {
            result.write(buf, 0, cnt);
            cnt = is.read(buf);
        }
        return result.toByteArray();
    }

    public static String nextNumberedFileName(String fileName) {
        String ext;
        String number;
        String name;
        if (fileName.matches(".*[_]\\d+[.][^.]*")) {
            name = fileName.replaceFirst("(.*)[_](\\d+)([.][^.]*)", "$1");
            number = fileName.replaceFirst("(.*)[_](\\d+)([.][^.]*)", "$2");
            ext = fileName.replaceFirst("(.*)[_](\\d+)([.][^.]*)", "$3");
        } else if (fileName.matches(".*[.][^.]*")) {
            name = fileName.replaceFirst("(.*)([.][^.]*)", "$1");
            number = "1";
            ext = fileName.replaceFirst("(.*)([.][^.]*)", "$2");
        } else {
            name = fileName;
            number = "1";
            ext = "";
        }
        fileName = String.valueOf(name) + "_" + (Integer.parseInt(number) + 1) + ext;
        return fileName;
    }
}

