/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.contentassist;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class JavaPrecomputedNamesAssistProcessor
implements ISubjectControlContentAssistProcessor {
    private Iterable<String> fNames;
    private Image fImage;
    private char[] fProposalAutoActivationSet;

    public JavaPrecomputedNamesAssistProcessor(Iterable<String> names, Image image) {
        this.fNames = names;
        this.fImage = image;
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        String triggers = preferenceStore.getString("content_assist_autoactivation_triggers_java");
        this.fProposalAutoActivationSet = triggers.toCharArray();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        ArrayList<JavaCompletionProposal> proposals = new ArrayList<JavaCompletionProposal>();
        String input = contentAssistSubjectControl.getDocument().get();
        String prefix = input.substring(0, documentOffset).trim();
        for (String name : this.fNames) {
            if (!input.isEmpty() && !name.startsWith(prefix)) continue;
            JavaCompletionProposal proposal = new JavaCompletionProposal(name, 0, input.length(), this.fImage, name, 0);
            proposals.add(proposal);
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }
}

