/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaWorkbenchAdapter;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private ImageDescriptorRegistry fRegistry;

    public JavaElementImageProvider() {
        ISharedImages images = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = images.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
        this.fRegistry = null;
    }

    public Image getImageLabel(Object element, int flags) {
        return this.getImageLabel(this.computeDescriptor(element, flags));
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private ImageDescriptor computeDescriptor(Object element, int flags) {
        if (element instanceof IJavaElement) {
            return this.getJavaImageDescriptor((IJavaElement)element, flags);
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            if (JavaCore.isJavaLikeFileName((String)file.getName())) {
                return this.getCUResourceImageDescriptor(file, flags);
            }
            return this.getWorkbenchImageDescriptor((IAdaptable)file, flags);
        }
        if (element instanceof IAdaptable) {
            return this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        return null;
    }

    private static boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    private static boolean useLightIcons(int flags) {
        return (flags & 4) != 0;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile file, int flags) {
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CUNIT_RESOURCE, 0, size);
    }

    public ImageDescriptor getJavaImageDescriptor(IJavaElement element, int flags) {
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        ImageDescriptor baseDesc = this.getBaseImageDescriptor(element, flags);
        if (baseDesc != null) {
            int adornmentFlags = this.computeJavaAdornmentFlags(element, flags);
            return new JavaElementImageDescriptor(baseDesc, adornmentFlags, size);
        }
        return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_GHOST, 0, size);
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new JavaElementImageDescriptor(descriptor, 0, size);
    }

    public ImageDescriptor getBaseImageDescriptor(IJavaElement element, int renderFlags) {
        try {
            ImageDescriptor imageDescriptor;
            switch (element.getElementType()) {
                case 10: {
                    return JavaPluginImages.DESC_MISC_PRIVATE;
                }
                case 9: {
                    IMethod method = (IMethod)element;
                    IType declType = method.getDeclaringType();
                    int flags = method.getFlags();
                    if (declType.isEnum() && JavaElementImageProvider.isDefaultFlag(flags) && method.isConstructor()) {
                        return JavaPluginImages.DESC_MISC_PRIVATE;
                    }
                    return JavaElementImageProvider.getMethodImageDescriptor(JavaModelUtil.isInterfaceOrAnnotation((IType)declType), flags);
                }
                case 8: {
                    IMember member = (IMember)element;
                    IType declType = member.getDeclaringType();
                    return JavaElementImageProvider.getFieldImageDescriptor(JavaModelUtil.isInterfaceOrAnnotation((IType)declType), member.getFlags());
                }
                case 14: {
                    return JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE;
                }
                case 11: {
                    return JavaPluginImages.DESC_OBJS_PACKDECL;
                }
                case 13: {
                    return JavaPluginImages.DESC_OBJS_IMPDECL;
                }
                case 12: {
                    return JavaPluginImages.DESC_OBJS_IMPCONT;
                }
                case 7: {
                    IType type = (IType)element;
                    IType declType = type.getDeclaringType();
                    boolean isInner = declType != null;
                    boolean isInInterfaceOrAnnotation = isInner && JavaModelUtil.isInterfaceOrAnnotation((IType)declType);
                    return JavaElementImageProvider.getTypeImageDescriptor(isInner, isInInterfaceOrAnnotation, type.getFlags(), JavaElementImageProvider.useLightIcons(renderFlags));
                }
                case 3: {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    IPath attach = root.getSourceAttachmentPath();
                    if (root.getKind() == 2) {
                        if (root.isArchive()) {
                            if (root.isExternal()) {
                                if (attach == null) {
                                    return JavaPluginImages.DESC_OBJS_EXTJAR;
                                }
                                return JavaPluginImages.DESC_OBJS_EXTJAR_WSRC;
                            }
                            if (attach == null) {
                                return JavaPluginImages.DESC_OBJS_JAR;
                            }
                            return JavaPluginImages.DESC_OBJS_JAR_WSRC;
                        }
                        if (attach == null) {
                            return JavaPluginImages.DESC_OBJS_CLASSFOLDER;
                        }
                        return JavaPluginImages.DESC_OBJS_CLASSFOLDER_WSRC;
                    }
                    return JavaPluginImages.DESC_OBJS_PACKFRAG_ROOT;
                }
                case 4: {
                    return this.getPackageFragmentIcon(element);
                }
                case 5: {
                    return JavaPluginImages.DESC_OBJS_CUNIT;
                }
                case 6: {
                    return JavaPluginImages.DESC_OBJS_CFILE;
                }
                case 2: {
                    IJavaProject jp = (IJavaProject)element;
                    if (jp.getProject().isOpen()) {
                        ImageDescriptor result;
                        IProject project = jp.getProject();
                        IWorkbenchAdapter adapter = (IWorkbenchAdapter)project.getAdapter(IWorkbenchAdapter.class);
                        if (adapter != null && (result = adapter.getImageDescriptor((Object)project)) != null) {
                            return result;
                        }
                        return DESC_OBJ_PROJECT;
                    }
                    return DESC_OBJ_PROJECT_CLOSED;
                }
                case 1: {
                    return JavaPluginImages.DESC_OBJS_JAVA_MODEL;
                }
                case 15: {
                    return JavaPluginImages.DESC_OBJS_TYPEVARIABLE;
                }
                case 16: {
                    return JavaPluginImages.DESC_OBJS_ANNOTATION;
                }
                case 17: {
                    return JavaPluginImages.DESC_OBJS_MODULE;
                }
            }
            IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)element.getAdapter(IWorkbenchAdapter.class);
            if (wbAdapter != null && !(wbAdapter instanceof JavaWorkbenchAdapter) && (imageDescriptor = wbAdapter.getImageDescriptor((Object)element)) != null) {
                return imageDescriptor;
            }
            return JavaPluginImages.DESC_OBJS_GHOST;
        }
        catch (JavaModelException e) {
            if (e.isDoesNotExist()) {
                return JavaPluginImages.DESC_OBJS_UNKNOWN;
            }
            JavaPlugin.log(e);
            return JavaPluginImages.DESC_OBJS_GHOST;
        }
    }

    private static boolean isDefaultFlag(int flags) {
        return !Flags.isPublic((int)flags) && !Flags.isProtected((int)flags) && !Flags.isPrivate((int)flags);
    }

    private ImageDescriptor getPackageFragmentIcon(IJavaElement element) throws JavaModelException {
        IPackageFragment fragment = (IPackageFragment)element;
        boolean containsJavaElements = false;
        try {
            containsJavaElements = fragment.hasChildren();
        }
        catch (JavaModelException javaModelException) {}
        if (!containsJavaElements && fragment.getNonJavaResources().length > 0) {
            return JavaPluginImages.DESC_OBJS_EMPTY_PACKAGE_RESOURCES;
        }
        if (!containsJavaElements) {
            return JavaPluginImages.DESC_OBJS_EMPTY_PACKAGE;
        }
        return JavaPluginImages.DESC_OBJS_PACKAGE;
    }

    public void dispose() {
    }

    private int computeJavaAdornmentFlags(IJavaElement element, int renderFlags) {
        int flags = 0;
        if (JavaElementImageProvider.showOverlayIcons(renderFlags)) {
            try {
                if (element instanceof IMember) {
                    int elementType;
                    IMember member = (IMember)element;
                    int modifiers = member.getFlags();
                    if (JavaElementImageProvider.confirmAbstract(member) && JdtFlags.isAbstract((IMember)member)) {
                        flags |= 1;
                    }
                    if (Flags.isFinal((int)modifiers) || JavaElementImageProvider.isInterfaceOrAnnotationField(member) || JavaElementImageProvider.isEnumConstant(member, modifiers)) {
                        flags |= 2;
                    }
                    if (JdtFlags.isStatic((IMember)member)) {
                        flags |= 8;
                    }
                    if (Flags.isDeprecated((int)modifiers)) {
                        flags |= 0x400;
                    }
                    if ((elementType = element.getElementType()) == 9) {
                        if (((IMethod)element).isConstructor()) {
                            flags |= 0x200;
                        }
                        if (Flags.isSynchronized((int)modifiers)) {
                            flags |= 4;
                        }
                        if (Flags.isNative((int)modifiers)) {
                            flags |= 0x4000;
                        }
                        if (Flags.isDefaultMethod((int)modifiers)) {
                            flags |= 0x10000;
                        }
                        if (Flags.isAnnnotationDefault((int)modifiers)) {
                            flags |= 0x20000;
                        }
                    }
                    if (member.getElementType() == 7 && JavaModelUtil.hasMainMethod((IType)((IType)member))) {
                        flags |= 0x10;
                    }
                    if (member.getElementType() == 8) {
                        if (Flags.isVolatile((int)modifiers)) {
                            flags |= 0x800;
                        }
                        if (Flags.isTransient((int)modifiers)) {
                            flags |= 0x1000;
                        }
                    }
                } else if (element instanceof ILocalVariable && Flags.isFinal((int)((ILocalVariable)element).getFlags())) {
                    flags |= 2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return flags;
    }

    private static boolean confirmAbstract(IMember element) throws JavaModelException {
        if (element.getElementType() == 7) {
            return !JavaModelUtil.isInterfaceOrAnnotation((IType)((IType)element));
        }
        return true;
    }

    private static boolean isInterfaceOrAnnotationField(IMember element) throws JavaModelException {
        if (element.getElementType() == 8) {
            return JavaModelUtil.isInterfaceOrAnnotation((IType)element.getDeclaringType());
        }
        return false;
    }

    private static boolean isEnumConstant(IMember element, int modifiers) {
        if (element.getElementType() == 8) {
            return Flags.isEnum((int)modifiers);
        }
        return false;
    }

    public static ImageDescriptor getMethodImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags)) {
            return JavaPluginImages.DESC_MISC_PUBLIC;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_MISC_PROTECTED;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_MISC_PRIVATE;
        }
        if (isInInterfaceOrAnnotation) {
            return JavaPluginImages.DESC_MISC_PUBLIC;
        }
        return JavaPluginImages.DESC_MISC_DEFAULT;
    }

    public static ImageDescriptor getFieldImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation || Flags.isEnum((int)flags)) {
            return JavaPluginImages.DESC_FIELD_PUBLIC;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_FIELD_PROTECTED;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_FIELD_PRIVATE;
        }
        return JavaPluginImages.DESC_FIELD_DEFAULT;
    }

    public static ImageDescriptor getTypeImageDescriptor(boolean isInner, boolean isInInterfaceOrAnnotation, int flags, boolean useLightIcons) {
        if (Flags.isEnum((int)flags)) {
            if (useLightIcons) {
                return JavaPluginImages.DESC_OBJS_ENUM_ALT;
            }
            if (isInner) {
                return JavaElementImageProvider.getInnerEnumImageDescriptor(isInInterfaceOrAnnotation, flags);
            }
            return JavaElementImageProvider.getEnumImageDescriptor(flags);
        }
        if (Flags.isAnnotation((int)flags)) {
            if (useLightIcons) {
                return JavaPluginImages.DESC_OBJS_ANNOTATION_ALT;
            }
            if (isInner) {
                return JavaElementImageProvider.getInnerAnnotationImageDescriptor(isInInterfaceOrAnnotation, flags);
            }
            return JavaElementImageProvider.getAnnotationImageDescriptor(flags);
        }
        if (Flags.isInterface((int)flags)) {
            if (useLightIcons) {
                return JavaPluginImages.DESC_OBJS_INTERFACEALT;
            }
            if (isInner) {
                return JavaElementImageProvider.getInnerInterfaceImageDescriptor(isInInterfaceOrAnnotation, flags);
            }
            return JavaElementImageProvider.getInterfaceImageDescriptor(flags);
        }
        if (useLightIcons) {
            return JavaPluginImages.DESC_OBJS_CLASSALT;
        }
        if (isInner) {
            return JavaElementImageProvider.getInnerClassImageDescriptor(isInInterfaceOrAnnotation, flags);
        }
        return JavaElementImageProvider.getClassImageDescriptor(flags);
    }

    public static Image getDecoratedImage(ImageDescriptor baseImage, int adornments, Point size) {
        return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(baseImage, adornments, size));
    }

    private static ImageDescriptor getClassImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_CLASS;
        }
        return JavaPluginImages.DESC_OBJS_CLASS_DEFAULT;
    }

    private static ImageDescriptor getInnerClassImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PUBLIC;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PRIVATE;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_INNER_CLASS_DEFAULT;
    }

    private static ImageDescriptor getEnumImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_ENUM;
        }
        return JavaPluginImages.DESC_OBJS_ENUM_DEFAULT;
    }

    private static ImageDescriptor getInnerEnumImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaPluginImages.DESC_OBJS_ENUM;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_ENUM_PRIVATE;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_OBJS_ENUM_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_ENUM_DEFAULT;
    }

    private static ImageDescriptor getAnnotationImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_ANNOTATION;
        }
        return JavaPluginImages.DESC_OBJS_ANNOTATION_DEFAULT;
    }

    private static ImageDescriptor getInnerAnnotationImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaPluginImages.DESC_OBJS_ANNOTATION;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_ANNOTATION_PRIVATE;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_OBJS_ANNOTATION_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_ANNOTATION_DEFAULT;
    }

    private static ImageDescriptor getInterfaceImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INTERFACE;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE_DEFAULT;
    }

    private static ImageDescriptor getInnerInterfaceImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PUBLIC;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PRIVATE;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE_DEFAULT;
    }
}

