/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathAttributeConfigurationDescriptors;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ModuleDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ModuleEncapsulationDetail;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.RootCPListElement;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.wizards.ClasspathAttributeConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class BuildPathBasePage {
    private final ClasspathAttributeConfigurationDescriptors fAttributeDescriptors = JavaPlugin.getDefault().getClasspathAttributeConfigurationDescriptors();

    protected boolean editCustomAttribute(Shell shell, CPListElementAttribute elem) {
        IClasspathAttribute result;
        ClasspathAttributeConfiguration config = this.fAttributeDescriptors.get(elem.getKey());
        if (config != null && (result = config.performEdit(shell, elem.getClasspathAttributeAccess())) != null) {
            elem.setValue(result.getValue());
            return true;
        }
        return false;
    }

    protected boolean showModuleDialog(Shell shell, CPListElementAttribute elem) {
        int res;
        ModuleDialog dialog;
        CPListElement selElement = elem.getParent();
        IJavaElement[] selectedJavaElements = ModuleEncapsulationDetail.getTargetJavaElements(selElement.getJavaProject(), selElement.getPath());
        if (selectedJavaElements == null) {
            dialog = new MessageDialog(shell, NewWizardMessages.BuildPathBasePage_notAddedQuestion_title, null, Messages.format(NewWizardMessages.BuildPathBasePage_notAddedQuestion_description, selElement.getPath().toString()), 3, 0, new String[]{NewWizardMessages.BuildPathBasePage_addNow_button, NewWizardMessages.BuildPathBasePage_proceedWithoutAdding_button, NewWizardMessages.BuildPathBasePage_cancel_button});
            int answer = dialog.open();
            switch (answer) {
                case 0: {
                    try {
                        selectedJavaElements = this.persistEntry(selElement);
                        break;
                    }
                    catch (InvocationTargetException e) {
                        ExceptionHandler.handle(e, shell, PreferencesMessages.BuildPathsPropertyPage_error_title, PreferencesMessages.BuildPathsPropertyPage_error_message);
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        return false;
                    }
                }
                case 1: {
                    break;
                }
                case -1: 
                case 2: {
                    return false;
                }
                default: {
                    throw new IllegalStateException(Messages.format(NewWizardMessages.BuildPathBasePage_unexpectedAnswer_error, String.valueOf(answer)));
                }
            }
        }
        if ((res = (dialog = new ModuleDialog(shell, selElement, selectedJavaElements)).open()) == 0) {
            ModuleEncapsulationDetail[] newDetails = dialog.getAllDetails();
            elem.setValue(newDetails);
            return true;
        }
        return false;
    }

    private IJavaElement[] persistEntry(CPListElement element) throws InterruptedException, InvocationTargetException {
        final IJavaProject javaProject = element.getJavaProject();
        final IClasspathEntry newEntry = element.getClasspathEntry();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IClasspathEntry[] oldClasspath = javaProject.getRawClasspath();
                int nEntries = oldClasspath.length;
                IClasspathEntry[] newEntries = Arrays.copyOf(oldClasspath, nEntries + 1);
                newEntries[nEntries] = newEntry;
                javaProject.setRawClasspath(newEntries, monitor);
            }
        };
        PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(runnable));
        IJavaElement[] selectedJavaElements = ModuleEncapsulationDetail.getTargetJavaElements(element.getJavaProject(), element.getPath());
        return selectedJavaElements;
    }

    protected boolean removeCustomAttribute(CPListElementAttribute elem) {
        IClasspathAttribute result;
        ClasspathAttributeConfiguration config = this.fAttributeDescriptors.get(elem.getKey());
        if (config != null && (result = config.performRemove(elem.getClasspathAttributeAccess())) != null) {
            elem.setValue(result.getValue());
            return true;
        }
        return false;
    }

    protected void removeEncapsulationDetail(ModuleEncapsulationDetail detail) {
        Object value;
        CPListElementAttribute parent = detail.getParent();
        if (parent != null && (value = parent.getValue()) instanceof ModuleEncapsulationDetail[]) {
            ModuleEncapsulationDetail[] existingDetails = (ModuleEncapsulationDetail[])value;
            int count = 0;
            int j = 0;
            while (j < existingDetails.length) {
                ModuleEncapsulationDetail aDetail = existingDetails[j];
                if (aDetail != detail) {
                    existingDetails[count++] = aDetail;
                }
                ++j;
            }
            if (count < existingDetails.length) {
                ModuleEncapsulationDetail[] newDetails = new ModuleEncapsulationDetail[count];
                System.arraycopy(existingDetails, 0, newDetails, 0, count);
                parent.setValue(newDetails);
                parent.getParent().attributeChanged("module");
            }
        }
    }

    protected boolean canEditCustomAttribute(CPListElementAttribute elem) {
        ClasspathAttributeConfiguration config = this.fAttributeDescriptors.get(elem.getKey());
        if (config != null) {
            return config.canEdit(elem.getClasspathAttributeAccess());
        }
        return false;
    }

    protected boolean canRemoveCustomAttribute(CPListElementAttribute elem) {
        ClasspathAttributeConfiguration config = this.fAttributeDescriptors.get(elem.getKey());
        if (config != null) {
            return config.canRemove(elem.getClasspathAttributeAccess());
        }
        return false;
    }

    public abstract List<?> getSelection();

    public abstract void setSelection(List<?> var1, boolean var2);

    public void addElement(CPListElement element) {
    }

    public abstract boolean isEntryKind(int var1);

    protected void filterAndSetSelection(List<?> list) {
        ArrayList res = new ArrayList(list.size());
        int i = list.size() - 1;
        while (i >= 0) {
            CPListElement elem;
            Object curr = list.get(i);
            if (curr instanceof CPListElement && (elem = (CPListElement)curr).getParentContainer() == null && this.isEntryKind(elem.getEntryKind())) {
                res.add(curr);
            }
            --i;
        }
        this.setSelection(res, false);
    }

    public static void fixNestingConflicts(CPListElement[] newEntries, CPListElement[] existing, Set<CPListElement> modifiedSourceEntries) {
        int i = 0;
        while (i < newEntries.length) {
            BuildPathBasePage.addExclusionPatterns(newEntries[i], existing, modifiedSourceEntries);
            ++i;
        }
    }

    private static void addExclusionPatterns(CPListElement newEntry, CPListElement[] existing, Set<CPListElement> modifiedEntries) {
        IPath entryPath = newEntry.getPath();
        int i = 0;
        while (i < existing.length) {
            IPath currPath;
            CPListElement curr = existing[i];
            if (curr.getEntryKind() == 3 && !(currPath = curr.getPath()).equals((Object)entryPath)) {
                if (currPath.isPrefixOf(entryPath)) {
                    if (BuildPathBasePage.addToExclusions(entryPath, curr)) {
                        modifiedEntries.add(curr);
                    }
                } else if (entryPath.isPrefixOf(currPath) && newEntry.getEntryKind() == 3 && BuildPathBasePage.addToExclusions(currPath, newEntry)) {
                    modifiedEntries.add(curr);
                }
            }
            ++i;
        }
    }

    private static boolean addToExclusions(IPath entryPath, CPListElement curr) {
        IPath[] exclusionFilters = (IPath[])curr.getAttribute("exclusion");
        if (!JavaModelUtil.isExcludedPath((IPath)entryPath, (IPath[])exclusionFilters)) {
            IPath pathToExclude = entryPath.removeFirstSegments(curr.getPath().segmentCount()).addTrailingSeparator();
            IPath[] newExclusionFilters = new IPath[exclusionFilters.length + 1];
            System.arraycopy(exclusionFilters, 0, newExclusionFilters, 0, exclusionFilters.length);
            newExclusionFilters[exclusionFilters.length] = pathToExclude;
            curr.setAttribute("exclusion", newExclusionFilters);
            return true;
        }
        return false;
    }

    protected boolean containsOnlyTopLevelEntries(List<?> selElements) {
        if (selElements.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElement) {
                if (((CPListElement)elem).getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public abstract void init(IJavaProject var1);

    public abstract Control getControl(Composite var1);

    public abstract void setFocus();

    protected void moveCPElementAcrossNode(TreeListDialogField<CPListElement> listField, CPListElement selElement, RootCPListElement.RootNodeChange changeNodeDirection) {
        List<CPListElement> elements = listField.getElements();
        for (CPListElement cpListElement : elements) {
            RootCPListElement rootElement;
            if (!cpListElement.isRootNodeForPath() || !(rootElement = (RootCPListElement)cpListElement).isSourceRootNode(changeNodeDirection) || !rootElement.getChildren().contains(selElement)) continue;
            rootElement.removeCPListElement(selElement);
            listField.getTreeViewer().remove((Object)selElement);
            listField.dialogFieldChanged();
        }
        for (CPListElement cpListElement : elements) {
            RootCPListElement rootCPListElement;
            if (!cpListElement.isRootNodeForPath() || !(rootCPListElement = (RootCPListElement)cpListElement).isTargetRootNode(changeNodeDirection)) continue;
            if (rootCPListElement.getChildren().contains(selElement)) break;
            rootCPListElement.addCPListElement(selElement);
            List<CPListElement> all = listField.getElements();
            listField.removeAllElements();
            listField.setElements(all);
            listField.refresh();
            listField.getTreeViewer().expandToLevel(2);
            listField.postSetSelection((ISelection)new StructuredSelection((Object)selElement));
            break;
        }
    }

    protected abstract class CPListAdapter
    implements IDialogFieldListener,
    ITreeListAdapter<CPListElement> {
        private final Object[] EMPTY_ARR = new Object[0];

        protected CPListAdapter() {
        }

        @Override
        public Object[] getChildren(TreeListDialogField<CPListElement> field, Object element) {
            CPListElementAttribute attribute;
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren(false);
            }
            if (element instanceof CPListElementAttribute && "module".equals((attribute = (CPListElementAttribute)element).getKey())) {
                return (ModuleEncapsulationDetail[])attribute.getValue();
            }
            return this.EMPTY_ARR;
        }

        @Override
        public Object getParent(TreeListDialogField<CPListElement> field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            return null;
        }

        @Override
        public boolean hasChildren(TreeListDialogField<CPListElement> field, Object element) {
            Object[] children = this.getChildren(field, element);
            return children != null && children.length > 0;
        }
    }
}

