/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.viewpoint;

import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ViewpointSelectionCallbackWithConfimation
extends ViewpointSelectionCallback {
    @Override
    public void deselectViewpoint(Viewpoint deselectedViewpoint, Session session, IProgressMonitor monitor) {
        IEditingSession editingSession = SessionUIManager.INSTANCE.getUISession(session);
        Collection<Object> openedEditors = Sets.newHashSet();
        if (editingSession != null) {
            openedEditors = this.getConcernedEditors(deselectedViewpoint, editingSession.getEditors());
        }
        if (editingSession == null || openedEditors.isEmpty() || this.userConfirmsDeselection(deselectedViewpoint, openedEditors)) {
            for (IEditorPart iEditorPart : openedEditors) {
                DialectUIManager.INSTANCE.closeEditor(iEditorPart, false);
            }
            super.deselectViewpoint(deselectedViewpoint, session, monitor);
        }
    }

    private boolean userConfirmsDeselection(Viewpoint deselectedViewpoint, Collection<IEditorPart> openedEditors) {
        StringBuilder builder = new StringBuilder();
        for (IEditorPart iEditorPart : openedEditors) {
            builder.append(iEditorPart.getTitle());
            builder.append(",\n");
        }
        final String message = MessageFormat.format(Messages.ViewpointSelectionCallbackWithConfimation_viewpointUsedInOpenEditors_message, new IdentifiedElementQuery((IdentifiedElement)deselectedViewpoint).getLabel(), builder);
        final AtomicBoolean confirmation = new AtomicBoolean(false);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                confirmation.set(MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ViewpointSelectionCallbackWithConfimation_viewpointUsedInOpenEditors_title, (String)message));
            }
        });
        return confirmation.get();
    }

    private Collection<IEditorPart> getConcernedEditors(Viewpoint viewpoint, Collection<? extends IEditorPart> editors) {
        HashSet result = Sets.newHashSet();
        for (RepresentationDescription representationDescription : new ViewpointQuery(viewpoint).getAllRepresentationDescriptions()) {
            for (IEditorPart iEditorPart : editors) {
                if (!DialectUIManager.INSTANCE.isRepresentationDescriptionManagedByEditor(representationDescription, iEditorPart)) continue;
                result.add(iEditorPart);
            }
        }
        return result;
    }
}

