/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.internal.descriptors;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.emf.type.core.ElementType;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeFactory;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePluginStatusCodes;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.ContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.EditHelperAdviceDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.ElementTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.IEditHelperAdviceDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.MetamodelDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.XMLExpressionMatcher;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;

public class SpecializationTypeDescriptor
extends ElementTypeDescriptor
implements ISpecializationTypeDescriptor {
    private String matcherClassName;
    private IElementMatcher matcher;
    private IConfigurationElement matcherConfig;
    private String[] specializedTypeIds;
    private IElementType[] specializedTypes;
    private IContainerDescriptor containerDescriptor;
    private IEditHelperAdviceDescriptor editHelperAdviceDescriptor;
    private IEditHelperAdvice editHelperAdvice;
    private ISpecializationType specializationType;
    private String editHelperAdviceName;

    public SpecializationTypeDescriptor(ISpecializationType specializationType) {
        super(specializationType);
        this.containerDescriptor = specializationType.getEContainerDescriptor();
        this.editHelperAdvice = specializationType.getEditHelperAdvice();
        this.editHelperAdviceDescriptor = new EditHelperAdviceDescriptor(this.editHelperAdvice, this);
        this.matcher = specializationType.getMatcher();
        this.specializationType = specializationType;
        this.specializedTypeIds = specializationType.getSpecializedTypeIds();
        this.specializedTypes = specializationType.getSpecializedTypes();
    }

    public SpecializationTypeDescriptor(IConfigurationElement configElement, MetamodelDescriptor metamodelDescriptor) throws CoreException {
        super(configElement);
        IConfigurationElement[] matcherConfigs;
        IConfigurationElement[] enablementConfigs;
        this.editHelperAdviceName = configElement.getAttribute("edithelperadvice");
        this.editHelperAdviceDescriptor = new EditHelperAdviceDescriptor(this.editHelperAdviceName, this);
        ArrayList<String> specializes = new ArrayList<String>();
        IConfigurationElement[] specializesConfigs = configElement.getChildren("specializes");
        int i = 0;
        while (i < specializesConfigs.length) {
            IConfigurationElement nextSpecializesConfig = specializesConfigs[i];
            String specializedId = nextSpecializesConfig.getAttribute("id");
            if (specializedId == null) {
                throw EMFTypePluginStatusCodes.getTypeInitException(this.getId(), EMFTypeCoreMessages.type_reason_no_specialized_id_WARN_, null);
            }
            specializes.add(specializedId);
            ++i;
        }
        this.specializedTypeIds = specializes.toArray(new String[0]);
        if (this.specializedTypeIds.length < 1) {
            throw EMFTypePluginStatusCodes.getTypeInitException(this.getId(), EMFTypeCoreMessages.type_reason_no_specialized_WARN_, null);
        }
        IConfigurationElement[] containerConfigs = configElement.getChildren("eContainer");
        if (containerConfigs.length > 0) {
            this.containerDescriptor = new ContainerDescriptor(containerConfigs[0], metamodelDescriptor, this.getId());
        }
        if ((enablementConfigs = configElement.getChildren("enablement")).length > 0) {
            this.matcher = new XMLExpressionMatcher(enablementConfigs[0], this.getId());
        }
        if (this.matcher == null && (matcherConfigs = configElement.getChildren("matcher")).length > 0) {
            this.matcherClassName = matcherConfigs[0].getAttribute("class");
            if (this.matcherClassName == null) {
                throw EMFTypePluginStatusCodes.getInitException(this.getId(), EMFTypeCoreMessages.element_reason_matcher_no_class_WARN_, null);
            }
            this.matcherConfig = matcherConfigs[0];
        }
    }

    public IElementType getElementType() {
        IElementTypeFactory factory;
        if (this.specializationType == null && this.getKindName() != null && this.getKindName().length() > 0 && (factory = ElementTypeRegistry.getInstance().getElementTypeFactory(this.getKindName())) != null) {
            this.specializationType = factory.createSpecializationType(this);
        }
        return this.specializationType;
    }

    public String[] getSpecializationTypeIds() {
        return this.specializedTypeIds;
    }

    public IConfigurationElement getMatcherConfiguration() {
        return this.matcherConfig;
    }

    public IContainerDescriptor getContainerDescriptor() {
        return this.containerDescriptor;
    }

    public IEditHelperAdviceDescriptor getEditHelperAdviceDescriptor() {
        return this.editHelperAdviceDescriptor;
    }

    public IElementType[] getSpecializedTypes() {
        if (this.specializedTypes == null) {
            this.specializedTypes = new ElementType[this.specializedTypeIds.length];
            int i = 0;
            while (i < this.specializedTypeIds.length) {
                this.specializedTypes[i] = ElementTypeRegistry.getInstance().getType(this.specializedTypeIds[i]);
                ++i;
            }
        }
        return this.specializedTypes;
    }

    public IElementMatcher getMatcher() {
        if (this.matcher == null && this.matcherClassName != null && this.matcherConfig != null) {
            try {
                this.matcher = (IElementMatcher)this.matcherConfig.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)21, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.matcher_class_not_found_ERROR_, (Object)this.matcherClassName), (Throwable)e);
                this.matcherClassName = null;
            }
        }
        return this.matcher;
    }

    public IEditHelperAdvice getEditHelperAdvice() {
        if (this.editHelperAdvice == null && this.getEditHelperAdviceDescriptor() != null) {
            this.editHelperAdvice = this.getEditHelperAdviceDescriptor().getEditHelperAdvice();
        }
        return this.editHelperAdvice;
    }

    public URL getIconURL() {
        if (super.getIconURL() == null && this.getSpecializedTypes().length > 0) {
            return this.getSpecializedTypes()[0].getIconURL();
        }
        return super.getIconURL();
    }

    public String toString() {
        return "SpecializationTypeDescriptor[" + this.getId() + "]";
    }
}

