/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.api.widgets;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.eef.EEFDynamicMappingFor;
import org.eclipse.eef.EEFDynamicMappingIf;
import org.eclipse.eef.EEFGroupDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.LockStatusChangeEvent;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.EEFStyleHelper;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.Messages;
import org.eclipse.eef.ide.ui.internal.widgets.EEFStyledTextStyleCallback;
import org.eclipse.eef.ide.ui.internal.widgets.styles.EEFColor;
import org.eclipse.eef.ide.ui.internal.widgets.styles.EEFFont;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractEEFWidgetLifecycleManager
extends AbstractEEFLifecycleManager {
    protected static final int VALIDATION_MARKER_OFFSET = 5;
    protected IVariableManager variableManager;
    protected IInterpreter interpreter;
    protected EditingContextAdapter editingContextAdapter;
    protected StyledText label;
    protected CLabel help;
    private MouseTrackListener mouseTrackListener;
    private Consumer<Collection<LockStatusChangeEvent>> lockStatusChangedListener;
    private ControlDecoration controlDecoration;

    public AbstractEEFWidgetLifecycleManager(IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        this.variableManager = variableManager;
        this.interpreter = interpreter;
        this.editingContextAdapter = editingContextAdapter;
    }

    @Override
    public void createControl(Composite parent, IEEFFormContainer formContainer) {
        boolean needsHelp;
        super.createControl(parent, formContainer);
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        Composite composite = parent;
        boolean isInGroup = this.isInGroup();
        boolean needsSeparatedLabel = this.needSeparatedLabel();
        boolean isBlankLabel = Util.isBlank((String)this.getWidgetDescription().getLabelExpression());
        boolean needsLabel = isInGroup || !isBlankLabel && needsSeparatedLabel;
        boolean bl = needsHelp = isInGroup || !Util.isBlank((String)this.getWidgetDescription().getHelpExpression());
        if (!isInGroup && (needsLabel || needsHelp)) {
            composite = widgetFactory.createComposite(parent);
            int numColumn = 1;
            if (needsLabel) {
                ++numColumn;
            }
            if (needsHelp) {
                ++numColumn;
            }
            GridLayout layout = new GridLayout(numColumn, false);
            composite.setLayout((Layout)layout);
            GridData layoutData = new GridData(768);
            layoutData.horizontalSpan = 1;
            composite.setLayoutData((Object)layoutData);
        }
        if (needsLabel) {
            this.label = widgetFactory.createStyledText(composite, 8);
            this.label.setEditable(false);
            this.label.setCaret(null);
            this.label.setCursor(Display.getCurrent().getSystemCursor(0));
            this.label.setDoubleClickEnabled(false);
            this.label.setLayoutData((Object)new GridData(this.getLabelVerticalAlignment()));
        }
        if (needsHelp) {
            this.help = widgetFactory.createCLabel(composite, "");
            if (!Util.isBlank((String)this.getWidgetDescription().getHelpExpression())) {
                this.help.setImage(EEFIdeUiPlugin.getPlugin().getImageRegistry().get("icons/full/help.gif"));
                this.help.setLayoutData((Object)new GridData(this.getLabelVerticalAlignment()));
                this.help.setToolTipText("");
            }
        }
        this.createMainControl(composite, formContainer);
        this.controlDecoration = new ControlDecoration(this.getValidationControl(), 16512);
        this.checkLockStatus();
    }

    private void checkLockStatus() {
        Object self = this.variableManager.getVariables().get("self");
        if (self instanceof EObject) {
            LockStatusChangeEvent.LockStatus status = this.editingContextAdapter.getLockStatus((EObject)self);
            this.handleLockStatus(status);
        }
    }

    private boolean isInGroup() {
        EObject eContainer = this.getWidgetDescription().eContainer();
        if (eContainer instanceof EEFDynamicMappingIf && eContainer.eContainer() instanceof EEFDynamicMappingFor) {
            EEFDynamicMappingFor dynamicMappingFor = (EEFDynamicMappingFor)eContainer.eContainer();
            return dynamicMappingFor.eContainer() instanceof EEFGroupDescription;
        }
        return eContainer instanceof EEFGroupDescription;
    }

    protected boolean needSeparatedLabel() {
        return true;
    }

    protected int getLabelVerticalAlignment() {
        return 2;
    }

    protected abstract IEEFWidgetController getController();

    protected abstract EEFWidgetDescription getWidgetDescription();

    protected abstract void createMainControl(Composite var1, IEEFFormContainer var2);

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.getController().onNewLabel(value -> {
            if (!(this.label.isDisposed() || this.label.getText() != null && this.label.getText().equals(value))) {
                this.label.setText(Optional.ofNullable(value).orElse(""));
            }
            this.setLabelFontStyle();
        });
        this.getController().onNewHelp(value -> {
            if (!(this.help == null || this.help.isDisposed() || this.help.getText() != null && this.help.getText().equals(value))) {
                this.help.setToolTipText(Optional.ofNullable(value).orElse(Messages.AbstractEEFWidgetLifecycleManager_noDescriptionAvailable));
            }
        });
        if (this.help != null) {
            this.mouseTrackListener = new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                    AbstractEEFWidgetLifecycleManager.this.getController().computeHelp();
                }

                public void mouseExit(MouseEvent e) {
                }

                public void mouseEnter(MouseEvent e) {
                }
            };
            this.help.addMouseTrackListener(this.mouseTrackListener);
        }
        this.lockStatusChangedListener = events -> Display.getDefault().asyncExec(() -> events.stream().filter(event -> this.getWidgetSemanticElement().equals(event.getElement())).forEach(event -> this.handleLockStatus(event.getStatus())));
        this.editingContextAdapter.addLockStatusChangedListener(this.lockStatusChangedListener);
    }

    private void handleLockStatus(LockStatusChangeEvent.LockStatus status) {
        if (status != null) {
            switch (status) {
                case LOCKED_BY_ME: {
                    this.lockedByMe();
                    break;
                }
                case LOCKED_BY_OTHER: {
                    this.lockedByOther();
                    break;
                }
                case LOCKED_PERMISSION: {
                    this.lockedNoWrite();
                    break;
                }
                case UNLOCKED: {
                    this.unlocked();
                    break;
                }
                default: {
                    this.unlocked();
                }
            }
        }
    }

    protected Object getWidgetSemanticElement() {
        return this.variableManager.getVariables().get("self");
    }

    protected void lockedByMe() {
        if (this.controlDecoration.getControl() != null) {
            this.controlDecoration.hide();
            this.controlDecoration.setDescriptionText(Messages.AbstractEEFWidgetLifecycleManager_lockedByMe);
            this.controlDecoration.setImage(EEFIdeUiPlugin.getPlugin().getImageRegistry().get("icons/full/permission_granted_to_current_user_exclusively.gif"));
            this.controlDecoration.show();
        }
    }

    protected void lockedByOther() {
        this.setEnabled(false);
        if (this.controlDecoration.getControl() != null) {
            this.controlDecoration.hide();
            this.controlDecoration.setDescriptionText(Messages.AbstractEEFWidgetLifecycleManager_lockedByOther);
            this.controlDecoration.setImage(EEFIdeUiPlugin.getPlugin().getImageRegistry().get("icons/full/permission_denied.gif"));
            this.controlDecoration.show();
        }
    }

    protected void lockedNoWrite() {
        this.setEnabled(false);
        if (this.controlDecoration.getControl() != null) {
            this.controlDecoration.hide();
            this.controlDecoration.setDescriptionText(Messages.AbstractEEFWidgetLifecycleManager_lockedNoWrite);
            this.controlDecoration.setImage(EEFIdeUiPlugin.getPlugin().getImageRegistry().get("icons/full/permission_no_write.gif"));
            this.controlDecoration.show();
        }
    }

    protected void unlocked() {
        this.setEnabled(this.isEnabled());
        if (this.controlDecoration.getControl() != null) {
            this.controlDecoration.hide();
        }
    }

    protected abstract void setEnabled(boolean var1);

    protected boolean isEnabled() {
        Boolean result = (Boolean)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).logIfInvalidType(Boolean.class).defaultValue((Object)Boolean.TRUE).evaluate(this.getWidgetDescription().getIsEnabledExpression());
        return result;
    }

    protected void setLabelFontStyle() {
        EEFStyleHelper styleHelper = this.getEEFStyleHelper();
        EEFWidgetStyle style = styleHelper.getWidgetStyle(this.getWidgetDescription());
        EEFStyledTextStyleCallback callback = new EEFStyledTextStyleCallback(this.label);
        if (style != null) {
            styleHelper.applyTextStyle(style.getLabelFontNameExpression(), style.getLabelFontSizeExpression(), style.getLabelFontStyleExpression(), this.label.getFont(), style.getLabelBackgroundColorExpression(), style.getLabelForegroundColorExpression(), callback);
        } else {
            callback.applyForegroundColor(new EEFColor(null));
            callback.applyBackgroundColor(new EEFColor(null));
            callback.applyFontStyle(false, false);
            callback.applyFont(new EEFFont(null, 0, 0){

                @Override
                public Font getFont() {
                    return null;
                }
            });
        }
    }

    protected EEFStyleHelper getEEFStyleHelper() {
        return new EEFStyleHelper(this.interpreter, this.variableManager);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.checkLockStatus();
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.help != null && !this.help.isDisposed()) {
            this.help.removeMouseTrackListener(this.mouseTrackListener);
        }
        this.getController().removeNewLabelConsumer();
        this.editingContextAdapter.removeLockStatusChangedListener(this.lockStatusChangedListener);
    }

    @Override
    public void dispose() {
        EEFIdeUiPlugin.getPlugin().debug("AbstractEEFWidgetLifeCycleManager#dispose()");
    }

    protected IStructuredSelection getStructuredSelection(StructuredViewer viewer) throws ClassCastException {
        ISelection selection = viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        throw new ClassCastException(Messages.AbstractEEFWidgetLifecycleManager_invalidSelectionType);
    }
}

