/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DescriptionCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.NoteFigure;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.business.internal.view.ShowingViewUtil;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.OpenDRepresentationEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.SnapToAllDragEditPartsTracker;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class SiriusNoteEditPart
extends NoteEditPart {
    public SiriusNoteEditPart(View view) {
        super(view);
    }

    public DragTracker getDragTracker(Request request) {
        return new SnapToAllDragEditPartsTracker((EditPart)this);
    }

    protected void performDirectEditRequest(Request request) {
        Iterable descriptionCompartmentEditPartsfilter = Iterables.filter((Iterable)this.getChildren(), DescriptionCompartmentEditPart.class);
        if (Iterables.size((Iterable)descriptionCompartmentEditPartsfilter) == 1) {
            DescriptionCompartmentEditPart descriptionCompartmentEditPart = (DescriptionCompartmentEditPart)Iterables.getOnlyElement((Iterable)descriptionCompartmentEditPartsfilter);
            descriptionCompartmentEditPart.performRequest(request);
        }
    }

    protected List getModelChildren() {
        return ShowingViewUtil.getModelChildren(this.getModel());
    }

    protected void addNotationalListeners() {
        DRepresentationDescriptor linkedDescriptor;
        ViewQuery viewQuery;
        Optional<DDiagram> diagram;
        super.addNotationalListeners();
        if (this.hasNotationView() && (diagram = (viewQuery = new ViewQuery((View)this.getModel())).getDDiagram()).isPresent()) {
            this.addListenerFilter("ShowingMode", (NotificationListener)this, (EObject)diagram.get(), (EStructuralFeature)DiagramPackage.eINSTANCE.getDDiagram_IsInShowingMode());
        }
        if (this.isRepresentationLink() && !this.isRepresentationLinkBroken() && (linkedDescriptor = (DRepresentationDescriptor)this.getNotationView().getElement()) != null) {
            this.addListenerFilter("DiagramLink_RepresentationNameChange", (NotificationListener)this, (EObject)linkedDescriptor);
        }
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("ShowingMode");
        this.removeListenerFilter("DiagramLink_RepresentationNameChange");
    }

    protected List getModelSourceConnections() {
        return ShowingViewUtil.getSourceConnectionsConnectingVisibleViews((View)this.getModel());
    }

    protected List getModelTargetConnections() {
        return ShowingViewUtil.getTargetConnectionsConnectingVisibleViews((View)this.getModel());
    }

    protected void setConnectionsVisibility(boolean visibility) {
        ShowingViewUtil.setConnectionsVisibility((AbstractGraphicalEditPart)this, (View)this.getModel(), 0, visibility);
    }

    protected NodeFigure createNodeFigure() {
        View notationView;
        super.createNodeFigure();
        IMapMode mm = this.getMapMode();
        int insetSize = mm.DPtoLP(5);
        Insets insets = new Insets(insetSize, insetSize, insetSize, mm.DPtoLP(14));
        NoteFigure noteFigure = new NoteFigure(mm.DPtoLP(100), mm.DPtoLP(56), insets){

            public void paint(Graphics graphics) {
                ShowingViewUtil.initGraphicsForVisibleAndInvisibleElements((IFigure)this, graphics, (View)SiriusNoteEditPart.this.getModel());
                try {
                    super.paint(graphics);
                    graphics.restoreState();
                }
                finally {
                    graphics.popState();
                }
            }
        };
        Object model = this.getModel();
        if (model != null && model instanceof View && (notationView = (View)model) != null && (notationView.getEAnnotation("DiagramLink") != null || notationView.getType() == null || notationView.getType().length() == 0)) {
            noteFigure.setDiagramLinkMode(true);
            insets.right = insetSize;
            noteFigure.setDefaultSize(insetSize, insetSize);
        }
        return noteFigure;
    }

    protected void setVisibility(boolean vis) {
        ShowingViewUtil.setVisibility((AbstractGraphicalEditPart)this, vis, 0, this.getFlag(8));
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        if (notification.getNotifier() == this.getNotationView().getElement() && notification.getFeature() == ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__NAME) {
            this.refreshDiagramNameCompartmentEditPart();
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        if (this.isRepresentationLink()) {
            this.removeEditPolicy("OpenPolicy");
            this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenDRepresentationEditPolicy());
        }
    }

    public boolean isRepresentationLink() {
        boolean result = false;
        View view = this.getNotationView();
        if (view != null) {
            ViewQuery query = new ViewQuery(view);
            result = query.isRepresentationLink();
        }
        return result;
    }

    boolean isRepresentationLinkBroken() {
        boolean result = false;
        View view = this.getNotationView();
        if (view != null) {
            ViewQuery query = new ViewQuery(view);
            result = query.isRepresentationLinkBroken();
        }
        return result;
    }

    public void refreshDiagramNameCompartmentEditPart() {
        for (Object ep : this.getChildren()) {
            IGraphicalEditPart gep = (IGraphicalEditPart)ep;
            if (gep.getNotationView() == null || !ViewType.DIAGRAM_NAME.equals(gep.getNotationView().getType())) continue;
            gep.refresh();
        }
    }
}

