/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.securestorage;

import java.io.IOException;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.StringUtils;

public class EGitSecureStore {
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String GIT_PATH_PREFIX = "/GIT/";
    private final ISecurePreferences preferences;

    public EGitSecureStore(ISecurePreferences preferences) {
        this.preferences = preferences;
    }

    public void putCredentials(URIish uri, UserPasswordCredentials credentials) throws StorageException, IOException {
        String u = credentials.getUser();
        String p = credentials.getPassword();
        if (StringUtils.isEmptyOrNull((String)u) || StringUtils.isEmptyOrNull((String)p)) {
            return;
        }
        String pathName = EGitSecureStore.calcNodePath(uri);
        ISecurePreferences node = this.preferences.node(pathName);
        node.put(PASSWORD, p, true);
        node.put(USER, u, false);
        node.flush();
    }

    public UserPasswordCredentials getCredentials(URIish uri) throws StorageException {
        String pathName = EGitSecureStore.calcNodePath(uri);
        if (!this.preferences.nodeExists(pathName)) {
            return null;
        }
        ISecurePreferences node = this.preferences.node(pathName);
        String user = node.get(USER, "");
        String password = node.get(PASSWORD, "");
        if (uri.getUser() != null && !user.equals(uri.getUser())) {
            return null;
        }
        return new UserPasswordCredentials(user, password);
    }

    static String calcNodePath(URIish uri) {
        URIish storedURI = uri.setUser(null).setPass(null);
        if (uri.getScheme() != null && !"file".equals(uri.getScheme())) {
            storedURI = storedURI.setPath(null);
            if (uri.getPort() == -1) {
                String s = uri.getScheme();
                if ("http".equals(s)) {
                    storedURI = storedURI.setPort(80);
                } else if ("https".equals(s)) {
                    storedURI = storedURI.setPort(443);
                } else if ("ssh".equals(s) || "sftp".equals(s)) {
                    storedURI = storedURI.setPort(22);
                } else if ("ftp".equals(s)) {
                    storedURI = storedURI.setPort(21);
                }
            }
        }
        String pathName = GIT_PATH_PREFIX + EncodingUtils.encodeSlashes((String)storedURI.toString());
        return pathName;
    }

    public void clearCredentials(URIish uri) throws IOException {
        String pathName = EGitSecureStore.calcNodePath(uri);
        if (!this.preferences.nodeExists(pathName)) {
            return;
        }
        ISecurePreferences node = this.preferences.node(pathName);
        node.removeNode();
        this.preferences.flush();
    }
}

