/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gpg.bc.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import org.bouncycastle.gpg.SExprParser;
import org.bouncycastle.gpg.keybox.BlobType;
import org.bouncycastle.gpg.keybox.KeyBlob;
import org.bouncycastle.gpg.keybox.KeyBox;
import org.bouncycastle.gpg.keybox.KeyInformation;
import org.bouncycastle.gpg.keybox.PublicKeyRingBlob;
import org.bouncycastle.gpg.keybox.UserID;
import org.bouncycastle.gpg.keybox.jcajce.JcaKeyBox;
import org.bouncycastle.gpg.keybox.jcajce.JcaKeyBoxBuilder;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.util.encoders.Hex;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.gpg.bc.internal.BCText;
import org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKey;
import org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKeyPassphrasePrompt;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BouncyCastleGpgKeyLocator {
    private static final Logger log = LoggerFactory.getLogger(BouncyCastleGpgKeyLocator.class);
    private static final Path GPG_DIRECTORY = BouncyCastleGpgKeyLocator.findGpgDirectory();
    private static final Path USER_KEYBOX_PATH = GPG_DIRECTORY.resolve("pubring.kbx");
    private static final Path USER_SECRET_KEY_DIR = GPG_DIRECTORY.resolve("private-keys-v1.d");
    private static final Path USER_PGP_PUBRING_FILE = GPG_DIRECTORY.resolve("pubring.gpg");
    private static final Path USER_PGP_LEGACY_SECRING_FILE = GPG_DIRECTORY.resolve("secring.gpg");
    private final String signingKey;
    private BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt;

    private static Path findGpgDirectory() {
        File home;
        String appData;
        SystemReader system = SystemReader.getInstance();
        if (system.isWindows() && (appData = system.getenv("APPDATA")) != null && !appData.isEmpty()) {
            try {
                Path directory = Paths.get(appData, new String[0]).resolve("gnupg");
                if (Files.isDirectory(directory, new LinkOption[0])) {
                    return directory;
                }
            }
            catch (SecurityException | InvalidPathException runtimeException) {
                // empty catch block
            }
        }
        if ((home = FS.DETECTED.userHome()) == null) {
            home = new File(".").getAbsoluteFile();
        }
        return home.toPath().resolve(".gnupg");
    }

    public BouncyCastleGpgKeyLocator(String signingKey, @NonNull BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt) {
        this.signingKey = signingKey;
        this.passphrasePrompt = passphrasePrompt;
    }

    private PGPSecretKey attemptParseSecretKey(Path keyFile, PGPDigestCalculatorProvider calculatorProvider, PBEProtectionRemoverFactory passphraseProvider, PGPPublicKey publicKey) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream in = Files.newInputStream(keyFile, new OpenOption[0]);){
                return new SExprParser(calculatorProvider).parseSecretKey((InputStream)new BufferedInputStream(in), passphraseProvider, publicKey);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassCastException | PGPException e) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring unreadable file '{}': {}", new Object[]{keyFile, e.getMessage(), e});
            }
            return null;
        }
    }

    static boolean containsSigningKey(String userId, String signingKeySpec) {
        if (StringUtils.isEmptyOrNull((String)userId) || StringUtils.isEmptyOrNull((String)signingKeySpec)) {
            return false;
        }
        String toMatch = signingKeySpec;
        if (toMatch.startsWith("0x") && toMatch.trim().length() > 2) {
            return false;
        }
        char command = toMatch.charAt(0);
        switch (command) {
            case '*': 
            case '<': 
            case '=': 
            case '@': {
                toMatch = toMatch.substring(1);
                if (!toMatch.isEmpty()) break;
                return false;
            }
        }
        switch (command) {
            case '=': {
                return userId.equals(toMatch);
            }
            case '<': {
                int begin = userId.indexOf(60);
                int end = userId.indexOf(62, begin + 1);
                int stop = toMatch.indexOf(62);
                return begin >= 0 && end > begin + 1 && stop > 0 && userId.substring(begin + 1, end).equals(toMatch.substring(0, stop));
            }
            case '@': {
                int begin = userId.indexOf(60);
                int end = userId.indexOf(62, begin + 1);
                return begin >= 0 && end > begin + 1 && userId.substring(begin + 1, end).contains(toMatch);
            }
        }
        if (toMatch.trim().isEmpty()) {
            return false;
        }
        return userId.toLowerCase(Locale.ROOT).contains(toMatch.toLowerCase(Locale.ROOT));
    }

    private String toFingerprint(String keyId) {
        if (keyId.startsWith("0x")) {
            return keyId.substring(2);
        }
        return keyId;
    }

    private PGPPublicKey findPublicKeyByKeyId(KeyBlob keyBlob) throws IOException {
        String keyId = this.toFingerprint(this.signingKey).toLowerCase(Locale.ROOT);
        if (keyId.isEmpty()) {
            return null;
        }
        for (KeyInformation keyInfo : keyBlob.getKeyInformation()) {
            String fingerprint = Hex.toHexString((byte[])keyInfo.getFingerprint()).toLowerCase(Locale.ROOT);
            if (!fingerprint.endsWith(keyId)) continue;
            return this.getPublicKey(keyBlob, keyInfo.getFingerprint());
        }
        return null;
    }

    private PGPPublicKey findPublicKeyByUserId(KeyBlob keyBlob) throws IOException {
        for (UserID userID : keyBlob.getUserIds()) {
            if (!BouncyCastleGpgKeyLocator.containsSigningKey(userID.getUserIDAsString(), this.signingKey)) continue;
            return this.getSigningPublicKey(keyBlob);
        }
        return null;
    }

    private PGPPublicKey findPublicKeyInKeyBox(Path keyboxFile) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, NoOpenPgpKeyException {
        KeyBox keyBox = this.readKeyBoxFile(keyboxFile);
        boolean hasOpenPgpKey = false;
        for (KeyBlob keyBlob : keyBox.getKeyBlobs()) {
            if (keyBlob.getType() != BlobType.OPEN_PGP_BLOB) continue;
            hasOpenPgpKey = true;
            PGPPublicKey key = this.findPublicKeyByKeyId(keyBlob);
            if (key != null) {
                return key;
            }
            key = this.findPublicKeyByUserId(keyBlob);
            if (key == null) continue;
            return key;
        }
        if (!hasOpenPgpKey) {
            throw new NoOpenPgpKeyException();
        }
        return null;
    }

    @NonNull
    public BouncyCastleGpgKey findSecretKey() throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        BouncyCastleGpgKey key;
        PGPPublicKey publicKey = null;
        if (this.hasKeyFiles(USER_SECRET_KEY_DIR)) {
            block12: {
                if (Files.exists(USER_KEYBOX_PATH, new LinkOption[0])) {
                    try {
                        publicKey = this.findPublicKeyInKeyBox(USER_KEYBOX_PATH);
                        if (publicKey != null) {
                            BouncyCastleGpgKey key2 = this.findSecretKeyForKeyBoxPublicKey(publicKey, USER_KEYBOX_PATH);
                            if (key2 != null) {
                                return key2;
                            }
                            throw new PGPException(MessageFormat.format(BCText.get().gpgNoSecretKeyForPublicKey, Long.toHexString(publicKey.getKeyID())));
                        }
                        throw new PGPException(MessageFormat.format(BCText.get().gpgNoPublicKeyFound, this.signingKey));
                    }
                    catch (NoOpenPgpKeyException e) {
                        if (!log.isDebugEnabled()) break block12;
                        log.debug("{} does not contain any OpenPGP keys", (Object)USER_KEYBOX_PATH);
                    }
                }
            }
            if (Files.exists(USER_PGP_PUBRING_FILE, new LinkOption[0]) && (publicKey = this.findPublicKeyInPubring(USER_PGP_PUBRING_FILE)) != null && (key = this.findSecretKeyForKeyBoxPublicKey(publicKey, USER_PGP_PUBRING_FILE)) != null) {
                return key;
            }
            if (publicKey == null) {
                throw new PGPException(MessageFormat.format(BCText.get().gpgNoPublicKeyFound, this.signingKey));
            }
        }
        boolean hasSecring = false;
        if (Files.exists(USER_PGP_LEGACY_SECRING_FILE, new LinkOption[0])) {
            hasSecring = true;
            key = this.loadKeyFromSecring(USER_PGP_LEGACY_SECRING_FILE);
            if (key != null) {
                return key;
            }
        }
        if (publicKey != null) {
            throw new PGPException(MessageFormat.format(BCText.get().gpgNoSecretKeyForPublicKey, Long.toHexString(publicKey.getKeyID())));
        }
        if (hasSecring) {
            throw new PGPException(MessageFormat.format(BCText.get().gpgNoKeyInLegacySecring, this.signingKey));
        }
        throw new PGPException(BCText.get().gpgNoKeyring);
    }

    private boolean hasKeyFiles(Path dir) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DirectoryStream<Path> contents = Files.newDirectoryStream(dir, "*.key");){
                return contents.iterator().hasNext();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    private BouncyCastleGpgKey loadKeyFromSecring(Path secring) throws IOException, PGPException {
        PGPSecretKey secretKey = this.findSecretKeyInLegacySecring(this.signingKey, secring);
        if (secretKey != null) {
            if (!secretKey.isSigningKey()) {
                throw new PGPException(MessageFormat.format(BCText.get().gpgNotASigningKey, this.signingKey));
            }
            return new BouncyCastleGpgKey(secretKey, secring);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private BouncyCastleGpgKey findSecretKeyForKeyBoxPublicKey(PGPPublicKey publicKey, Path userKeyboxPath) throws PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private PGPSecretKey findSecretKeyInLegacySecring(String signingkey, Path secringFile) throws IOException, PGPException {
        var3_3 = null;
        var4_5 = null;
        try {
            in = Files.newInputStream(secringFile, new OpenOption[0]);
            try {
                pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)new BufferedInputStream(in)), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                keyId = this.toFingerprint(signingkey).toLowerCase(Locale.ROOT);
                keyrings = pgpSec.getKeyRings();
                while (true) {
                    keyRing = (PGPSecretKeyRing)keyrings.next();
                    keys = keyRing.getSecretKeys();
                    while (keys.hasNext()) {
                        key = (PGPSecretKey)keys.next();
                        fingerprint = Hex.toHexString((byte[])key.getPublicKey().getFingerprint()).toLowerCase(Locale.ROOT);
                        if (fingerprint.endsWith(keyId)) {
                            return key;
                        }
                        userIDs = key.getUserIDs();
                        while (userIDs.hasNext()) {
                            userId = (String)userIDs.next();
                            if (!BouncyCastleGpgKeyLocator.containsSigningKey(userId, this.signingKey)) continue;
                            return key;
                        }
                    }
                    break;
                }
            }
            finally {
                if (keyrings.hasNext()) ** continue;
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
            } else if (var3_3 != var4_6) {
                var3_3.addSuppressed(var4_6);
            }
            throw var3_3;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private PGPPublicKey findPublicKeyInPubring(Path pubringFile) throws IOException, PGPException {
        var2_2 = null;
        var3_4 = null;
        try {
            in = Files.newInputStream(pubringFile, new OpenOption[0]);
            try {
                pgpPub = new PGPPublicKeyRingCollection((InputStream)new BufferedInputStream(in), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                keyId = this.toFingerprint(this.signingKey).toLowerCase(Locale.ROOT);
                keyrings = pgpPub.getKeyRings();
                while (true) {
                    keyRing = (PGPPublicKeyRing)keyrings.next();
                    keys = keyRing.getPublicKeys();
                    while (keys.hasNext()) {
                        key = (PGPPublicKey)keys.next();
                        fingerprint = Hex.toHexString((byte[])key.getFingerprint()).toLowerCase(Locale.ROOT);
                        if (fingerprint.endsWith(keyId)) {
                            return key;
                        }
                        userIDs = key.getUserIDs();
                        while (userIDs.hasNext()) {
                            userId = (String)userIDs.next();
                            if (!BouncyCastleGpgKeyLocator.containsSigningKey(userId, this.signingKey)) continue;
                            return key;
                        }
                    }
                    break;
                }
            }
            finally {
                if (keyrings.hasNext()) ** continue;
            }
        }
        catch (Throwable var3_5) {
            if (var2_2 == null) {
                var2_2 = var3_5;
            } else if (var2_2 != var3_5) {
                var2_2.addSuppressed(var3_5);
            }
            throw var2_2;
        }
        return null;
    }

    private PGPPublicKey getPublicKey(KeyBlob blob, byte[] fingerprint) throws IOException {
        return ((PublicKeyRingBlob)blob).getPGPPublicKeyRing().getPublicKey(fingerprint);
    }

    private PGPPublicKey getSigningPublicKey(KeyBlob blob) throws IOException {
        PGPPublicKey masterKey = null;
        Iterator keys = ((PublicKeyRingBlob)blob).getPGPPublicKeyRing().getPublicKeys();
        while (keys.hasNext()) {
            PGPPublicKey key = (PGPPublicKey)keys.next();
            if (!this.isSigningKey(key)) continue;
            if (key.isMasterKey()) {
                masterKey = key;
                continue;
            }
            return key;
        }
        return masterKey;
    }

    private boolean isSigningKey(PGPPublicKey key) {
        Iterator signatures = key.getSignatures();
        while (signatures.hasNext()) {
            PGPSignature sig = (PGPSignature)signatures.next();
            if ((sig.getHashedSubPackets().getKeyFlags() & 2) <= 0) continue;
            return true;
        }
        return false;
    }

    private KeyBox readKeyBoxFile(Path keyboxFile) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, NoOpenPgpKeyException {
        JcaKeyBox keyBox;
        if (keyboxFile.toFile().length() == 0L) {
            throw new NoOpenPgpKeyException();
        }
        Throwable throwable = null;
        Object var4_4 = null;
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(keyboxFile, new OpenOption[0]));){
            keyBox = new JcaKeyBoxBuilder().build((InputStream)in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return keyBox;
    }

    private static /* synthetic */ boolean lambda$3(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    private static /* synthetic */ PBESecretKeyDecryptor lambda$2(String p) throws PGPException {
        throw new EncryptedPgpKeyException();
    }

    private static class EncryptedPgpKeyException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private EncryptedPgpKeyException() {
        }
    }

    private static class NoOpenPgpKeyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private NoOpenPgpKeyException() {
        }
    }
}

