/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.common;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.sirius.editor.utils.TextChangeHelper;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractMultilinePropertySection
extends AbstractViewpointPropertySection {
    protected Text text;
    protected CLabel nameLabel;
    protected Composite composite;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        if (tabbedPropertySheetPage instanceof ViewpointPropertySheetPage) {
            super.createControls(parent, (ViewpointPropertySheetPage)tabbedPropertySheetPage);
        } else {
            super.createControls(parent, tabbedPropertySheetPage);
        }
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.text = this.getWidgetFactory().createText(this.composite, "", 2);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 232);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(0, 150);
        this.text.setLayoutData((Object)data);
        this.nameLabel = this.getWidgetFactory().createCLabel(this.composite, this.getLabelText());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.text, -25);
        data.top = new FormAttachment((Control)this.text, 0, 128);
        this.nameLabel.setLayoutData((Object)data);
        TextChangeHelper listener = new TextChangeHelper(false){

            @Override
            public void textChanged(Text control) {
                AbstractMultilinePropertySection.this.handleTextModified();
            }
        };
        listener.startListeningTo(this.text);
        listener.startListeningForEnter(this.text);
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.sirius." + this.eObject.eClass().getName());
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.nameLabel.setText(this.getLabelText());
    }

    protected void handleTextModified() {
        String newText = this.text.getText();
        boolean equals = this.isEqual(newText);
        if (!equals) {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.getPart()).getEditingDomain();
            Object value = this.getFeatureValue(newText);
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), (Object)value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        if (this.getFeatureAsText() != null) {
            this.text.setText(this.getFeatureAsText());
        }
    }

    protected abstract boolean isEqual(String var1);

    protected abstract EAttribute getFeature();

    protected abstract String getPropertyDescription();

    protected String getToolTipText() {
        return this.getPropertyDescription();
    }

    protected String getFeatureAsText() {
        String value = new String();
        if (this.eObject.eGet((EStructuralFeature)this.getFeature()) != null) {
            value = this.eObject.eGet((EStructuralFeature)this.getFeature()).toString();
        }
        return value;
    }

    protected abstract Object getFeatureValue(String var1);

    protected abstract String getDefaultLabelText();

    protected String getLabelText() {
        EAttribute eFeature;
        IItemPropertyDescriptor propertyDescriptor;
        if (this.eObject != null && (propertyDescriptor = this.getPropertyDescriptor((EStructuralFeature)(eFeature = this.getFeature()))) != null) {
            return propertyDescriptor.getDisplayName((Object)this.eObject);
        }
        return this.getDefaultLabelText();
    }

    @Override
    protected void makeReadonly() {
        this.text.setEnabled(false);
    }

    @Override
    protected void makeWrittable() {
        this.text.setEnabled(true);
    }
}

