/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.actions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.ICommandFactory;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractCreateRepresentationFromRepresentationCreationDescription
extends Action {
    private static final AdapterFactory ADAPTER_FACTORY = DialectUIManager.INSTANCE.createAdapterFactory();
    private final RepresentationCreationDescription desc;
    private final DRepresentationElement target;
    private final TransactionalEditingDomain editingDomain;
    private final ICommandFactory commandFactory;

    public AbstractCreateRepresentationFromRepresentationCreationDescription(RepresentationCreationDescription desc, DRepresentationElement target, TransactionalEditingDomain editingDomain, ICommandFactory commandFactory) {
        IItemLabelProvider labelProvider;
        this.desc = desc;
        this.target = target;
        this.editingDomain = editingDomain;
        ImageDescriptor imageDescriptor = null;
        RepresentationDescription representationDescription = desc.getRepresentationDescription();
        if (representationDescription != null && (labelProvider = (IItemLabelProvider)ADAPTER_FACTORY.adapt((Notifier)representationDescription, IItemLabelProvider.class)) != null) {
            imageDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage((Object)representationDescription));
        }
        if (imageDescriptor != null) {
            this.setImageDescriptor(imageDescriptor);
        } else {
            this.setImageDescriptor(SiriusTransPlugin.getBundledImageDescriptor((String)"/icons/CreateView.gif"));
        }
        this.commandFactory = commandFactory;
    }

    public boolean isEnabled() {
        boolean isEnabled = super.isEnabled();
        if (isEnabled) {
            if (this.desc.getRepresentationDescription() == null) {
                isEnabled = false;
            } else {
                CreateRepresentationCommand command = this.commandFactory.buildCreateRepresentationFromDescription(this.desc, this.target, "");
                return command.canExecute();
            }
        }
        return isEnabled;
    }

    public String getText() {
        IdentifiedElementQuery query = new IdentifiedElementQuery((IdentifiedElement)this.desc);
        return MessageTranslator.INSTANCE.getMessage((EObject)this.desc, query.getLabel());
    }

    public void run() {
        this.doCreateRepresentation();
    }

    private void doCreateRepresentation() {
        IdentifiedElementQuery query = new IdentifiedElementQuery((IdentifiedElement)this.desc);
        String name = MessageFormat.format(Messages.AbstractCreateRepresentationFromRepresentationCreationDescription_defaultName, query.getLabel());
        String computedName = this.computeName((DSemanticDecorator)this.target);
        if (computedName != null) {
            name = computedName;
        }
        try {
            name = this.commandFactory.getUserInterfaceCallBack().askForDetailName(name, MessageTranslator.INSTANCE.getMessage((EObject)this.desc, new IdentifiedElementQuery((IdentifiedElement)this.desc.getRepresentationDescription()).getLabel()), this.desc.getRepresentationDescription().getEndUserDocumentation());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        Option<DRepresentation> optionalCreatedRepresentation = this.executeCreationCommand(this.getInitialOperationCommand(name), this.getCreateRepresentationCommand(name));
        if (this.target != null) {
            if (!optionalCreatedRepresentation.some()) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openWarning((Shell)shell, (String)Messages.AbstractCreateRepresentationFromRepresentationCreationDescription_creationError_title, (String)Messages.AbstractCreateRepresentationFromRepresentationCreationDescription_creationError_message);
            } else {
                DialectUIManager.INSTANCE.openEditor(SessionManager.INSTANCE.getSession(this.target.getTarget()), (DRepresentation)optionalCreatedRepresentation.get(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected abstract Option<DRepresentation> executeCreationCommand(Option<Command> var1, CreateRepresentationCommand var2);

    protected Option<Command> getInitialOperationCommand(String defaultRepresentationName) {
        if (this.isInitialOperation()) {
            return Options.newSome((Object)this.commandFactory.buildDoExecuteDetailsOperation((DSemanticDecorator)this.target, this.desc, defaultRepresentationName));
        }
        return Options.newNone();
    }

    protected CreateRepresentationCommand getCreateRepresentationCommand(String defaultRepresentationName) {
        return this.commandFactory.buildCreateRepresentationFromDescription(this.desc, this.target, defaultRepresentationName);
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected DRepresentationElement getTarget() {
        return this.target;
    }

    protected boolean isInitialOperation() {
        return this.desc.getInitialOperation() != null && this.desc.getInitialOperation().getFirstModelOperations() != null;
    }

    private String computeName(DSemanticDecorator decorator) {
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)decorator.getTarget());
        RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
        String computedName = null;
        if (!StringUtil.isEmpty((String)this.desc.getTitleExpression())) {
            computedName = safeInterpreter.evaluateString(decorator.getTarget(), (EObject)this.desc, (EStructuralFeature)ToolPackage.eINSTANCE.getRepresentationCreationDescription_TitleExpression());
        } else if (this.desc.getRepresentationDescription() != null && !StringUtil.isEmpty((String)this.desc.getRepresentationDescription().getTitleExpression())) {
            computedName = safeInterpreter.evaluateString(decorator.getTarget(), (EObject)this.desc.getRepresentationDescription(), (EStructuralFeature)DescriptionPackage.eINSTANCE.getRepresentationDescription_TitleExpression());
        }
        return computedName;
    }
}

