/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.spi.FileSystemProvider;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.auth.BasicCredentialsImpl;
import org.apache.sshd.common.auth.BasicCredentialsProvider;
import org.apache.sshd.common.auth.MutableBasicCredentials;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.SftpVersionSelector;
import org.apache.sshd.sftp.client.extensions.CopyFileExtension;
import org.apache.sshd.sftp.client.fs.SftpAclFileAttributeView;
import org.apache.sshd.sftp.client.fs.SftpDirectoryStream;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpFileSystemClientSessionInitializer;
import org.apache.sshd.sftp.client.fs.SftpFileSystemInitializationContext;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.apache.sshd.sftp.client.fs.SftpPosixFileAttributeView;
import org.apache.sshd.sftp.client.impl.SftpPathImpl;
import org.apache.sshd.sftp.client.impl.SftpRemotePathChannel;
import org.apache.sshd.sftp.common.SftpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpFileSystemProvider
extends FileSystemProvider {
    public static final String VERSION_PARAM = "version";
    public static final Set<Class<? extends FileAttributeView>> UNIVERSAL_SUPPORTED_VIEWS = Collections.unmodifiableSet(GenericUtils.asSet((Object[])new Class[]{PosixFileAttributeView.class, FileOwnerAttributeView.class, BasicFileAttributeView.class}));
    protected final Logger log;
    private final SshClient clientInstance;
    private final SftpClientFactory factory;
    private final SftpVersionSelector versionSelector;
    private final SftpErrorDataHandler errorDataHandler;
    private final NavigableMap<String, SftpFileSystem> fileSystems = new TreeMap<String, SftpFileSystem>(String.CASE_INSENSITIVE_ORDER);
    private SftpFileSystemClientSessionInitializer fsSessionInitializer = SftpFileSystemClientSessionInitializer.DEFAULT;

    public SftpFileSystemProvider() {
        this((SshClient)null);
    }

    public SftpFileSystemProvider(SftpVersionSelector selector) {
        this(null, selector);
    }

    public SftpFileSystemProvider(SshClient client) {
        this(client, SftpVersionSelector.CURRENT);
    }

    public SftpFileSystemProvider(SshClient client, SftpVersionSelector selector) {
        this(client, selector, SftpErrorDataHandler.EMPTY);
    }

    public SftpFileSystemProvider(SshClient client, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) {
        this(client, null, selector, errorDataHandler);
    }

    public SftpFileSystemProvider(SshClient client, SftpClientFactory factory, SftpVersionSelector selector) {
        this(client, factory, selector, SftpErrorDataHandler.EMPTY);
    }

    public SftpFileSystemProvider(SshClient client, SftpClientFactory factory, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) {
        this.log = LoggerFactory.getLogger(this.getClass());
        this.factory = factory;
        this.versionSelector = selector;
        this.errorDataHandler = errorDataHandler;
        if (client == null) {
            client = SshClient.setUpDefaultClient();
            client.start();
        }
        this.clientInstance = client;
    }

    @Override
    public String getScheme() {
        return "sftp";
    }

    public final SftpVersionSelector getSftpVersionSelector() {
        return this.versionSelector;
    }

    public SftpErrorDataHandler getSftpErrorDataHandler() {
        return this.errorDataHandler;
    }

    public final SshClient getClientInstance() {
        return this.clientInstance;
    }

    public SftpClientFactory getSftpClientFactory() {
        return this.factory;
    }

    public SftpFileSystemClientSessionInitializer getSftpFileSystemClientSessionInitializer() {
        return this.fsSessionInitializer;
    }

    public void setSftpFileSystemClientSessionInitializer(SftpFileSystemClientSessionInitializer initializer) {
        this.fsSessionInitializer = Objects.requireNonNull(initializer, "No initializer provided");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpFileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        SftpFileSystem fileSystem;
        MutableBasicCredentials credentials;
        String host = ValidateUtils.checkNotNullAndNotEmpty((String)uri.getHost(), (String)"Host not provided");
        int port = uri.getPort();
        if (port <= 0) {
            port = 22;
        }
        ValidateUtils.checkState(((credentials = SftpFileSystemProvider.parseCredentials(uri)) != null ? 1 : 0) != 0, (String)"No credentials provided");
        String username = credentials.getUsername();
        String id = SftpFileSystemProvider.getFileSystemIdentifier(host, port, username);
        SftpFileSystemInitializationContext context = new SftpFileSystemInitializationContext(id, uri, env);
        context.setHost(host);
        context.setPort(port);
        context.setCredentials((BasicCredentialsProvider)credentials);
        Map<String, Object> params = SftpFileSystemProvider.resolveFileSystemParameters(env, SftpFileSystemProvider.parseURIParameters(uri));
        PropertyResolver resolver = PropertyResolverUtils.toPropertyResolver(params);
        context.setPropertyResolver(resolver);
        context.setMaxConnectTime((Duration)SftpModuleProperties.CONNECT_TIME.getRequired(resolver));
        context.setMaxAuthTime((Duration)SftpModuleProperties.AUTH_TIME.getRequired(resolver));
        SftpVersionSelector selector = this.resolveSftpVersionSelector(uri, this.getSftpVersionSelector(), resolver);
        SftpErrorDataHandler errorHandler = this.resolveSftpErrorDataHandler(uri, this.getSftpErrorDataHandler(), resolver);
        Charset decodingCharset = (Charset)SftpModuleProperties.NAME_DECODER_CHARSET.getRequired(resolver);
        SftpFileSystemClientSessionInitializer initializer = this.getSftpFileSystemClientSessionInitializer();
        NavigableMap<String, SftpFileSystem> navigableMap = this.fileSystems;
        synchronized (navigableMap) {
            if (this.fileSystems.containsKey(id)) {
                throw new FileSystemAlreadyExistsException(id);
            }
            ClientSession session = null;
            try {
                session = initializer.createClientSession(this, context);
                if (MapEntryUtils.size(params) > 0) {
                    for (Map.Entry<String, Object> pe : params.entrySet()) {
                        String key = pe.getKey();
                        Object value = pe.getValue();
                        if (VERSION_PARAM.equalsIgnoreCase(key)) continue;
                        PropertyResolverUtils.updateProperty((PropertyResolver)session, (String)key, (Object)value);
                    }
                    SftpModuleProperties.NAME_DECODING_CHARSET.set((PropertyResolver)session, (Object)decodingCharset);
                }
                initializer.authenticateClientSession(this, context, session);
                fileSystem = initializer.createSftpFileSystem(this, context, session, selector, errorHandler);
                this.fileSystems.put(id, fileSystem);
            }
            catch (Exception e) {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (IOException t) {
                        e.addSuppressed(t);
                        LoggingUtils.debug((Logger)this.log, (String)"Failed ({}) to close session for new file system on {}}:{} due to {}[{}]: {}", (Object)t.getClass().getSimpleName(), (Object)host, (Object)port, (Object)e.getClass().getSimpleName(), (Object)e.getMessage(), (Object)t.getMessage(), (Throwable)t);
                    }
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IOException(e);
            }
        }
        Integer bs = (Integer)SftpModuleProperties.READ_BUFFER_SIZE.getOrNull(resolver);
        if (bs != null) {
            fileSystem.setReadBufferSize(bs);
        }
        if ((bs = (Integer)SftpModuleProperties.WRITE_BUFFER_SIZE.getOrNull(resolver)) != null) {
            fileSystem.setWriteBufferSize(bs);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("newFileSystem({}): {}", (Object)uri.toASCIIString(), (Object)fileSystem);
        }
        return fileSystem;
    }

    protected SftpVersionSelector resolveSftpVersionSelector(URI uri, SftpVersionSelector defaultSelector, PropertyResolver resolver) {
        String preference = resolver.getString(VERSION_PARAM);
        if (GenericUtils.isEmpty((CharSequence)preference)) {
            return defaultSelector;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveSftpVersionSelector({}) preference={}", (Object)uri, (Object)preference);
        }
        if ("max".equalsIgnoreCase(preference)) {
            return SftpVersionSelector.MAXIMUM;
        }
        if ("min".equalsIgnoreCase(preference)) {
            return SftpVersionSelector.MINIMUM;
        }
        return SftpVersionSelector.resolveVersionSelector(preference);
    }

    protected SftpErrorDataHandler resolveSftpErrorDataHandler(URI uri, SftpErrorDataHandler errorHandler, PropertyResolver resolver) {
        return errorHandler;
    }

    public static Map<String, Object> resolveFileSystemParameters(Map<String, ?> env, Map<String, Object> uriParams) {
        if (MapEntryUtils.isEmpty(env)) {
            return MapEntryUtils.isEmpty(uriParams) ? Collections.emptyMap() : uriParams;
        }
        if (MapEntryUtils.isEmpty(uriParams)) {
            return Collections.unmodifiableMap(env);
        }
        TreeMap<String, Object> resolved = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        resolved.putAll(env);
        resolved.putAll(uriParams);
        return resolved;
    }

    public static MutableBasicCredentials parseCredentials(URI uri) {
        return SftpFileSystemProvider.parseCredentials(uri == null ? "" : uri.getUserInfo());
    }

    public static MutableBasicCredentials parseCredentials(String userInfo) {
        if (GenericUtils.isEmpty((CharSequence)userInfo)) {
            return null;
        }
        int pos = userInfo.indexOf(58);
        if (pos < 0) {
            return new BasicCredentialsImpl(userInfo, null);
        }
        return new BasicCredentialsImpl(userInfo.substring(0, pos), userInfo.substring(pos + 1));
    }

    public static Map<String, Object> parseURIParameters(URI uri) {
        return SftpFileSystemProvider.parseURIParameters(uri == null ? "" : uri.getQuery());
    }

    public static Map<String, Object> parseURIParameters(String params) {
        if (GenericUtils.isEmpty((CharSequence)params)) {
            return Collections.emptyMap();
        }
        if (params.charAt(0) == '?') {
            if (params.length() == 1) {
                return Collections.emptyMap();
            }
            params = params.substring(1);
        }
        String[] pairs = GenericUtils.split((String)params, (char)'&');
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (String p : pairs) {
            int pos = p.indexOf(61);
            if (pos < 0) {
                map.put(p, Boolean.TRUE);
                continue;
            }
            String key = p.substring(0, pos);
            String value = p.substring(pos + 1);
            if (NumberUtils.isIntegerNumber((CharSequence)value)) {
                map.put(key, Long.valueOf(value));
                continue;
            }
            if ("true".equals(value) || "false".equals("value")) {
                map.put(key, Boolean.valueOf(value));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpFileSystem newFileSystem(ClientSession session) throws IOException {
        Integer wbs;
        SftpFileSystem fileSystem;
        String id = SftpFileSystemProvider.getFileSystemIdentifier(session);
        NavigableMap<String, SftpFileSystem> navigableMap = this.fileSystems;
        synchronized (navigableMap) {
            if (this.fileSystems.containsKey(id)) {
                throw new FileSystemAlreadyExistsException(id);
            }
            fileSystem = new SftpFileSystem(this, id, session, this.factory, this.getSftpVersionSelector(), this.getSftpErrorDataHandler());
            this.fileSystems.put(id, fileSystem);
        }
        Integer rbs = session.getInteger(SftpModuleProperties.READ_BUFFER_SIZE.getName());
        if (rbs != null) {
            fileSystem.setReadBufferSize(rbs);
        }
        if ((wbs = session.getInteger(SftpModuleProperties.WRITE_BUFFER_SIZE.getName())) != null) {
            fileSystem.setWriteBufferSize(wbs);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("newFileSystem: {}", (Object)fileSystem);
        }
        return fileSystem;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        String id = SftpFileSystemProvider.getFileSystemIdentifier(uri);
        SftpFileSystem fs = this.getFileSystem(id);
        if (fs == null) {
            throw new FileSystemNotFoundException(id);
        }
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpFileSystem removeFileSystem(String id) {
        SftpFileSystem removed;
        if (GenericUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        NavigableMap<String, SftpFileSystem> navigableMap = this.fileSystems;
        synchronized (navigableMap) {
            removed = (SftpFileSystem)((Object)this.fileSystems.remove(id));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("removeFileSystem({}): {}", (Object)id, (Object)removed);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpFileSystem getFileSystem(String id) {
        if (GenericUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        NavigableMap<String, SftpFileSystem> navigableMap = this.fileSystems;
        synchronized (navigableMap) {
            return (SftpFileSystem)((Object)this.fileSystems.get(id));
        }
    }

    @Override
    public Path getPath(URI uri) {
        FileSystem fs = this.getFileSystem(uri);
        return fs.getPath(uri.getPath(), new String[0]);
    }

    @Override
    public FileChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.newFileChannel(path, options, attrs);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Set<SftpClient.OpenMode> modes = SftpClient.OpenMode.fromOpenOptions(options);
        if (modes.isEmpty()) {
            modes = EnumSet.of(SftpClient.OpenMode.Read, SftpClient.OpenMode.Write);
        }
        SftpPath p = this.toSftpPath(path);
        return new SftpRemotePathChannel(p.toString(), ((SftpFileSystem)p.getFileSystem()).getClient(), true, modes);
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        Set<SftpClient.OpenMode> modes = SftpClient.OpenMode.fromOpenOptions(Arrays.asList(options));
        if (modes.isEmpty()) {
            modes = EnumSet.of(SftpClient.OpenMode.Read);
        }
        SftpPath p = this.toSftpPath(path);
        return ((SftpFileSystem)p.getFileSystem()).getClient().read(p.toString(), modes);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        Set<SftpClient.OpenMode> modes = SftpClient.OpenMode.fromOpenOptions(Arrays.asList(options));
        if (modes.contains((Object)SftpClient.OpenMode.Read)) {
            throw new IllegalArgumentException("READ not allowed");
        }
        if (modes.isEmpty()) {
            modes = EnumSet.of(SftpClient.OpenMode.Create, SftpClient.OpenMode.Truncate, SftpClient.OpenMode.Write);
        } else {
            modes.add(SftpClient.OpenMode.Write);
        }
        SftpPath p = this.toSftpPath(path);
        return ((SftpFileSystem)p.getFileSystem()).getClient().write(p.toString(), modes);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        SftpPath p = this.toSftpPath(dir);
        return new SftpDirectoryStream(p, filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        SftpPath p = this.toSftpPath(dir);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        if (this.log.isDebugEnabled()) {
            this.log.debug("createDirectory({}) {} ({})", new Object[]{fs, dir, Arrays.asList(attrs)});
        }
        try (SftpClient sftp = fs.getClient();){
            try {
                sftp.mkdir(dir.toString());
            }
            catch (SftpException e) {
                int sftpStatus = e.getStatus();
                if (sftp.getVersion() == 3 && sftpStatus == 4) {
                    try {
                        SftpClient.Attributes attributes = sftp.stat(dir.toString());
                        if (attributes != null) {
                            throw new FileAlreadyExistsException(p.toString());
                        }
                    }
                    catch (SshException e2) {
                        e.addSuppressed(e2);
                    }
                }
                if (sftpStatus == 11) {
                    throw new FileAlreadyExistsException(p.toString());
                }
                throw e;
            }
            for (FileAttribute<?> attr : attrs) {
                this.setAttribute((Path)((Object)p), attr.name(), attr.value(), new LinkOption[0]);
            }
        }
    }

    @Override
    public void delete(Path path) throws IOException {
        SftpPath p = this.toSftpPath(path);
        this.checkAccess((Path)((Object)p), AccessMode.WRITE);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        if (this.log.isDebugEnabled()) {
            this.log.debug("delete({}) {}", (Object)fs, (Object)path);
        }
        try (SftpClient sftp = fs.getClient();){
            BasicFileAttributes attributes = this.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            if (attributes.isDirectory()) {
                sftp.rmdir(path.toString());
            } else {
                sftp.remove(path.toString());
            }
        }
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        SftpPath src = this.toSftpPath(source);
        SftpPath dst = this.toSftpPath(target);
        if (src.getFileSystem() != dst.getFileSystem()) {
            throw new ProviderMismatchException("Mismatched file system providers for " + (Object)((Object)src) + " vs. " + (Object)((Object)dst));
        }
        this.checkAccess((Path)((Object)src), new AccessMode[0]);
        boolean replaceExisting = false;
        boolean copyAttributes = false;
        boolean noFollowLinks = false;
        for (CopyOption opt : options) {
            replaceExisting |= opt == StandardCopyOption.REPLACE_EXISTING;
            copyAttributes |= opt == StandardCopyOption.COPY_ATTRIBUTES;
            noFollowLinks |= opt == LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] linkOptions = IoUtils.getLinkOptions((!noFollowLinks ? 1 : 0) != 0);
        BasicFileAttributes attrs = this.readAttributes(source, BasicFileAttributes.class, linkOptions);
        if (attrs.isSymbolicLink()) {
            throw new IOException("Copying of symbolic links not supported");
        }
        Boolean status = IoUtils.checkFileExists((Path)target, (LinkOption[])linkOptions);
        if (status == null) {
            throw new AccessDeniedException("Existence cannot be determined for copy target: " + target);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("copy({})[{}] {} => {}", new Object[]{src.getFileSystem(), Arrays.asList(options), src, dst});
        }
        if (replaceExisting) {
            this.deleteIfExists(target);
        } else if (status.booleanValue()) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (attrs.isDirectory()) {
            this.createDirectory(target, new FileAttribute[0]);
        } else {
            CopyFileExtension copyFile = ((SftpFileSystem)src.getFileSystem()).getClient().getExtension(CopyFileExtension.class);
            if (copyFile.isSupported()) {
                copyFile.copyFile(source.toString(), target.toString(), false);
            } else {
                try (InputStream in = this.newInputStream(source, new OpenOption[0]);
                     OutputStream os = this.newOutputStream(target, new OpenOption[0]);){
                    IoUtils.copy((InputStream)in, (OutputStream)os);
                }
            }
        }
        if (copyAttributes) {
            BasicFileAttributeView view = this.getFileAttributeView(target, BasicFileAttributeView.class, linkOptions);
            try {
                view.setTimes(attrs.lastModifiedTime(), attrs.lastAccessTime(), attrs.creationTime());
            }
            catch (Throwable x) {
                try {
                    this.delete(target);
                }
                catch (Throwable suppressed) {
                    x.addSuppressed(suppressed);
                }
                throw x;
            }
        }
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        SftpPath src = this.toSftpPath(source);
        SftpFileSystem fsSrc = (SftpFileSystem)src.getFileSystem();
        SftpPath dst = this.toSftpPath(target);
        if (src.getFileSystem() != dst.getFileSystem()) {
            throw new ProviderMismatchException("Mismatched file system providers for " + (Object)((Object)src) + " vs. " + (Object)((Object)dst));
        }
        this.checkAccess((Path)((Object)src), new AccessMode[0]);
        boolean replaceExisting = false;
        boolean copyAttributes = false;
        boolean noFollowLinks = false;
        for (CopyOption opt : options) {
            replaceExisting |= opt == StandardCopyOption.REPLACE_EXISTING;
            copyAttributes |= opt == StandardCopyOption.COPY_ATTRIBUTES;
            noFollowLinks |= opt == LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] linkOptions = IoUtils.getLinkOptions((boolean)noFollowLinks);
        BasicFileAttributes attrs = this.readAttributes(source, BasicFileAttributes.class, linkOptions);
        if (attrs.isSymbolicLink()) {
            throw new IOException("Moving of source symbolic link (" + source + ") to " + target + " not supported");
        }
        Boolean status = IoUtils.checkFileExists((Path)target, (LinkOption[])linkOptions);
        if (status == null) {
            throw new AccessDeniedException("Existence cannot be determined for move target " + target);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("move({})[{}] {} => {}", new Object[]{src.getFileSystem(), Arrays.asList(options), src, dst});
        }
        if (replaceExisting) {
            this.deleteIfExists(target);
        } else if (status.booleanValue()) {
            throw new FileAlreadyExistsException(target.toString());
        }
        try (SftpClient sftp = fsSrc.getClient();){
            sftp.rename(src.toString(), dst.toString());
        }
        if (copyAttributes) {
            BasicFileAttributeView view = this.getFileAttributeView(target, BasicFileAttributeView.class, linkOptions);
            try {
                view.setTimes(attrs.lastModifiedTime(), attrs.lastAccessTime(), attrs.creationTime());
            }
            catch (Throwable x) {
                try {
                    this.delete(target);
                }
                catch (Throwable suppressed) {
                    x.addSuppressed(suppressed);
                }
                throw x;
            }
        }
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        SftpPath p1 = this.toSftpPath(path1);
        SftpPath p2 = this.toSftpPath(path2);
        if (p1.getFileSystem() != p2.getFileSystem()) {
            throw new ProviderMismatchException("Mismatched file system providers for " + (Object)((Object)p1) + " vs. " + (Object)((Object)p2));
        }
        this.checkAccess((Path)((Object)p1), new AccessMode[0]);
        this.checkAccess((Path)((Object)p2), new AccessMode[0]);
        return p1.equals((Object)p2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        FileSystem fs = path.getFileSystem();
        if (!(fs instanceof SftpFileSystem)) {
            throw new FileSystemException(path.toString(), path.toString(), "getFileStore(" + path + ") path not attached to an SFTP file system");
        }
        SftpFileSystem sftpFs = (SftpFileSystem)((Object)fs);
        String id = sftpFs.getId();
        SftpFileSystem cached = this.getFileSystem(id);
        if (cached != sftpFs) {
            throw new FileSystemException(path.toString(), path.toString(), "Mismatched file system instance for id=" + id);
        }
        return (FileStore)sftpFs.getFileStores().get(0);
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        SftpPath t;
        SftpPath l = this.toSftpPath(link);
        SftpFileSystem fsLink = (SftpFileSystem)l.getFileSystem();
        if (fsLink != (t = this.toSftpPath(target)).getFileSystem()) {
            throw new ProviderMismatchException("Mismatched file system providers for " + (Object)((Object)l) + " vs. " + (Object)((Object)t));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("createSymbolicLink({})[{}] {} => {}", new Object[]{fsLink, Arrays.asList(attrs), link, target});
        }
        try (SftpClient client = fsLink.getClient();){
            client.symLink(l.toString(), t.toString());
        }
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        SftpPath l = this.toSftpPath(link);
        SftpFileSystem fsLink = (SftpFileSystem)l.getFileSystem();
        try (SftpClient client = fsLink.getClient();){
            String linkPath = client.readLink(l.toString());
            if (this.log.isDebugEnabled()) {
                this.log.debug("readSymbolicLink({})[{}] {} => {}", new Object[]{fsLink, link, linkPath});
            }
            Path path = fsLink.getPath(linkPath, new String[0]);
            return path;
        }
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        BasicFileAttributes attrs;
        SftpPath p = this.toSftpPath(path);
        boolean w = false;
        boolean x = false;
        if (GenericUtils.length((Object[])modes) > 0) {
            block5: for (AccessMode mode : modes) {
                switch (mode) {
                    case READ: {
                        continue block5;
                    }
                    case WRITE: {
                        w = true;
                        continue block5;
                    }
                    case EXECUTE: {
                        x = true;
                        continue block5;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported mode: " + (Object)((Object)mode));
                    }
                }
            }
        }
        if (!((attrs = this.getFileAttributeView((Path)((Object)p), BasicFileAttributeView.class, new LinkOption[0]).readAttributes()) != null || p.isAbsolute() && p.getNameCount() == 0)) {
            throw new NoSuchFileException(path.toString());
        }
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        if (x || w && fs.isReadOnly()) {
            throw new AccessDeniedException("Filesystem is read-only: " + path.toString());
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        if (this.isSupportedFileAttributeView(path, type)) {
            if (AclFileAttributeView.class.isAssignableFrom(type)) {
                return (V)((FileAttributeView)type.cast(new SftpAclFileAttributeView(this, path, options)));
            }
            if (BasicFileAttributeView.class.isAssignableFrom(type)) {
                return (V)((FileAttributeView)type.cast(new SftpPosixFileAttributeView(this, path, options)));
            }
        }
        throw new UnsupportedOperationException("getFileAttributeView(" + path + ") view not supported: " + type.getSimpleName());
    }

    public boolean isSupportedFileAttributeView(Path path, Class<? extends FileAttributeView> type) {
        return this.isSupportedFileAttributeView((SftpFileSystem)this.toSftpPath(path).getFileSystem(), type);
    }

    public boolean isSupportedFileAttributeView(SftpFileSystem fs, Class<? extends FileAttributeView> type) {
        Set<String> views = fs.supportedFileAttributeViews();
        if (type == null || GenericUtils.isEmpty(views)) {
            return false;
        }
        if (PosixFileAttributeView.class.isAssignableFrom(type)) {
            return views.contains("posix");
        }
        if (AclFileAttributeView.class.isAssignableFrom(type)) {
            return views.contains("acl");
        }
        if (FileOwnerAttributeView.class.isAssignableFrom(type)) {
            return views.contains("owner");
        }
        if (BasicFileAttributeView.class.isAssignableFrom(type)) {
            return views.contains("basic");
        }
        return false;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type.isAssignableFrom(PosixFileAttributes.class)) {
            return (A)((BasicFileAttributes)type.cast(this.getFileAttributeView(path, PosixFileAttributeView.class, options).readAttributes()));
        }
        throw new UnsupportedOperationException("readAttributes(" + path + ")[" + type.getSimpleName() + "] N/A");
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        String attrs;
        String view;
        int i = attributes.indexOf(58);
        if (i == -1) {
            view = "basic";
            attrs = attributes;
        } else {
            view = attributes.substring(0, i++);
            attrs = attributes.substring(i);
        }
        return this.readAttributes(path, view, attrs, options);
    }

    public Map<String, Object> readAttributes(Path path, String view, String attrs, LinkOption ... options) throws IOException {
        SftpPath p = this.toSftpPath(path);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        Set<String> views = fs.supportedFileAttributeViews();
        if (GenericUtils.isEmpty(views) || !views.contains(view)) {
            throw new UnsupportedOperationException("readAttributes(" + path + ")[" + view + ":" + attrs + "] view not supported: " + views);
        }
        if ("basic".equalsIgnoreCase(view) || "posix".equalsIgnoreCase(view) || "owner".equalsIgnoreCase(view)) {
            return this.readPosixViewAttributes(p, view, attrs, options);
        }
        if ("acl".equalsIgnoreCase(view)) {
            return this.readAclViewAttributes(p, view, attrs, options);
        }
        return this.readCustomViewAttributes(p, view, attrs, options);
    }

    protected Map<String, Object> readCustomViewAttributes(SftpPath path, String view, String attrs, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("readCustomViewAttributes(" + (Object)((Object)path) + ")[" + view + ":" + attrs + "] view not supported");
    }

    protected NavigableMap<String, Object> readAclViewAttributes(SftpPath path, String view, String attrs, LinkOption ... options) throws IOException {
        SftpClient.Attributes attributes;
        if ("*".equals(attrs)) {
            attrs = "acl,owner";
        }
        SftpFileSystem fs = (SftpFileSystem)path.getFileSystem();
        try (SftpClient client = fs.getClient();){
            attributes = this.readRemoteAttributes(path, options);
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        String[] attrValues = GenericUtils.split((String)attrs, (char)',');
        boolean traceEnabled = this.log.isTraceEnabled();
        String[] stringArray = attrValues;
        int n = stringArray.length;
        block17: for (int i = 0; i < n; ++i) {
            String attr;
            switch (attr = stringArray[i]) {
                case "acl": {
                    List<AclEntry> acl = attributes.getAcl();
                    if (acl == null) continue block17;
                    map.put(attr, acl);
                    continue block17;
                }
                case "owner": {
                    String owner = attributes.getOwner();
                    if (GenericUtils.length((CharSequence)owner) <= 0) continue block17;
                    map.put(attr, new SftpFileSystem.DefaultUserPrincipal(owner));
                    continue block17;
                }
                default: {
                    if (!traceEnabled) continue block17;
                    this.log.trace("readAclViewAttributes({})[{}] unknown attribute: {}", new Object[]{fs, attrs, attr});
                }
            }
        }
        return map;
    }

    public SftpClient.Attributes readRemoteAttributes(SftpPath path, LinkOption ... options) throws IOException {
        return (SftpClient.Attributes)SftpPathImpl.withAttributeCache((Path)((Object)path), p -> this.resolveRemoteFileAttributes(path, options));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SftpClient.Attributes resolveRemoteFileAttributes(SftpPath path, LinkOption ... options) throws IOException {
        SftpClient.Attributes attributes = path.getAttributes();
        if (attributes != null) {
            return attributes;
        }
        SftpFileSystem fs = (SftpFileSystem)path.getFileSystem();
        try (SftpClient client = fs.getClient();){
            SftpClient.Attributes attrs = IoUtils.followLinks((LinkOption[])options) ? client.stat(path.toString()) : client.lstat(path.toString());
            if (this.log.isTraceEnabled()) {
                this.log.trace("resolveRemoteFileAttributes({})[{}]: {}", new Object[]{fs, path, attrs});
            }
            if (path instanceof SftpPathImpl) {
                ((SftpPathImpl)path).cacheAttributes(attrs);
            }
            SftpClient.Attributes attributes2 = attrs;
            return attributes2;
        }
        catch (SftpException e) {
            if (e.getStatus() != 2) throw e;
            NoSuchFileException toThrow = new NoSuchFileException(path.toString());
            toThrow.initCause(e);
            throw toThrow;
        }
    }

    protected NavigableMap<String, Object> readPosixViewAttributes(SftpPath path, String view, String attrs, LinkOption ... options) throws IOException {
        String[] attrValues;
        PosixFileAttributes v = this.readAttributes((Path)((Object)path), PosixFileAttributes.class, options);
        if ("*".equals(attrs)) {
            attrs = "lastModifiedTime,lastAccessTime,creationTime,size,isRegularFile,isDirectory,isSymbolicLink,isOther,fileKey,owner,group,permissions,fileKey";
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        boolean traceEnabled = this.log.isTraceEnabled();
        String[] stringArray = attrValues = GenericUtils.split((String)attrs, (char)',');
        int n = stringArray.length;
        block28: for (int i = 0; i < n; ++i) {
            String attr;
            switch (attr = stringArray[i]) {
                case "lastModifiedTime": {
                    map.put(attr, v.lastModifiedTime());
                    continue block28;
                }
                case "lastAccessTime": {
                    map.put(attr, v.lastAccessTime());
                    continue block28;
                }
                case "creationTime": {
                    map.put(attr, v.creationTime());
                    continue block28;
                }
                case "size": {
                    map.put(attr, v.size());
                    continue block28;
                }
                case "isRegularFile": {
                    map.put(attr, v.isRegularFile());
                    continue block28;
                }
                case "isDirectory": {
                    map.put(attr, v.isDirectory());
                    continue block28;
                }
                case "isSymbolicLink": {
                    map.put(attr, v.isSymbolicLink());
                    continue block28;
                }
                case "isOther": {
                    map.put(attr, v.isOther());
                    continue block28;
                }
                case "fileKey": {
                    map.put(attr, v.fileKey());
                    continue block28;
                }
                case "owner": {
                    map.put(attr, v.owner());
                    continue block28;
                }
                case "permissions": {
                    map.put(attr, v.permissions());
                    continue block28;
                }
                case "group": {
                    map.put(attr, v.group());
                    continue block28;
                }
                default: {
                    if (!traceEnabled) continue block28;
                    this.log.trace("readPosixViewAttributes({})[{}:{}] ignored for {}", new Object[]{path, view, attr, attrs});
                }
            }
        }
        return map;
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        String attr;
        String view;
        int i = attribute.indexOf(58);
        if (i == -1) {
            view = "basic";
            attr = attribute;
        } else {
            view = attribute.substring(0, i++);
            attr = attribute.substring(i);
        }
        this.setAttribute(path, view, attr, value, options);
    }

    public void setAttribute(Path path, String view, String attr, Object value, LinkOption ... options) throws IOException {
        SftpPath p = this.toSftpPath(path);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        Set<String> views = fs.supportedFileAttributeViews();
        if (GenericUtils.isEmpty(views) || !views.contains(view)) {
            throw new UnsupportedOperationException("setAttribute(" + path + ")[" + view + ":" + attr + "=" + value + "] view " + view + " not supported: " + views);
        }
        SftpClient.Attributes attributes = new SftpClient.Attributes();
        switch (attr) {
            case "lastModifiedTime": {
                attributes.modifyTime((int)((FileTime)value).to(TimeUnit.SECONDS));
                break;
            }
            case "lastAccessTime": {
                attributes.accessTime((int)((FileTime)value).to(TimeUnit.SECONDS));
                break;
            }
            case "creationTime": {
                attributes.createTime((int)((FileTime)value).to(TimeUnit.SECONDS));
                break;
            }
            case "size": {
                attributes.size(((Number)value).longValue());
                break;
            }
            case "permissions": {
                Set attrSet = (Set)value;
                attributes.perms(this.attributesToPermissions(path, attrSet));
                break;
            }
            case "owner": {
                attributes.owner(((UserPrincipal)value).getName());
                break;
            }
            case "group": {
                attributes.group(((GroupPrincipal)value).getName());
                break;
            }
            case "acl": {
                ValidateUtils.checkTrue((boolean)"acl".equalsIgnoreCase(view), (String)"ACL cannot be set via view=%s", (Object)view);
                List acl = (List)value;
                attributes.acl(acl);
                break;
            }
            case "isRegularFile": 
            case "isDirectory": 
            case "isSymbolicLink": 
            case "isOther": 
            case "fileKey": {
                throw new UnsupportedOperationException("setAttribute(" + path + ")[" + view + ":" + attr + "=" + value + "] modification N/A");
            }
            default: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace("setAttribute({})[{}] ignore {}:{}={}", new Object[]{fs, path, view, attr, value});
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setAttribute({}) {}: {}", new Object[]{fs, path, attributes});
        }
        try (SftpClient client = fs.getClient();){
            client.setStat(p.toString(), attributes);
        }
    }

    public SftpPath toSftpPath(Path path) {
        Objects.requireNonNull(path, "No path provided");
        if (!(path instanceof SftpPath)) {
            throw new ProviderMismatchException("Path is not SFTP: " + path);
        }
        return (SftpPath)((Object)path);
    }

    protected int attributesToPermissions(Path path, Collection<PosixFilePermission> perms) {
        if (GenericUtils.isEmpty(perms)) {
            return 0;
        }
        int pf = 0;
        boolean traceEnabled = this.log.isTraceEnabled();
        block11: for (PosixFilePermission p : perms) {
            switch (p) {
                case OWNER_READ: {
                    pf |= 0x100;
                    continue block11;
                }
                case OWNER_WRITE: {
                    pf |= 0x80;
                    continue block11;
                }
                case OWNER_EXECUTE: {
                    pf |= 0x40;
                    continue block11;
                }
                case GROUP_READ: {
                    pf |= 0x20;
                    continue block11;
                }
                case GROUP_WRITE: {
                    pf |= 0x10;
                    continue block11;
                }
                case GROUP_EXECUTE: {
                    pf |= 8;
                    continue block11;
                }
                case OTHERS_READ: {
                    pf |= 4;
                    continue block11;
                }
                case OTHERS_WRITE: {
                    pf |= 2;
                    continue block11;
                }
                case OTHERS_EXECUTE: {
                    pf |= 1;
                    continue block11;
                }
            }
            if (!traceEnabled) continue;
            this.log.trace("attributesToPermissions(" + path + ") ignored " + (Object)((Object)p));
        }
        return pf;
    }

    public static String getRWXPermissions(int perms) {
        StringBuilder sb = new StringBuilder(10);
        if ((perms & 0xA000) == 40960) {
            sb.append('l');
        } else if ((perms & 0x4000) == 16384) {
            sb.append('d');
        } else {
            sb.append('-');
        }
        if ((perms & 0x100) == 256) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if ((perms & 0x80) == 128) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if ((perms & 0x40) == 64) {
            sb.append('x');
        } else {
            sb.append('-');
        }
        if ((perms & 0x20) == 32) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if ((perms & 0x10) == 16) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if ((perms & 8) == 8) {
            sb.append('x');
        } else {
            sb.append('-');
        }
        if ((perms & 4) == 4) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if ((perms & 2) == 2) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if ((perms & 1) == 1) {
            sb.append('x');
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String getOctalPermissions(int perms) {
        Set<PosixFilePermission> attrs = SftpFileSystemProvider.permissionsToAttributes(perms);
        return SftpFileSystemProvider.getOctalPermissions(attrs);
    }

    public static Set<PosixFilePermission> permissionsToAttributes(int perms) {
        EnumSet<PosixFilePermission> p = EnumSet.noneOf(PosixFilePermission.class);
        if ((perms & 0x100) == 256) {
            p.add(PosixFilePermission.OWNER_READ);
        }
        if ((perms & 0x80) == 128) {
            p.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((perms & 0x40) == 64) {
            p.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((perms & 0x20) == 32) {
            p.add(PosixFilePermission.GROUP_READ);
        }
        if ((perms & 0x10) == 16) {
            p.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((perms & 8) == 8) {
            p.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((perms & 4) == 4) {
            p.add(PosixFilePermission.OTHERS_READ);
        }
        if ((perms & 2) == 2) {
            p.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((perms & 1) == 1) {
            p.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return p;
    }

    public static String getOctalPermissions(Collection<PosixFilePermission> perms) {
        int pf = 0;
        for (PosixFilePermission p : perms) {
            switch (p) {
                case OWNER_READ: {
                    pf |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    pf |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    pf |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    pf |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    pf |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    pf |= 8;
                    break;
                }
                case OTHERS_READ: {
                    pf |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    pf |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    pf |= 1;
                    break;
                }
            }
        }
        return String.format("%04o", pf);
    }

    public static String getFileSystemIdentifier(URI uri) {
        String userInfo = ValidateUtils.checkNotNullAndNotEmpty((String)uri.getUserInfo(), (String)"UserInfo not provided");
        Object[] ui = GenericUtils.split((String)userInfo, (char)':');
        ValidateUtils.checkTrue((GenericUtils.length((Object[])ui) == 2 ? 1 : 0) != 0, (String)"Invalid user info: %s", (Object)userInfo);
        return SftpFileSystemProvider.getFileSystemIdentifier(uri.getHost(), uri.getPort(), (String)ui[0]);
    }

    public static String getFileSystemIdentifier(ClientSession session) {
        IoSession ioSession = session.getIoSession();
        SocketAddress addr = ioSession.getRemoteAddress();
        String username = session.getUsername();
        if (addr instanceof InetSocketAddress) {
            InetSocketAddress inetAddr = (InetSocketAddress)addr;
            return SftpFileSystemProvider.getFileSystemIdentifier(inetAddr.getHostString(), inetAddr.getPort(), username);
        }
        return SftpFileSystemProvider.getFileSystemIdentifier(addr.toString(), 22, username);
    }

    public static String getFileSystemIdentifier(String host, int port, String username) {
        return GenericUtils.trimToEmpty((String)host) + ':' + SshConstants.TO_EFFECTIVE_PORT.applyAsInt(port) + ':' + GenericUtils.trimToEmpty((String)username);
    }

    public static URI createFileSystemURI(String host, int port, String username, String password) {
        return SftpFileSystemProvider.createFileSystemURI(host, port, username, password, Collections.emptyMap());
    }

    public static URI createFileSystemURI(String host, int port, String username, String password, Map<String, ?> params) {
        ValidateUtils.checkNotNullAndNotEmpty((String)host, (String)"No host provided");
        String queryPart = null;
        int numParams = MapEntryUtils.size(params);
        if (numParams > 0) {
            StringBuilder sb = new StringBuilder(numParams * 16);
            for (Map.Entry<String, ?> pe : params.entrySet()) {
                String key = pe.getKey();
                Object value = pe.getValue();
                if (sb.length() > 0) {
                    sb.append('&');
                }
                sb.append(key);
                if (value == null) continue;
                sb.append('=').append(Objects.toString(value, null));
            }
            queryPart = sb.toString();
        }
        try {
            String userAuth = SftpFileSystemProvider.encodeCredentials(username, password);
            return new URI("sftp", userAuth, host, port, "/", queryPart, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed (" + e.getClass().getSimpleName() + ") to create access URI: " + e.getMessage(), e);
        }
    }

    public static String encodeCredentials(String username, String password) {
        ValidateUtils.checkNotNullAndNotEmpty((String)username, (String)"No username provided");
        ValidateUtils.checkTrue((username.indexOf(58) < 0 && (password == null || password.indexOf(58) < 0) ? 1 : 0) != 0, (String)"Reserved character used in credentials");
        if (password == null) {
            return username;
        }
        return username + ":" + password;
    }
}

