/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.dnd.parts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.dnd.DelegatingDropAdapter;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.DelegatingDropTargetAdapter;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.DropTargetContext;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

public class DiagramViewerDropAdapter
extends DelegatingDropAdapter {
    private final IDiagramWorkbenchPart workbenchPart;
    private DelegatingDropTargetAdapter internalDropAdapter;

    public DiagramViewerDropAdapter(IDiagramWorkbenchPart workbenchPart) {
        Assert.isNotNull((Object)workbenchPart);
        this.workbenchPart = workbenchPart;
    }

    public Transfer[] getTransfers() {
        if (this.getInternalDropAdapter() == null) {
            return super.getTransfers();
        }
        Transfer[] allTransferAgents = this.getInternalDropAdapter().getAllTransferAgents();
        Transfer[] superTransferTypes = super.getTransfers();
        List<Transfer> myTransfers = null;
        List<Transfer> superTransfers = null;
        if (allTransferAgents != null) {
            myTransfers = Arrays.asList(allTransferAgents);
        }
        if (superTransferTypes != null) {
            superTransfers = Arrays.asList(superTransferTypes);
        }
        ArrayList<Transfer> allTransfers = new ArrayList<Transfer>();
        if (superTransfers != null) {
            allTransfers.addAll(superTransfers);
        }
        if (myTransfers != null) {
            allTransfers.addAll(myTransfers);
        }
        Transfer[] arrTransfers = new Transfer[allTransfers.size()];
        arrTransfers = allTransfers.toArray(arrTransfers);
        return arrTransfers;
    }

    private DelegatingDropTargetAdapter getInternalDropAdapter() {
        return this.internalDropAdapter;
    }

    protected final void initialize(Control control) {
        if (this.internalDropAdapter == null) {
            Assert.isNotNull((Object)control);
            DiagramViewerDropTargetContext context = new DiagramViewerDropTargetContext((IWorkbenchPart)this.getWorkbenchPart(), control);
            this.internalDropAdapter = new DelegatingDropTargetAdapter((DropTargetContext)context);
        }
    }

    public void dragEnter(DropTargetEvent event) {
        this.getInternalDropAdapter().dragEnter(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.getInternalDropAdapter().dragLeave(event);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.getInternalDropAdapter().dragOperationChanged(event);
    }

    public void dragOver(DropTargetEvent event) {
        this.getInternalDropAdapter().dragOver(event);
    }

    public void drop(DropTargetEvent event) {
        this.getInternalDropAdapter().drop(event);
    }

    public void dropAccept(DropTargetEvent event) {
        this.getInternalDropAdapter().dropAccept(event);
    }

    private IDiagramWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    public boolean isEmpty() {
        Transfer[] transfers = this.getTransfers();
        return transfers == null || transfers.length <= 0;
    }

    protected final boolean isInitialized() {
        return this.getInternalDropAdapter() != null;
    }

    private final class DiagramViewerDropTargetContext
    extends DropTargetContext {
        public DiagramViewerDropTargetContext(IWorkbenchPart activePart, Control viewerControl) {
            super(activePart, viewerControl);
        }

        protected void dragEnter(DropTargetEvent event) {
            DiagramViewerDropAdapter.super.dragEnter(event);
        }

        protected void dragLeave(DropTargetEvent event) {
            DiagramViewerDropAdapter.super.dragLeave(event);
        }

        protected void dragOperationChanged(DropTargetEvent event) {
            DiagramViewerDropAdapter.super.dragOperationChanged(event);
        }

        protected void dragOver(DropTargetEvent event) {
            DiagramViewerDropAdapter.super.dragOver(event);
        }

        protected void drop(DropTargetEvent event) {
            DiagramViewerDropAdapter.super.drop(event);
        }

        protected void dropAccept(DropTargetEvent event) {
            DiagramViewerDropAdapter.super.dropAccept(event);
        }

        protected void setCurrentTargetAndLocation(DropTargetEvent event) {
            this.location = this.getViewerControl().toControl(new org.eclipse.swt.graphics.Point(event.x, event.y));
            Point gefPoint = new Point(this.location.x, this.location.y);
            this.target = DiagramViewerDropAdapter.this.getWorkbenchPart().getDiagramGraphicalViewer().findObjectAt(gefPoint);
            this.relativeLocation = 4;
        }
    }
}

