/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.dialogs;

import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import org.eclipse.gmf.runtime.diagram.ui.internal.dialogs.PageSetupControlType;
import org.eclipse.gmf.runtime.diagram.ui.internal.dialogs.PageSetupDialog;
import org.eclipse.gmf.runtime.diagram.ui.internal.dialogs.StringValidator;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.DefaultValues;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.ILabels;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageSetupPageType;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageSetupWidgetFactory;
import org.eclipse.gmf.runtime.diagram.ui.preferences.PrintingPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class PageSetupConfigBlock
implements ILabels {
    private Button fButtonPortrait;
    private Button fButtonLandscape;
    private Button fButtonInches;
    private Button fButtonMillimetres;
    private Label fLabelSize;
    private Label fLabelWidth;
    private Label fLabelUnitWidth;
    private Label fLabelHeight;
    private Label fLabelMarginTop;
    private Label fLabelUnitMarginTop;
    private Label fLabelMarginBottom;
    private Label fLabelMarginLeft;
    private Label fLabelUnitMarginLeft;
    private Label fLabelMarginRight;
    private Combo fComboSize;
    private Text fTextWidth;
    private Text fTextHeight;
    private Text fTextMarginTop;
    private Text fTextMarginBottom;
    private Text fTextMarginLeft;
    private Text fTextMarginRight;
    private Initializer fInitialier;
    private Persistor fPersistor;
    private Convertor fConvertor;
    private PageSetupDialog fParentDialog;
    private PrintingPreferencePage fPreferencePage;
    private ArrayList fControls = new ArrayList();
    private IPreferenceStore fStore;
    private String fCurrentUnit;
    private NumberFormat fNumberFormat;

    public PageSetupConfigBlock(IPreferenceStore store) {
        this.fInitialier = new Initializer(this);
        this.fPersistor = new Persistor(this);
        this.fConvertor = new Convertor(this);
        this.fStore = store;
        this.fNumberFormat = NumberFormat.getNumberInstance();
    }

    public PageSetupConfigBlock(IPreferenceStore store, PageSetupDialog parentDialog) {
        this(store);
        this.fParentDialog = parentDialog;
    }

    public PageSetupConfigBlock(IPreferenceStore store, PrintingPreferencePage preferencePage) {
        this(store);
        this.fPreferencePage = preferencePage;
    }

    public Control createContents(Composite parent) {
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayoutData((Object)new GridData(1808));
        Composite pageSetupComposite = this.createPageSetupTabContent((Composite)folder);
        TabItem item = new TabItem(folder, 0);
        item.setText(LABEL_TITLE_PAGE_SETUP_TAB_ITEM);
        item.setControl((Control)pageSetupComposite);
        this.fInitialier.initPrintControls();
        return folder;
    }

    public void save() {
        this.fPersistor.saveConfigBlockControlValues();
    }

    public void performDefaults() {
        this.fButtonInches.setSelection(DefaultValues.DEFAULT_INCHES);
        this.fButtonInches.setEnabled(true);
        this.fButtonMillimetres.setSelection(DefaultValues.DEFAULT_MILLIM);
        this.fButtonMillimetres.setEnabled(true);
        this.fButtonPortrait.setSelection(DefaultValues.DEFAULT_PORTRAIT);
        this.fButtonLandscape.setSelection(DefaultValues.DEFAULT_LANDSCAPE);
        this.fComboSize.select(DefaultValues.getLocaleSpecificPageType().getIndex());
        this.fTextWidth.setText(this.fNumberFormat.format(DefaultValues.getLocaleSpecificPageType().getWidth()));
        this.fTextHeight.setText(this.fNumberFormat.format(DefaultValues.getLocaleSpecificPageType().getHeight()));
        this.fTextMarginTop.setText(this.fNumberFormat.format(DefaultValues.DEFAULT_MARGIN_TOP));
        this.fTextMarginBottom.setText(this.fNumberFormat.format(DefaultValues.DEFAULT_MARGIN_BOTTOM));
        this.fTextMarginLeft.setText(this.fNumberFormat.format(DefaultValues.DEFAULT_MARGIN_LEFT));
        this.fTextMarginRight.setText(this.fNumberFormat.format(DefaultValues.DEFAULT_MARGIN_RIGHT));
        this.fPreferencePage.setErrorMessage(null);
    }

    private Composite createPageSetupTabContent(Composite folder) {
        Composite composite = new Composite(folder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createGroupPageOrientation(composite);
        this.createGroupUnits(composite);
        this.createGroupPaperSize(composite);
        this.createGroupMargin(composite);
        return composite;
    }

    private void createGroupPageOrientation(Composite composite) {
        Group group = PageSetupWidgetFactory.createGroup(composite, LABEL_TITLE_GROUP_ORIENTATION);
        this.fButtonPortrait = PageSetupWidgetFactory.createRadioButton((Composite)group, LABEL_BUTTON_PORTRAIT);
        this.fButtonLandscape = PageSetupWidgetFactory.createRadioButton((Composite)group, LABEL_BUTTON_LANDSCAPE);
        this.fControls.add(this.fButtonPortrait);
        this.fControls.add(this.fButtonLandscape);
    }

    private void createGroupUnits(Composite composite) {
        Group group = PageSetupWidgetFactory.createGroup(composite, LABEL_TITLE_GROUP_UNITS);
        this.fButtonInches = PageSetupWidgetFactory.createRadioButtonInches((Composite)group, LABEL_BUTTON_INCHES);
        this.fButtonMillimetres = PageSetupWidgetFactory.createRadioButtonMillim((Composite)group, LABEL_BUTTON_MILLIMETRES);
        this.fButtonInches.addSelectionListener((SelectionListener)new InchesSelectionListener(LABEL_INCHES));
        this.fButtonMillimetres.addSelectionListener((SelectionListener)new MillimetresSelectionListener(LABEL_MILLIMETRES));
        this.fControls.add(this.fButtonInches);
        this.fControls.add(this.fButtonMillimetres);
    }

    private void createGroupPaperSize(Composite composite) {
        Group group = PageSetupWidgetFactory.createGroupPaperSize(composite, LABEL_TITLE_GROUP_PAPER_SIZE);
        this.fLabelSize = PageSetupWidgetFactory.createLabel(group, LABEL_PAGE_SIZE);
        this.fComboSize = PageSetupWidgetFactory.createComboSize(group);
        this.fLabelWidth = PageSetupWidgetFactory.createLabel(group, LABEL_PAGE_WIDTH_INCHES);
        this.fTextWidth = PageSetupWidgetFactory.createTextWidth(group);
        this.fLabelUnitWidth = PageSetupWidgetFactory.createLabelFiller(group);
        this.fLabelHeight = PageSetupWidgetFactory.createLabel(group, LABEL_PAGE_HEIGHT_INCHES);
        this.fTextHeight = PageSetupWidgetFactory.createTextHeight(group);
        this.fComboSize.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = PageSetupConfigBlock.this.fComboSize.getSelectionIndex();
                if (PageSetupConfigBlock.this.isConversionNeeded()) {
                    PageSetupConfigBlock.this.fTextHeight.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertInchesToMilim(PageSetupPageType.pages[index].getHeight())));
                    PageSetupConfigBlock.this.fTextWidth.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertInchesToMilim(PageSetupPageType.pages[index].getWidth())));
                } else {
                    PageSetupConfigBlock.this.fTextHeight.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupPageType.pages[index].getHeight()));
                    PageSetupConfigBlock.this.fTextWidth.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupPageType.pages[index].getWidth()));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fTextWidth.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PageSetupConfigBlock.this.fTextWidth.isFocusControl()) {
                    PageSetupConfigBlock.this.fComboSize.select(PageSetupPageType.USER_DEFINED.getIndex());
                    PageSetupConfigBlock.this.setOkButtonEnableStatus();
                } else if (PageSetupConfigBlock.this.fComboSize.isFocusControl()) {
                    PageSetupConfigBlock.this.setOkButtonEnableStatus();
                }
            }
        });
        this.fTextHeight.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PageSetupConfigBlock.this.fTextHeight.isFocusControl()) {
                    PageSetupConfigBlock.this.fComboSize.select(PageSetupPageType.USER_DEFINED.getIndex());
                    PageSetupConfigBlock.this.setOkButtonEnableStatus();
                } else if (PageSetupConfigBlock.this.fComboSize.isFocusControl()) {
                    PageSetupConfigBlock.this.setOkButtonEnableStatus();
                }
            }
        });
        this.fControls.add(this.fLabelSize);
        this.fControls.add(this.fComboSize);
        this.fControls.add(this.fLabelWidth);
        this.fControls.add(this.fTextWidth);
        this.fControls.add(this.fLabelUnitWidth);
        this.fControls.add(this.fLabelHeight);
        this.fControls.add(this.fTextHeight);
    }

    private double getDblFromString(String strNum) {
        try {
            Number num = null;
            num = this.fNumberFormat.parse(strNum);
            return num.doubleValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    public void setOkButtonEnableStatus() {
        boolean allValid = StringValidator.isValid(this.fTextWidth.getText()) && StringValidator.isValid(this.fTextHeight.getText()) && StringValidator.isValid(this.fTextMarginTop.getText()) && StringValidator.isValid(this.fTextMarginBottom.getText()) && StringValidator.isValid(this.fTextMarginLeft.getText()) && StringValidator.isValid(this.fTextMarginRight.getText());
        boolean marginsValid = false;
        if (allValid) {
            if (this.fButtonPortrait.getSelection()) {
                marginsValid = this.getDblFromString(this.fTextMarginTop.getText()) + this.getDblFromString(this.fTextMarginBottom.getText()) < this.getDblFromString(this.fTextHeight.getText()) && this.getDblFromString(this.fTextMarginLeft.getText()) + this.getDblFromString(this.fTextMarginRight.getText()) < this.getDblFromString(this.fTextWidth.getText());
            } else {
                boolean bl = marginsValid = this.getDblFromString(this.fTextMarginTop.getText()) + this.getDblFromString(this.fTextMarginBottom.getText()) < this.getDblFromString(this.fTextWidth.getText()) && this.getDblFromString(this.fTextMarginLeft.getText()) + this.getDblFromString(this.fTextMarginRight.getText()) < this.getDblFromString(this.fTextHeight.getText());
            }
        }
        if (this.fPreferencePage == null) {
            if (allValid && marginsValid) {
                this.fParentDialog.getOkButton().setEnabled(true);
                this.fButtonInches.setEnabled(true);
                this.fButtonMillimetres.setEnabled(true);
            } else {
                this.fParentDialog.getOkButton().setEnabled(false);
                this.fButtonInches.setEnabled(false);
                this.fButtonMillimetres.setEnabled(false);
            }
        } else if (allValid && marginsValid) {
            this.fPreferencePage.setValid(true);
            this.fPreferencePage.setErrorMessage(null);
            this.fButtonInches.setEnabled(true);
            this.fButtonMillimetres.setEnabled(true);
        } else {
            this.fPreferencePage.setValid(false);
            this.fPreferencePage.setErrorMessage(LABEL_PRINT_PREFERENCE_PAGE_ERROR_MSG);
            this.fButtonInches.setEnabled(false);
            this.fButtonMillimetres.setEnabled(false);
        }
    }

    private boolean isUnitsInInch() {
        return this.fCurrentUnit.startsWith("inc");
    }

    private void createGroupMargin(Composite composite) {
        Group group = PageSetupWidgetFactory.createGroupMargin(composite, LABEL_TITLE_GROUP_MARGIN);
        this.fLabelMarginTop = PageSetupWidgetFactory.createLabel(group, LABEL_MARGIN_TOP_INCHES);
        this.fTextMarginTop = PageSetupWidgetFactory.createTextMargin(group);
        this.fLabelUnitMarginTop = PageSetupWidgetFactory.createLabelFiller(group);
        this.fLabelMarginBottom = PageSetupWidgetFactory.createLabel(group, LABEL_MARGIN_BOTTOM_INCHES);
        this.fTextMarginBottom = PageSetupWidgetFactory.createTextMargin(group);
        this.fLabelMarginLeft = PageSetupWidgetFactory.createLabel(group, LABEL_MARGIN_LEFT_INCHES);
        this.fTextMarginLeft = PageSetupWidgetFactory.createTextMargin(group);
        this.fLabelUnitMarginLeft = PageSetupWidgetFactory.createLabelFiller(group);
        this.fLabelMarginRight = PageSetupWidgetFactory.createLabel(group, LABEL_MARGIN_RIGHT_INCHES);
        this.fTextMarginRight = PageSetupWidgetFactory.createTextMargin(group);
        this.fTextMarginTop.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                double marginTop = PageSetupConfigBlock.this.getDblFromString(PageSetupConfigBlock.this.fTextMarginTop.getText());
                double minimumTop = DefaultValues.MINIMUM_MARGIN_TOP;
                if (!PageSetupConfigBlock.this.isUnitsInInch()) {
                    marginTop = PageSetupConfigBlock.this.fConvertor.convertMilimToInches(marginTop);
                    minimumTop = PageSetupConfigBlock.this.fConvertor.convertInchesToMilim(minimumTop);
                }
                if (marginTop < DefaultValues.MINIMUM_MARGIN_TOP) {
                    PageSetupConfigBlock.this.fTextMarginTop.setText(PageSetupConfigBlock.this.fNumberFormat.format(minimumTop));
                }
            }
        });
        this.fTextMarginTop.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PageSetupConfigBlock.this.fTextMarginTop.isFocusControl()) {
                    PageSetupConfigBlock.this.setOkButtonEnableStatus();
                }
            }
        });
        this.fTextMarginBottom.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                double marginBottom = PageSetupConfigBlock.this.getDblFromString(PageSetupConfigBlock.this.fTextMarginBottom.getText());
                double minimumBottom = DefaultValues.MINIMUM_MARGIN_BOTTOM;
                if (!PageSetupConfigBlock.this.isUnitsInInch()) {
                    marginBottom = PageSetupConfigBlock.this.fConvertor.convertMilimToInches(marginBottom);
                    minimumBottom = PageSetupConfigBlock.this.fConvertor.convertInchesToMilim(minimumBottom);
                }
                if (marginBottom < DefaultValues.MINIMUM_MARGIN_BOTTOM) {
                    PageSetupConfigBlock.this.fTextMarginBottom.setText(PageSetupConfigBlock.this.fNumberFormat.format(minimumBottom));
                }
            }
        });
        this.fTextMarginBottom.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PageSetupConfigBlock.this.fTextMarginBottom.isFocusControl()) {
                    PageSetupConfigBlock.this.setOkButtonEnableStatus();
                }
            }
        });
        this.fTextMarginLeft.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                double marginLeft = PageSetupConfigBlock.this.getDblFromString(PageSetupConfigBlock.this.fTextMarginLeft.getText());
                double minimumLeft = DefaultValues.MINIMUM_MARGIN_LEFT;
                if (!PageSetupConfigBlock.this.isUnitsInInch()) {
                    marginLeft = PageSetupConfigBlock.this.fConvertor.convertMilimToInches(marginLeft);
                    minimumLeft = PageSetupConfigBlock.this.fConvertor.convertInchesToMilim(minimumLeft);
                }
                if (marginLeft < DefaultValues.MINIMUM_MARGIN_LEFT) {
                    PageSetupConfigBlock.this.fTextMarginLeft.setText(PageSetupConfigBlock.this.fNumberFormat.format(minimumLeft));
                }
            }
        });
        this.fTextMarginLeft.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PageSetupConfigBlock.this.fTextMarginLeft.isFocusControl()) {
                    PageSetupConfigBlock.this.setOkButtonEnableStatus();
                }
            }
        });
        this.fTextMarginRight.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                double marginRight = PageSetupConfigBlock.this.getDblFromString(PageSetupConfigBlock.this.fTextMarginRight.getText());
                double minimumRight = DefaultValues.MINIMUM_MARGIN_RIGHT;
                if (!PageSetupConfigBlock.this.isUnitsInInch()) {
                    marginRight = PageSetupConfigBlock.this.fConvertor.convertMilimToInches(marginRight);
                    minimumRight = PageSetupConfigBlock.this.fConvertor.convertInchesToMilim(minimumRight);
                }
                if (marginRight < DefaultValues.MINIMUM_MARGIN_RIGHT) {
                    PageSetupConfigBlock.this.fTextMarginRight.setText(PageSetupConfigBlock.this.fNumberFormat.format(minimumRight));
                }
            }
        });
        this.fTextMarginRight.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PageSetupConfigBlock.this.fTextMarginRight.isFocusControl()) {
                    PageSetupConfigBlock.this.setOkButtonEnableStatus();
                }
            }
        });
        this.fControls.add(this.fLabelMarginTop);
        this.fControls.add(this.fTextMarginTop);
        this.fControls.add(this.fLabelUnitMarginTop);
        this.fControls.add(this.fLabelMarginBottom);
        this.fControls.add(this.fTextMarginBottom);
        this.fControls.add(this.fLabelMarginLeft);
        this.fControls.add(this.fTextMarginLeft);
        this.fControls.add(this.fLabelUnitMarginLeft);
        this.fControls.add(this.fLabelMarginRight);
        this.fControls.add(this.fTextMarginRight);
    }

    public Control getControl(PageSetupControlType controlType) {
        if (controlType.equals(PageSetupControlType.BUTTON_USE_INCHES)) {
            return this.fButtonInches;
        }
        if (controlType.equals(PageSetupControlType.BUTTON_USE_MILLIM)) {
            return this.fButtonMillimetres;
        }
        if (controlType.equals(PageSetupControlType.BUTTON_USE_PORTRAIT)) {
            return this.fButtonPortrait;
        }
        if (controlType.equals(PageSetupControlType.BUTTON_USE_LANDSCAPE)) {
            return this.fButtonLandscape;
        }
        if (controlType.equals(PageSetupControlType.COMBO_PAGE_SIZE)) {
            return this.fComboSize;
        }
        if (controlType.equals(PageSetupControlType.TEXT_PAGE_HEIGHT)) {
            return this.fTextHeight;
        }
        if (controlType.equals(PageSetupControlType.TEXT_PAGE_WIDTH)) {
            return this.fTextWidth;
        }
        if (controlType.equals(PageSetupControlType.TEXT_MARGIN_TOP)) {
            return this.fTextMarginTop;
        }
        if (controlType.equals(PageSetupControlType.TEXT_MARGIN_BOTTOM)) {
            return this.fTextMarginBottom;
        }
        if (controlType.equals(PageSetupControlType.TEXT_MARGIN_LEFT)) {
            return this.fTextMarginLeft;
        }
        if (controlType.equals(PageSetupControlType.TEXT_MARGIN_RIGHT)) {
            return this.fTextMarginRight;
        }
        if (controlType.equals(PageSetupControlType.LABEL_UNIT_PAGE_HEIGHT)) {
            return this.fLabelUnitWidth;
        }
        if (controlType.equals(PageSetupControlType.LABEL_UNIT_MARGIN_TOP)) {
            return this.fLabelUnitMarginTop;
        }
        if (controlType.equals(PageSetupControlType.LABEL_UNIT_MARGIN_LEFT)) {
            return this.fLabelUnitMarginLeft;
        }
        return null;
    }

    public void disableAllControls() {
        int i = 0;
        while (i < this.fControls.size()) {
            Control control = (Control)this.fControls.get(i);
            control.setEnabled(false);
            ++i;
        }
    }

    public void enableAllControls() {
        int i = 0;
        while (i < this.fControls.size()) {
            Control control = (Control)this.fControls.get(i);
            control.setEnabled(true);
            ++i;
        }
    }

    private boolean isConversionNeeded() {
        return !this.fButtonInches.getSelection();
    }

    private class Convertor {
        PageSetupConfigBlock fBlockPrint;

        public Convertor(PageSetupConfigBlock configBlock) {
            this.fBlockPrint = configBlock;
        }

        public double convertToInches(PageSetupControlType type) {
            Text text = (Text)this.fBlockPrint.getControl(type);
            Number num = null;
            try {
                num = PageSetupConfigBlock.this.fNumberFormat.parse(text.getText());
                double valueInMillimetres = num.doubleValue();
                double valueInInches = this.convertMilimToInches(valueInMillimetres);
                return valueInInches;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return -1.0;
            }
        }

        public double convertToMillimetres(PageSetupControlType type) {
            Text text = (Text)this.fBlockPrint.getControl(type);
            Number num = null;
            try {
                num = PageSetupConfigBlock.this.fNumberFormat.parse(text.getText());
                double valueInInches = num.doubleValue();
                double valueInMillimetres = this.convertInchesToMilim(valueInInches);
                return valueInMillimetres;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return -1.0;
            }
        }

        public double convertInchesToMilim(double inches) {
            return inches * 25.4;
        }

        public double convertMilimToInches(double milim) {
            return milim / 25.4;
        }
    }

    private class InchesSelectionListener
    extends UnitSelectionListener {
        public InchesSelectionListener(String label) {
            super(label);
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            if (b.getSelection()) {
                super.widgetSelected(e);
                if (PageSetupConfigBlock.this.fCurrentUnit.startsWith("mil")) {
                    this.convertValuesToInches();
                    PageSetupConfigBlock.this.fCurrentUnit = "inc";
                }
            }
        }

        private void convertValuesToInches() {
            PageSetupConfigBlock.this.fTextWidth.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertToInches(PageSetupControlType.TEXT_PAGE_WIDTH)));
            PageSetupConfigBlock.this.fTextHeight.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertToInches(PageSetupControlType.TEXT_PAGE_HEIGHT)));
            PageSetupConfigBlock.this.fTextMarginTop.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertToInches(PageSetupControlType.TEXT_MARGIN_TOP)));
            PageSetupConfigBlock.this.fTextMarginBottom.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertToInches(PageSetupControlType.TEXT_MARGIN_BOTTOM)));
            PageSetupConfigBlock.this.fTextMarginLeft.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertToInches(PageSetupControlType.TEXT_MARGIN_LEFT)));
            PageSetupConfigBlock.this.fTextMarginRight.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertToInches(PageSetupControlType.TEXT_MARGIN_RIGHT)));
        }
    }

    private class Initializer {
        private PageSetupConfigBlock fBlockPrint;

        public Initializer(PageSetupConfigBlock configBlock) {
            this.fBlockPrint = configBlock;
        }

        public void initPrintControls() {
            this.initValuesForUnitGroup();
            this.initValuesForOrientationGroup();
            this.initValuesForSizeGroup();
            this.initValuesForMarginGroup();
            this.initUnitLabels();
        }

        private void initValuesForUnitGroup() {
            this.initRadioButton(this.fBlockPrint, PageSetupControlType.BUTTON_USE_INCHES, "print.useInches");
            this.initRadioButton(this.fBlockPrint, PageSetupControlType.BUTTON_USE_MILLIM, "print.useMillim");
        }

        private void initValuesForOrientationGroup() {
            this.initRadioButton(this.fBlockPrint, PageSetupControlType.BUTTON_USE_PORTRAIT, "print.usePortrait");
            this.initRadioButton(this.fBlockPrint, PageSetupControlType.BUTTON_USE_LANDSCAPE, "print.useLandscape");
        }

        private void initValuesForSizeGroup() {
            this.initCombo(this.fBlockPrint, PageSetupControlType.COMBO_PAGE_SIZE, "print.page.size");
            this.initText(this.fBlockPrint, PageSetupControlType.TEXT_PAGE_HEIGHT, "print.page.height");
            this.initText(this.fBlockPrint, PageSetupControlType.TEXT_PAGE_WIDTH, "print.page.width");
        }

        private void initValuesForMarginGroup() {
            this.initText(this.fBlockPrint, PageSetupControlType.TEXT_MARGIN_TOP, "print.margin.top");
            this.initText(this.fBlockPrint, PageSetupControlType.TEXT_MARGIN_BOTTOM, "print.margin.bottom");
            this.initText(this.fBlockPrint, PageSetupControlType.TEXT_MARGIN_LEFT, "print.margin.left");
            this.initText(this.fBlockPrint, PageSetupControlType.TEXT_MARGIN_RIGHT, "print.margin.right");
        }

        private void initUnitLabels() {
            if (PageSetupConfigBlock.this.fButtonInches.getSelection()) {
                PageSetupConfigBlock.this.fLabelHeight.setText(LABEL_PAGE_HEIGHT_INCHES);
                PageSetupConfigBlock.this.fLabelWidth.setText(LABEL_PAGE_WIDTH_INCHES);
                PageSetupConfigBlock.this.fLabelMarginBottom.setText(LABEL_MARGIN_BOTTOM_INCHES);
                PageSetupConfigBlock.this.fLabelMarginLeft.setText(LABEL_MARGIN_LEFT_INCHES);
                PageSetupConfigBlock.this.fLabelMarginRight.setText(LABEL_MARGIN_RIGHT_INCHES);
                PageSetupConfigBlock.this.fLabelMarginTop.setText(LABEL_MARGIN_TOP_INCHES);
                PageSetupConfigBlock.this.fCurrentUnit = "inc";
            } else {
                PageSetupConfigBlock.this.fLabelHeight.setText(LABEL_PAGE_HEIGHT_MM);
                PageSetupConfigBlock.this.fLabelWidth.setText(LABEL_PAGE_WIDTH_MM);
                PageSetupConfigBlock.this.fLabelMarginBottom.setText(LABEL_MARGIN_BOTTOM_MM);
                PageSetupConfigBlock.this.fLabelMarginLeft.setText(LABEL_MARGIN_LEFT_MM);
                PageSetupConfigBlock.this.fLabelMarginRight.setText(LABEL_MARGIN_RIGHT_MM);
                PageSetupConfigBlock.this.fLabelMarginTop.setText(LABEL_MARGIN_TOP_MM);
                PageSetupConfigBlock.this.fCurrentUnit = "mil";
            }
        }

        private void initRadioButton(PageSetupConfigBlock block, PageSetupControlType controlType, String key) {
            Button button = (Button)block.getControl(controlType);
            button.setSelection(PageSetupConfigBlock.this.fStore.getBoolean(key));
        }

        private void initText(PageSetupConfigBlock block, PageSetupControlType controlType, String key) {
            Text text = (Text)block.getControl(controlType);
            double value = PageSetupConfigBlock.this.fStore.getDouble(key);
            text.setText(PageSetupConfigBlock.this.fNumberFormat.format(value));
            if (PageSetupConfigBlock.this.isConversionNeeded()) {
                if (this.fBlockPrint.fComboSize.getSelectionIndex() != PageSetupPageType.USER_DEFINED.getIndex()) {
                    if (text == this.fBlockPrint.fTextHeight) {
                        this.fBlockPrint.fTextHeight.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertInchesToMilim(PageSetupPageType.pages[this.fBlockPrint.fComboSize.getSelectionIndex()].getHeight())));
                    } else if (text == this.fBlockPrint.fTextWidth) {
                        this.fBlockPrint.fTextWidth.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertInchesToMilim(PageSetupPageType.pages[this.fBlockPrint.fComboSize.getSelectionIndex()].getWidth())));
                    } else {
                        text.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertInchesToMilim(value)));
                    }
                } else {
                    text.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertInchesToMilim(value)));
                }
            }
        }

        private void initCombo(PageSetupConfigBlock block, PageSetupControlType controlType, String key) {
            Combo combo = (Combo)block.getControl(controlType);
            String pageSize = PageSetupConfigBlock.this.fStore.getString(key);
            int i = 0;
            while (i < combo.getItemCount()) {
                String item = combo.getItem(i);
                if (item.startsWith(pageSize)) {
                    combo.select(i);
                }
                ++i;
            }
        }
    }

    private class MillimetresSelectionListener
    extends UnitSelectionListener {
        public MillimetresSelectionListener(String label) {
            super(label);
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            if (b.getSelection()) {
                super.widgetSelected(e);
                if (PageSetupConfigBlock.this.isUnitsInInch()) {
                    this.convertValuesToMillimetres();
                    PageSetupConfigBlock.this.fCurrentUnit = "mil";
                }
            }
        }

        private void convertValuesToMillimetres() {
            if (PageSetupConfigBlock.this.fComboSize.getSelectionIndex() == PageSetupPageType.USER_DEFINED.getIndex()) {
                PageSetupConfigBlock.this.fTextWidth.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertToMillimetres(PageSetupControlType.TEXT_PAGE_WIDTH)));
                PageSetupConfigBlock.this.fTextHeight.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertToMillimetres(PageSetupControlType.TEXT_PAGE_HEIGHT)));
            } else {
                PageSetupConfigBlock.this.fTextWidth.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertInchesToMilim(PageSetupPageType.pages[PageSetupConfigBlock.this.fComboSize.getSelectionIndex()].getWidth())));
                PageSetupConfigBlock.this.fTextHeight.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertInchesToMilim(PageSetupPageType.pages[PageSetupConfigBlock.this.fComboSize.getSelectionIndex()].getHeight())));
            }
            PageSetupConfigBlock.this.fTextMarginTop.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertToMillimetres(PageSetupControlType.TEXT_MARGIN_TOP)));
            PageSetupConfigBlock.this.fTextMarginBottom.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertToMillimetres(PageSetupControlType.TEXT_MARGIN_BOTTOM)));
            PageSetupConfigBlock.this.fTextMarginLeft.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertToMillimetres(PageSetupControlType.TEXT_MARGIN_LEFT)));
            PageSetupConfigBlock.this.fTextMarginRight.setText(PageSetupConfigBlock.this.fNumberFormat.format(PageSetupConfigBlock.this.fConvertor.convertToMillimetres(PageSetupControlType.TEXT_MARGIN_RIGHT)));
        }
    }

    private class Persistor {
        private PageSetupConfigBlock fBlockPrint;

        public Persistor(PageSetupConfigBlock configBlock) {
            this.fBlockPrint = configBlock;
        }

        public void saveConfigBlockControlValues() {
            this.saveValuesFromUnitGroup();
            this.saveValuesFromOrientationGroup();
            this.saveValuesFromSizeGroup();
            this.saveValuesFromMarginGroup();
            this.emptyControlList();
        }

        private void saveValuesFromUnitGroup() {
            this.saveRadioButton(this.fBlockPrint, PageSetupControlType.BUTTON_USE_INCHES, "print.useInches");
            this.saveRadioButton(this.fBlockPrint, PageSetupControlType.BUTTON_USE_MILLIM, "print.useMillim");
        }

        private void saveValuesFromOrientationGroup() {
            this.saveRadioButton(this.fBlockPrint, PageSetupControlType.BUTTON_USE_PORTRAIT, "print.usePortrait");
            this.saveRadioButton(this.fBlockPrint, PageSetupControlType.BUTTON_USE_LANDSCAPE, "print.useLandscape");
        }

        private void saveValuesFromSizeGroup() {
            this.saveCombo(this.fBlockPrint, PageSetupControlType.COMBO_PAGE_SIZE, "print.page.size");
            this.saveText(this.fBlockPrint, PageSetupControlType.TEXT_PAGE_HEIGHT, "print.page.height");
            this.saveText(this.fBlockPrint, PageSetupControlType.TEXT_PAGE_WIDTH, "print.page.width");
        }

        private void saveValuesFromMarginGroup() {
            this.saveText(this.fBlockPrint, PageSetupControlType.TEXT_MARGIN_TOP, "print.margin.top");
            this.saveText(this.fBlockPrint, PageSetupControlType.TEXT_MARGIN_BOTTOM, "print.margin.bottom");
            this.saveText(this.fBlockPrint, PageSetupControlType.TEXT_MARGIN_LEFT, "print.margin.left");
            this.saveText(this.fBlockPrint, PageSetupControlType.TEXT_MARGIN_RIGHT, "print.margin.right");
        }

        private void saveText(PageSetupConfigBlock block, PageSetupControlType controlType, String key) {
            if (PageSetupConfigBlock.this.isConversionNeeded()) {
                PageSetupConfigBlock.this.fStore.setValue(key, PageSetupConfigBlock.this.fConvertor.convertToInches(controlType));
            } else {
                Text text = (Text)block.getControl(controlType);
                PageSetupConfigBlock.this.fStore.setValue(key, PageSetupConfigBlock.this.getDblFromString(text.getText()));
            }
        }

        private void saveRadioButton(PageSetupConfigBlock block, PageSetupControlType controlType, String key) {
            Button button = (Button)block.getControl(controlType);
            PageSetupConfigBlock.this.fStore.setValue(key, button.getSelection());
        }

        private void saveCombo(PageSetupConfigBlock block, PageSetupControlType controlType, String key) {
            Combo combo = (Combo)block.getControl(controlType);
            int index = combo.getSelectionIndex();
            PageSetupConfigBlock.this.fStore.setValue(key, combo.getItem(index));
        }

        private void emptyControlList() {
            int i = 0;
            while (i < PageSetupConfigBlock.this.fControls.size()) {
                PageSetupConfigBlock.this.fControls.remove(i);
                ++i;
            }
        }
    }

    private class UnitSelectionListener
    implements SelectionListener {
        private String fLabel;

        public UnitSelectionListener(String label) {
            this.fLabel = label;
        }

        public void widgetSelected(SelectionEvent e) {
            this.updateLabels();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void updateLabels() {
            if (this.fLabel.equals(LABEL_MILLIMETRES)) {
                PageSetupConfigBlock.this.fLabelHeight.setText(LABEL_PAGE_HEIGHT_MM);
                PageSetupConfigBlock.this.fLabelWidth.setText(LABEL_PAGE_WIDTH_MM);
                PageSetupConfigBlock.this.fLabelMarginBottom.setText(LABEL_MARGIN_BOTTOM_MM);
                PageSetupConfigBlock.this.fLabelMarginLeft.setText(LABEL_MARGIN_LEFT_MM);
                PageSetupConfigBlock.this.fLabelMarginRight.setText(LABEL_MARGIN_RIGHT_MM);
                PageSetupConfigBlock.this.fLabelMarginTop.setText(LABEL_MARGIN_TOP_MM);
            } else {
                PageSetupConfigBlock.this.fLabelHeight.setText(LABEL_PAGE_HEIGHT_INCHES);
                PageSetupConfigBlock.this.fLabelWidth.setText(LABEL_PAGE_WIDTH_INCHES);
                PageSetupConfigBlock.this.fLabelMarginBottom.setText(LABEL_MARGIN_BOTTOM_INCHES);
                PageSetupConfigBlock.this.fLabelMarginLeft.setText(LABEL_MARGIN_LEFT_INCHES);
                PageSetupConfigBlock.this.fLabelMarginRight.setText(LABEL_MARGIN_RIGHT_INCHES);
                PageSetupConfigBlock.this.fLabelMarginTop.setText(LABEL_MARGIN_TOP_INCHES);
            }
            PageSetupConfigBlock.this.fLabelHeight.getParent().layout(true);
            PageSetupConfigBlock.this.fLabelMarginBottom.getParent().layout(true);
            PageSetupConfigBlock.this.fLabelHeight.getShell().pack(true);
        }
    }
}

