/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.item;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ui.tools.api.views.common.item.AnalysisResourceItem;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ViewpointItemImpl;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;

public class AnalysisResourceItemImpl
implements AnalysisResourceItem {
    private static final String SESSION_IMAGE = "icons/obj16/SiriusFile.gif";
    protected final Resource resource;
    private final Session session;
    private final Object parent;
    private boolean linkChildrenToParentMode;

    public AnalysisResourceItemImpl(Session session, Resource resource, Object parent) {
        this.session = session;
        this.resource = resource;
        this.parent = parent;
    }

    @Override
    public Object getWrappedObject() {
        return this.resource;
    }

    public Image getImage() {
        return SiriusEditPlugin.getPlugin().getBundledImage(SESSION_IMAGE);
    }

    public String getText() {
        String result = "";
        if (this.resource.getResourceSet() != null && this.resource.getURI() != null && this.resource.getURI().lastSegment() != null) {
            result = String.valueOf(this.resource.getURI().lastSegment()) + " - [" + this.resource.getURI() + "]";
        } else if (this.resource.getResourceSet() != null && this.resource.getURI() != null) {
            result = this.resource.getURI().toString();
        }
        return result;
    }

    @Override
    public Option<Session> getSession() {
        return Options.newSome((Object)this.session);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (obj instanceof AnalysisResourceItemImpl) {
            AnalysisResourceItemImpl other = (AnalysisResourceItemImpl)obj;
            result = Objects.equal((Object)this.parent, (Object)other.parent) && Objects.equal((Object)this.resource, (Object)other.resource);
        }
        return result;
    }

    public Collection<?> getChildren() {
        ArrayList<ViewpointItemImpl> all = new ArrayList<ViewpointItemImpl>();
        if (this.resource != null) {
            for (Viewpoint viewpoint : this.session.getSelectedViewpoints(false)) {
                all.add(new ViewpointItemImpl(this.session, viewpoint, this.resource, this.linkChildrenToParentMode ? this.parent : this));
            }
            Collections.sort(all);
        }
        return all;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setSpecialMode(boolean linkChildrenToParent) {
        this.linkChildrenToParentMode = linkChildrenToParent;
    }
}

