/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class BranchRebaseModeCombo {
    @NonNull
    private final Label label;
    @NonNull
    private final ComboViewer combo;

    public BranchRebaseModeCombo(Composite parent) {
        this.label = new Label(parent, 0);
        this.label.setText(UIText.BranchRebaseModeCombo_RebaseModeLabel);
        this.combo = new ComboViewer(parent, 12);
        this.combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == BranchConfig.BranchRebaseMode.REBASE) {
                    return UIText.BranchRebaseMode_Rebase;
                }
                if (element == BranchConfig.BranchRebaseMode.PRESERVE) {
                    return UIText.BranchRebaseMode_Preserve;
                }
                if (element == BranchConfig.BranchRebaseMode.INTERACTIVE) {
                    return UIText.BranchRebaseMode_Interactive;
                }
                if (element == BranchConfig.BranchRebaseMode.NONE) {
                    return UIText.BranchRebaseMode_None;
                }
                return "";
            }
        });
        this.combo.setInput((Object)BranchConfig.BranchRebaseMode.values());
    }

    public BranchConfig.BranchRebaseMode getRebaseMode() {
        IStructuredSelection selection = (IStructuredSelection)this.combo.getSelection();
        return selection.isEmpty() ? null : (BranchConfig.BranchRebaseMode)selection.getFirstElement();
    }

    public void setRebaseMode(BranchConfig.BranchRebaseMode mode) {
        if (mode == null) {
            this.combo.setSelection((ISelection)StructuredSelection.EMPTY, false);
        } else {
            this.combo.setSelection((ISelection)new StructuredSelection((Object)mode), true);
        }
    }

    @NonNull
    public Label getLabel() {
        return this.label;
    }

    @NonNull
    public ComboViewer getViewer() {
        return this.combo;
    }

    public void setEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
        this.combo.getCombo().setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.combo.getCombo().isEnabled();
    }
}

