/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.credentials;

import org.eclipse.egit.core.internal.signing.GpgSetup;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.UnsupportedSigningFormatException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgObjectSigner;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public final class SignatureUtils {
    private SignatureUtils() {
    }

    public static boolean checkSigningKey(@NonNull GpgConfig config, @NonNull PersonIdent personIdent) {
        return SignatureUtils.checkSigningKey(GpgSetup.getDefault(), config, personIdent);
    }

    public static boolean checkSigningKey(GpgSigner signer, @NonNull GpgConfig config, @NonNull PersonIdent personIdent) {
        if (signer != null) {
            try {
                CredentialsProvider credentials = new CredentialsProvider(){

                    public boolean supports(CredentialItem ... items) {
                        return true;
                    }

                    public boolean isInteractive() {
                        return false;
                    }

                    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
                        return false;
                    }
                };
                if (signer instanceof GpgObjectSigner) {
                    return ((GpgObjectSigner)signer).canLocateSigningKey(config.getSigningKey(), personIdent, credentials, config);
                }
                return signer.canLocateSigningKey(config.getSigningKey(), personIdent, credentials);
            }
            catch (CanceledException e) {
                return true;
            }
            catch (UnsupportedSigningFormatException e) {
                return false;
            }
        }
        return false;
    }
}

