/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.provider.jena;

import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.datatypes.xsd.impl.XMLLiteralType;
import org.apache.jena.datatypes.xsd.impl.XSDDateType;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.rdf.model.Alt;
import org.apache.jena.rdf.model.Bag;
import org.apache.jena.rdf.model.Container;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RSIterator;
import org.apache.jena.rdf.model.ReifiedStatement;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.rdf.model.SimpleSelector;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.ResourceUtils;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.eclipse.lyo.oslc4j.core.NestedWildcardProperties;
import org.eclipse.lyo.oslc4j.core.OSLC4JConstants;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.OslcGlobalNamespaceProvider;
import org.eclipse.lyo.oslc4j.core.SingletonWildcardProperties;
import org.eclipse.lyo.oslc4j.core.UnparseableLiteral;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespaceDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRdfCollectionType;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcSchema;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.LyoModelException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreInvalidPropertyDefinitionException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreMissingSetMethodException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreMisusedOccursException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreRelativeURIException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.AnyResource;
import org.eclipse.lyo.oslc4j.core.model.FilteredResource;
import org.eclipse.lyo.oslc4j.core.model.IExtendedResource;
import org.eclipse.lyo.oslc4j.core.model.IOslcCustomNamespaceProvider;
import org.eclipse.lyo.oslc4j.core.model.IReifiedResource;
import org.eclipse.lyo.oslc4j.core.model.IResource;
import org.eclipse.lyo.oslc4j.core.model.InheritedMethodAnnotationHelper;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.ResponseInfo;
import org.eclipse.lyo.oslc4j.core.model.TypeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.eclipse.lyo.oslc4j.core.model.XMLLiteral;
import org.eclipse.lyo.oslc4j.provider.jena.ordfm.ResourcePackages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class JenaModelHelper {
    private static final String PROPERTY_TOTAL_COUNT = "totalCount";
    private static final String PROPERTY_NEXT_PAGE = "nextPage";
    private static final String RDF_TYPE_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private static final String RDF_LIST = "List";
    private static final String RDF_ALT = "Alt";
    private static final String RDF_BAG = "Bag";
    private static final String RDF_SEQ = "Seq";
    private static final String METHOD_NAME_START_GET = "get";
    private static final String METHOD_NAME_START_IS = "is";
    private static final String METHOD_NAME_START_SET = "set";
    private static final int METHOD_NAME_START_GET_LENGTH = "get".length();
    private static final int METHOD_NAME_START_IS_LENGTH = "is".length();
    private static final String GENERATED_PREFIX_START = "j.";
    @Deprecated
    public static final String OSLC4J_STRICT_DATATYPES = "org.eclipse.lyo.oslc4j.strictDatatypes";
    private static final Logger logger = LoggerFactory.getLogger(JenaModelHelper.class);

    private JenaModelHelper() {
    }

    public static Model createJenaModel(Object[] objects) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        return JenaModelHelper.createJenaModel(null, null, null, objects, null);
    }

    static Model createJenaModel(String descriptionAbout, String responseInfoAbout, ResponseInfo<?> responseInfo, Object[] objects, Map<String, Object> properties) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        Instant start = Instant.now();
        Model model = ModelFactory.createDefaultModel();
        Resource descriptionResource = null;
        if (descriptionAbout != null) {
            descriptionResource = OSLC4JUtils.isQueryResultListAsContainer() ? model.createResource(descriptionAbout, RDFS.Container) : model.createResource(descriptionAbout);
            HashMap<Object, Object> visitedResources = new HashMap<IExtendedResource, Resource>();
            JenaModelHelper.handleExtendedProperties(FilteredResource.class, model, descriptionResource, responseInfo.getContainer(), properties, visitedResources);
            if (responseInfoAbout != null) {
                Resource responseInfoResource = model.createResource(responseInfoAbout, (Resource)model.createProperty("http://open-services.net/ns/core#ResponseInfo"));
                if (responseInfo != null) {
                    int n = responseInfo.totalCount() == null ? objects.length : responseInfo.totalCount();
                    responseInfoResource.addProperty(model.createProperty("http://open-services.net/ns/core#", PROPERTY_TOTAL_COUNT), (RDFNode)model.createTypedLiteral(n));
                    if (responseInfo.nextPage() != null) {
                        responseInfoResource.addProperty(model.createProperty("http://open-services.net/ns/core#", PROPERTY_NEXT_PAGE), (RDFNode)model.createResource(responseInfo.nextPage()));
                    }
                    visitedResources = new HashMap();
                    JenaModelHelper.handleExtendedProperties(ResponseInfo.class, model, responseInfoResource, responseInfo, properties, visitedResources);
                }
            }
        }
        HashMap<String, String> namespaceMappings = new HashMap<String, String>(OslcGlobalNamespaceProvider.getInstance().getPrefixDefinitionMap());
        for (Object object : objects) {
            JenaModelHelper.handleSingleResource(descriptionResource, object, model, namespaceMappings, properties);
        }
        if (descriptionAbout != null) {
            JenaModelHelper.ensureNamespacePrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", namespaceMappings);
            JenaModelHelper.ensureNamespacePrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#", namespaceMappings);
            if (responseInfoAbout != null) {
                JenaModelHelper.ensureNamespacePrefix("oslc", "http://open-services.net/ns/core#", namespaceMappings);
            }
        }
        for (Map.Entry entry : namespaceMappings.entrySet()) {
            model.setNsPrefix((String)entry.getKey(), (String)entry.getValue());
        }
        Instant finish = Instant.now();
        logger.trace("createJenaModel - Execution Duration: {} ms", (Object)Duration.between(start, finish).toMillis());
        return model;
    }

    private static void handleSingleResource(Resource descriptionResource, Object object, Model model, Map<String, String> namespaceMappings, Map<String, Object> properties) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        Resource mainResource;
        Class<?> objectClass = object.getClass();
        JenaModelHelper.recursivelyCollectNamespaceMappings(namespaceMappings, objectClass);
        if (object instanceof URI) {
            mainResource = model.createResource(((URI)object).toASCIIString());
        } else {
            String qualifiedName;
            URI aboutURI = null;
            if (object instanceof IResource) {
                aboutURI = ((IResource)object).getAbout();
            }
            if (aboutURI != null) {
                if (OSLC4JUtils.relativeURIsAreDisabled() && !aboutURI.isAbsolute()) {
                    throw new OslcCoreRelativeURIException(objectClass, "getAbout", aboutURI);
                }
                mainResource = model.createResource(aboutURI.toString());
            } else {
                mainResource = model.createResource();
            }
            if (objectClass.getAnnotation(OslcResourceShape.class) != null && (qualifiedName = TypeFactory.getQualifiedName(objectClass)) != null) {
                mainResource.addProperty(RDF.type, (RDFNode)model.createResource(qualifiedName));
            }
            JenaModelHelper.buildResource(object, objectClass, model, mainResource, properties);
        }
        if (descriptionResource != null) {
            descriptionResource.addProperty(RDFS.member, (RDFNode)mainResource);
        }
    }

    public static <T> T unmarshalSingle(Model model, Class<T> clazz) throws IllegalArgumentException, LyoModelException {
        T[] ts = JenaModelHelper.unmarshal(model, clazz);
        if (ts.length != 1) {
            throw new IllegalArgumentException("Model shall contain exactly 1 instance of the class");
        }
        return ts[0];
    }

    public static <T> T unmarshal(Resource resource, Class<T> clazz) throws LyoModelException {
        try {
            return (T)JenaModelHelper.fromJenaResource(resource, clazz);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | URISyntaxException | DatatypeConfigurationException | OslcCoreApplicationException e) {
            throw new LyoModelException(e);
        }
    }

    @Deprecated
    public static Object fromJenaResource(Resource resource, Class<?> beanClass) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, URISyntaxException, SecurityException, NoSuchMethodException {
        ResourcePackages.mapPackage(beanClass.getPackage());
        Optional<Class<?>> mostConcreteResourceClass = ResourcePackages.getClassOf(resource, beanClass);
        if (mostConcreteResourceClass.isPresent()) {
            beanClass = mostConcreteResourceClass.get();
        }
        Object newInstance = beanClass.newInstance();
        HashMap classPropertyDefinitionsToSetMethods = new HashMap();
        HashMap<String, Object> visitedResources = new HashMap<String, Object>();
        HashSet<String> rdfTypes = new HashSet<String>();
        JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, beanClass, newInstance, resource, visitedResources, rdfTypes);
        return newInstance;
    }

    public static <T> T[] unmarshal(Model model, Class<T> clazz) throws LyoModelException {
        try {
            Object[] objects = JenaModelHelper.fromJenaModel(model, clazz);
            return objects;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | URISyntaxException | DatatypeConfigurationException | OslcCoreApplicationException e) {
            throw new LyoModelException(e);
        }
    }

    @Deprecated
    public static Object[] fromJenaModel(Model model, Class<?> beanClass) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, URISyntaxException, SecurityException, NoSuchMethodException {
        Instant start = Instant.now();
        ArrayList<Object> results = new ArrayList<Object>();
        if (beanClass.getAnnotation(OslcResourceShape.class) != null) {
            ResIterator listSubjects;
            if (!OSLC4JUtils.useBeanClassForParsing()) {
                String qualifiedName = TypeFactory.getQualifiedName(beanClass);
                listSubjects = model.listSubjectsWithProperty(RDF.type, (RDFNode)model.getResource(qualifiedName));
                List resourceList = listSubjects.toList();
                JenaModelHelper.createObjectResultList(beanClass, results, resourceList);
            } else {
                listSubjects = model.listSubjectsWithProperty(RDF.type);
                ArrayList<Resource> resourceList = new ArrayList<Resource>();
                while (listSubjects.hasNext()) {
                    Resource resource = (Resource)listSubjects.next();
                    SimpleSelector selector = new SimpleSelector(null, null, (RDFNode)resource);
                    StmtIterator listStatements = model.listStatements((Selector)selector);
                    if (listStatements.hasNext()) continue;
                    resourceList.add(resource);
                }
                JenaModelHelper.createObjectResultList(beanClass, results, resourceList);
            }
        } else if (URI.class.equals(beanClass)) {
            StmtIterator memberIterator = model.listStatements(null, RDFS.member, (RDFNode)null);
            while (memberIterator.hasNext()) {
                Statement memberStatement = (Statement)memberIterator.next();
                RDFNode memberObject = memberStatement.getObject();
                if (!memberObject.isURIResource()) continue;
                URI memberURI = URI.create(memberObject.asResource().getURI());
                results.add(memberURI);
            }
        }
        Instant finish = Instant.now();
        logger.trace("fromJenaModel - Execution Duration: {} ms", (Object)Duration.between(start, finish).toMillis());
        return results.toArray((Object[])Array.newInstance(beanClass, results.size()));
    }

    public static <R extends IResource> R followLink(Model m, Link l, Class<R> rClass) throws IllegalArgumentException, LyoModelException {
        IResource[] rs;
        for (IResource r : rs = (IResource[])JenaModelHelper.unmarshal(m, rClass)) {
            if (!((URI)l.getValue()).equals(r.getAbout())) continue;
            return (R)r;
        }
        throw new IllegalArgumentException("Link cannot be followed in this model");
    }

    public static void skolemize(Model m) {
        JenaModelHelper.skolemize(m, blankNodeId -> "urn:skolem:" + blankNodeId.getLabelString());
    }

    public static void skolemize(Model m, Function<BlankNodeId, String> skolemUriFunction) {
        ResIterator resIterator = m.listSubjects();
        while (resIterator.hasNext()) {
            Resource resource = resIterator.nextResource();
            if (resource == null || !resource.isAnon()) continue;
            String skolemURI = skolemUriFunction.apply(resource.getId().getBlankNodeId());
            ResourceUtils.renameResource((Resource)resource, (String)skolemURI);
        }
    }

    private static List<Object> createObjectResultList(Class<?> beanClass, List<Object> results, List<Resource> listSubjects) throws IllegalAccessException, InstantiationException, DatatypeConfigurationException, InvocationTargetException, OslcCoreApplicationException, URISyntaxException, NoSuchMethodException {
        if (null != listSubjects) {
            ResourcePackages.mapPackage(beanClass.getPackage());
            HashMap classPropertyDefinitionsToSetMethods = new HashMap();
            Class<?> originalBeanClass = beanClass;
            for (Resource resource : listSubjects) {
                beanClass = originalBeanClass;
                Optional<Class<?>> mostConcreteResourceClass = ResourcePackages.getClassOf(resource, beanClass);
                if (mostConcreteResourceClass.isPresent() && !originalBeanClass.isAssignableFrom(beanClass = mostConcreteResourceClass.get())) continue;
                Object newInstance = beanClass.newInstance();
                HashMap<String, Object> visitedResources = new HashMap<String, Object>();
                HashSet<String> rdfTypes = new HashSet<String>();
                JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, beanClass, newInstance, resource, visitedResources, rdfTypes);
                results.add(newInstance);
            }
        }
        return results;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fromResource(Map<Class<?>, Map<String, Method>> classPropertyDefinitionsToSetMethods, Class<?> beanClass, Object bean, Resource resource, Map<String, Object> visitedResources, HashSet<String> rdfTypes) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, URISyntaxException, SecurityException, NoSuchMethodException {
        Method setMethod;
        HashMap<QName, Object> extendedProperties;
        IExtendedResource extendedResource;
        String aboutURIString;
        Map<String, Method> setMethodMap = classPropertyDefinitionsToSetMethods.get(beanClass);
        if (setMethodMap == null) {
            setMethodMap = JenaModelHelper.createPropertyDefinitionToSetMethods(beanClass);
            classPropertyDefinitionsToSetMethods.put(beanClass, setMethodMap);
        }
        visitedResources.put(JenaModelHelper.getVisitedResourceName(resource), bean);
        if (bean instanceof IResource && (aboutURIString = resource.getURI()) != null) {
            URI aboutURI = new URI(aboutURIString);
            if (aboutURI.isAbsolute()) {
                ((IResource)bean).setAbout(aboutURI);
            } else if (!(bean instanceof AbstractResource)) {
                throw new OslcCoreRelativeURIException(beanClass, "setAbout", aboutURI);
            }
        }
        HashMap<String, List> propertyDefinitionsToArrayValues = new HashMap<String, List>();
        HashSet<Method> singleValueMethodsUsed = new HashSet<Method>();
        StmtIterator listProperties = resource.listProperties();
        if (bean instanceof IExtendedResource) {
            extendedResource = (IExtendedResource)bean;
            extendedProperties = new HashMap<QName, Object>();
            extendedResource.setExtendedProperties(extendedProperties);
        } else {
            extendedResource = null;
            extendedProperties = null;
        }
        rdfTypes = JenaModelHelper.getTypesFromResource(resource, rdfTypes);
        while (listProperties.hasNext()) {
            List<RDFNode> objects;
            boolean bl;
            Statement statement = (Statement)listProperties.next();
            Property predicate = statement.getPredicate();
            RDFNode object = statement.getObject();
            String uri = predicate.getURI();
            setMethod = setMethodMap.get(uri);
            if (setMethod == null) {
                ArrayList<Object> collection;
                if (RDF_TYPE_URI.equals(uri)) {
                    if (extendedResource == null) continue;
                    URI type = new URI(object.asResource().getURI());
                    extendedResource.addType(type);
                    continue;
                }
                if (extendedProperties == null) {
                    logger.debug("Set method not found for object type: {}, uri: {}", (Object)beanClass.getName(), (Object)uri);
                    continue;
                }
                String prefix = resource.getModel().getNsURIPrefix(predicate.getNameSpace());
                if (prefix == null) {
                    prefix = JenaModelHelper.generatePrefix(resource.getModel(), predicate.getNameSpace());
                }
                QName qName = new QName(predicate.getNameSpace(), predicate.getLocalName(), prefix);
                Object value = JenaModelHelper.handleExtendedPropertyValue(beanClass, object, visitedResources, qName, rdfTypes);
                Object previous = extendedProperties.get(qName);
                if (previous == null) {
                    extendedProperties.put(qName, value);
                    continue;
                }
                if (previous instanceof Collection) {
                    collection = (ArrayList<Object>)previous;
                } else {
                    collection = new ArrayList<Object>();
                    collection.add(previous);
                    extendedProperties.put(qName, collection);
                }
                collection.add(value);
                continue;
            }
            Class setMethodComponentParameterClass = setMethod.getParameterTypes()[0];
            boolean bl2 = setMethodComponentParameterClass.isArray();
            if (bl2) {
                setMethodComponentParameterClass = setMethodComponentParameterClass.getComponentType();
            } else if (Collection.class.isAssignableFrom(setMethodComponentParameterClass)) {
                Type actualTypeArgument;
                ParameterizedType parameterizedType;
                Type[] actualTypeArguments;
                bl = true;
                Type genericParameterType = setMethod.getGenericParameterTypes()[0];
                if (genericParameterType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericParameterType).getActualTypeArguments()).length == 1 && (actualTypeArgument = actualTypeArguments[0]) instanceof Class) {
                    setMethodComponentParameterClass = (Class)actualTypeArgument;
                }
            }
            if (bl && object.isResource() && (object.asResource().hasProperty(RDF.first) && object.asResource().hasProperty(RDF.rest) || RDF.nil.equals((Object)object) || object.canAs(RDFList.class))) {
                objects = new ArrayList<RDFNode>();
                for (Resource listNode = object.asResource(); listNode != null && !RDF.nil.getURI().equals(listNode.getURI()); listNode = listNode.getPropertyResourceValue(RDF.rest)) {
                    visitedResources.put(JenaModelHelper.getVisitedResourceName(listNode), new Object());
                    Resource o = listNode.getPropertyResourceValue(RDF.first);
                    objects.add((RDFNode)o);
                }
                visitedResources.put(JenaModelHelper.getVisitedResourceName(object.asResource()), objects);
            } else {
                Class<? extends Container> collectionResourceClass = JenaModelHelper.getRdfCollectionResourceClass(object.getModel(), object);
                if (bl && collectionResourceClass != null) {
                    objects = new ArrayList<RDFNode>();
                    Container container = (Container)object.as(collectionResourceClass);
                    for (RDFNode o : container) {
                        if (o.isResource()) {
                            visitedResources.put(JenaModelHelper.getVisitedResourceName(o.asResource()), new Object());
                        }
                        objects.add(o);
                    }
                    visitedResources.put(JenaModelHelper.getVisitedResourceName(object.asResource()), objects);
                } else {
                    objects = Collections.singletonList(object);
                }
            }
            Class reifiedClass = null;
            if (IReifiedResource.class.isAssignableFrom(setMethodComponentParameterClass)) {
                Type actualTypeArgument;
                ParameterizedType parameterizedType;
                Type[] actualTypeArguments;
                reifiedClass = setMethodComponentParameterClass;
                Type genericType = setMethodComponentParameterClass.getGenericSuperclass();
                if (genericType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && (actualTypeArgument = actualTypeArguments[0]) instanceof Class) {
                    setMethodComponentParameterClass = (Class)actualTypeArgument;
                }
            }
            for (RDFNode o : objects) {
                Object parameter = null;
                if (o.isLiteral()) {
                    Literal literal = o.asLiteral();
                    String stringValue = literal.getString();
                    if (String.class == setMethodComponentParameterClass) {
                        parameter = stringValue;
                    } else if (Boolean.class == setMethodComponentParameterClass || Boolean.TYPE == setMethodComponentParameterClass) {
                        if (Boolean.TRUE.toString().equals(stringValue) || "1".equals(stringValue)) {
                            parameter = Boolean.TRUE;
                        } else {
                            if (!Boolean.FALSE.toString().equals(stringValue) && !"0".equals(stringValue)) throw new IllegalArgumentException("'" + stringValue + "' has wrong format for Boolean.");
                            parameter = Boolean.FALSE;
                        }
                    } else if (Byte.class == setMethodComponentParameterClass || Byte.TYPE == setMethodComponentParameterClass) {
                        parameter = Byte.valueOf(stringValue);
                    } else if (Short.class == setMethodComponentParameterClass || Short.TYPE == setMethodComponentParameterClass) {
                        parameter = Short.valueOf(stringValue);
                    } else if (Integer.class == setMethodComponentParameterClass || Integer.TYPE == setMethodComponentParameterClass) {
                        parameter = Integer.valueOf(stringValue);
                    } else if (Long.class == setMethodComponentParameterClass || Long.TYPE == setMethodComponentParameterClass) {
                        parameter = Long.valueOf(stringValue);
                    } else if (BigInteger.class == setMethodComponentParameterClass) {
                        parameter = new BigInteger(stringValue);
                    } else if (Float.class == setMethodComponentParameterClass || Float.TYPE == setMethodComponentParameterClass) {
                        parameter = XSDDatatype.XSDfloat.parseValidated(stringValue);
                    } else if (Double.class == setMethodComponentParameterClass || Double.TYPE == setMethodComponentParameterClass) {
                        parameter = XSDDatatype.XSDdouble.parseValidated(stringValue);
                    } else if (Date.class == setMethodComponentParameterClass) {
                        parameter = DatatypeFactory.newInstance().newXMLGregorianCalendar(stringValue).toGregorianCalendar().getTime();
                    }
                } else if (o.isResource()) {
                    Resource nestedResource = o.asResource();
                    if (URI.class == setMethodComponentParameterClass) {
                        String nestedResourceURIString = nestedResource.getURI();
                        if (nestedResourceURIString != null) {
                            URI nestedResourceURI = new URI(nestedResourceURIString);
                            if (OSLC4JUtils.relativeURIsAreDisabled() && !nestedResourceURI.isAbsolute()) {
                                throw new OslcCoreRelativeURIException(beanClass, setMethod.getName(), nestedResourceURI);
                            }
                            parameter = nestedResourceURI;
                        }
                    } else {
                        Optional<Class<?>> optionalResourceClass = ResourcePackages.getClassOf(nestedResource, setMethodComponentParameterClass);
                        Class resourceClass = optionalResourceClass.isPresent() ? (Class)optionalResourceClass.get() : setMethodComponentParameterClass;
                        Object nestedBean = resourceClass.newInstance();
                        JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, nestedBean.getClass(), nestedBean, nestedResource, visitedResources, rdfTypes);
                        parameter = nestedBean;
                    }
                }
                if (parameter == null) continue;
                if (reifiedClass != null) {
                    Object reifiedResource = reifiedClass.newInstance();
                    for (Method method : reifiedClass.getMethods()) {
                        Class<?>[] parameterTypes;
                        if (!"setValue".equals(method.getName()) || (parameterTypes = method.getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(setMethodComponentParameterClass)) continue;
                        method.invoke(reifiedResource, parameter);
                        break;
                    }
                    RSIterator rsIter = statement.listReifiedStatements();
                    while (rsIter.hasNext()) {
                        ReifiedStatement reifiedStatement = (ReifiedStatement)rsIter.next();
                        JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, reifiedClass, reifiedResource, (Resource)reifiedStatement, visitedResources, rdfTypes);
                    }
                    parameter = reifiedResource;
                }
                if (bl) {
                    List values = propertyDefinitionsToArrayValues.computeIfAbsent(uri, k -> new ArrayList());
                    values.add(parameter);
                    continue;
                }
                if (singleValueMethodsUsed.contains(setMethod)) {
                    throw new OslcCoreMisusedOccursException(beanClass, setMethod);
                }
                setMethod.invoke(bean, parameter);
                singleValueMethodsUsed.add(setMethod);
            }
        }
        for (Map.Entry propertyDefinitionToArrayValues : propertyDefinitionsToArrayValues.entrySet()) {
            void var18_27;
            String uri = (String)propertyDefinitionToArrayValues.getKey();
            List values = (List)propertyDefinitionToArrayValues.getValue();
            setMethod = setMethodMap.get(uri);
            Class<?> parameterClass = setMethod.getParameterTypes()[0];
            if (parameterClass.isArray()) {
                Class<?> clazz = parameterClass.getComponentType();
                Object array = Array.newInstance(clazz, values.size());
                int index = 0;
                for (Object value : values) {
                    Array.set(array, index++, value);
                }
                setMethod.invoke(bean, array);
                continue;
            }
            if (Collection.class == parameterClass || List.class == parameterClass || Deque.class == parameterClass || Queue.class == parameterClass || AbstractCollection.class == parameterClass || AbstractList.class == parameterClass || AbstractSequentialList.class == parameterClass) {
                LinkedList linkedList = new LinkedList();
            } else if (Set.class == parameterClass || AbstractSet.class == parameterClass) {
                HashSet hashSet = new HashSet();
            } else if (SortedSet.class == parameterClass || NavigableSet.class == parameterClass) {
                TreeSet treeSet = new TreeSet();
            } else {
                Collection collection = (Collection)parameterClass.newInstance();
            }
            var18_27.addAll(values);
            setMethod.invoke(bean, var18_27);
        }
    }

    private static HashSet<String> getTypesFromResource(Resource resource, HashSet<String> types) {
        if (OSLC4JUtils.inferTypeFromShape() && types.isEmpty()) {
            StmtIterator rdfTypesIterator = resource.listProperties(RDF.type);
            while (rdfTypesIterator.hasNext()) {
                Statement rdfTypeStmt = (Statement)rdfTypesIterator.next();
                RDFNode object = rdfTypeStmt.getObject();
                if (!object.isResource()) continue;
                String rdfType = object.asResource().getURI();
                types.add(rdfType);
            }
        }
        return types;
    }

    private static Class<? extends Container> getRdfCollectionResourceClass(Model model, RDFNode object) {
        if (object.isResource()) {
            Resource resource = object.asResource();
            if (resource.hasProperty(RDF.type, (RDFNode)model.getResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt"))) {
                return Alt.class;
            }
            if (resource.hasProperty(RDF.type, (RDFNode)model.getResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag"))) {
                return Bag.class;
            }
            if (resource.hasProperty(RDF.type, (RDFNode)model.getResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq"))) {
                return Seq.class;
            }
        }
        return null;
    }

    private static String generatePrefix(Model model, String namespace) {
        String candidatePrefix;
        Map map = model.getNsPrefixMap();
        int i = 0;
        do {
            candidatePrefix = GENERATED_PREFIX_START + i;
            ++i;
        } while (map.containsKey(candidatePrefix));
        model.setNsPrefix(candidatePrefix, namespace);
        return candidatePrefix;
    }

    private static Object handleExtendedPropertyValue(Class<?> beanClass, RDFNode object, Map<String, Object> visitedResources, QName propertyQName, HashSet<String> rdfTypes) throws URISyntaxException, IllegalArgumentException, SecurityException, DatatypeConfigurationException, IllegalAccessException, InstantiationException, InvocationTargetException, OslcCoreApplicationException, NoSuchMethodException {
        if (object.isLiteral()) {
            Object literalValue;
            Object newObject;
            RDFDatatype dataType;
            Literal literal = object.asLiteral();
            if (OSLC4JUtils.inferTypeFromShape() && null == (dataType = literal.getDatatype()) && null != (newObject = OSLC4JUtils.getValueBasedOnResourceShapeType(rdfTypes, (QName)propertyQName, (Object)literal.getString()))) {
                return newObject;
            }
            try {
                literalValue = literal.getValue();
            }
            catch (DatatypeFormatException e) {
                String rawValue = literal.getString();
                String datatype = literal.getDatatypeURI();
                if ("false".equals(System.getProperty(OSLC4J_STRICT_DATATYPES))) {
                    String propUri = propertyQName.getNamespaceURI() + propertyQName.getLocalPart();
                    logger.warn("Property {} could not be parsed as datatype {}", (Object)propUri, (Object)literal.getDatatype());
                    logger.debug("Exception thrown while parsing property {}: ", (Object)propUri, (Object)e);
                    return new UnparseableLiteral(rawValue, datatype);
                }
                throw e;
            }
            if (literalValue instanceof XSDDateTime) {
                XSDDateTime xsdDateTime = (XSDDateTime)literalValue;
                return xsdDateTime.asCalendar().getTime();
            }
            if (XMLLiteralType.theXMLLiteralType.getURI().equals(literal.getDatatypeURI())) {
                return new XMLLiteral(literal.getString());
            }
            if (XSDDatatype.XSDdecimal.getURI().equals(literal.getDatatypeURI())) {
                return new BigDecimal(literal.getString());
            }
            return literalValue;
        }
        Resource nestedResource = object.asResource();
        if ((nestedResource.getURI() == null || nestedResource.listProperties().hasNext()) && !visitedResources.containsKey(JenaModelHelper.getVisitedResourceName(nestedResource))) {
            AnyResource any = new AnyResource();
            HashMap classPropertyDefinitionsToSetMethods = new HashMap();
            JenaModelHelper.fromResource(classPropertyDefinitionsToSetMethods, AnyResource.class, any, nestedResource, visitedResources, rdfTypes);
            return any;
        }
        if (nestedResource.getURI() == null || nestedResource.listProperties().hasNext()) {
            return visitedResources.get(JenaModelHelper.getVisitedResourceName(nestedResource));
        }
        URI nestedResourceURI = new URI(nestedResource.getURI());
        if (OSLC4JUtils.relativeURIsAreDisabled() && !nestedResourceURI.isAbsolute()) {
            throw new OslcCoreRelativeURIException(beanClass, "<none>", nestedResourceURI);
        }
        return nestedResourceURI;
    }

    private static Map<String, Method> createPropertyDefinitionToSetMethods(Class<?> beanClass) throws OslcCoreApplicationException {
        Method[] methods;
        HashMap<String, Method> result = new HashMap<String, Method>();
        for (Method method : methods = beanClass.getMethods()) {
            OslcPropertyDefinition oslcPropertyDefinitionAnnotation;
            String getMethodName;
            if (method.getParameterTypes().length != 0 || (!(getMethodName = method.getName()).startsWith(METHOD_NAME_START_GET) || getMethodName.length() <= METHOD_NAME_START_GET_LENGTH) && (!getMethodName.startsWith(METHOD_NAME_START_IS) || getMethodName.length() <= METHOD_NAME_START_IS_LENGTH) || (oslcPropertyDefinitionAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcPropertyDefinition.class)) == null) continue;
            String setMethodName = getMethodName.startsWith(METHOD_NAME_START_GET) ? METHOD_NAME_START_SET + getMethodName.substring(METHOD_NAME_START_GET_LENGTH) : METHOD_NAME_START_SET + getMethodName.substring(METHOD_NAME_START_IS_LENGTH);
            Class<?> getMethodReturnType = method.getReturnType();
            try {
                Method setMethod = beanClass.getMethod(setMethodName, getMethodReturnType);
                result.put(oslcPropertyDefinitionAnnotation.value(), setMethod);
            }
            catch (NoSuchMethodException exception) {
                throw new OslcCoreMissingSetMethodException(beanClass, method, exception);
            }
        }
        return result;
    }

    private static void buildResource(Object object, Class<?> resourceClass, Model model, Resource mainResource, Map<String, Object> properties) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        if (properties == OSLC4JConstants.OSL4J_PROPERTY_SINGLETON) {
            return;
        }
        for (Method method : resourceClass.getMethods()) {
            Object value;
            OslcPropertyDefinition oslcPropertyDefinitionAnnotation;
            String methodName;
            if (method.getParameterTypes().length != 0 || (!(methodName = method.getName()).startsWith(METHOD_NAME_START_GET) || methodName.length() <= METHOD_NAME_START_GET_LENGTH) && (!methodName.startsWith(METHOD_NAME_START_IS) || methodName.length() <= METHOD_NAME_START_IS_LENGTH) || (oslcPropertyDefinitionAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcPropertyDefinition.class)) == null || (value = method.invoke(object, new Object[0])) == null) continue;
            Map<String, Object> nestedProperties = null;
            boolean onlyNested = false;
            if (properties != null) {
                Map<String, Object> map = (Map<String, Object>)properties.get(oslcPropertyDefinitionAnnotation.value());
                if (map != null) {
                    nestedProperties = map;
                } else if (properties instanceof SingletonWildcardProperties && !(properties instanceof NestedWildcardProperties)) {
                    nestedProperties = OSLC4JConstants.OSL4J_PROPERTY_SINGLETON;
                } else {
                    if (!(properties instanceof NestedWildcardProperties)) continue;
                    nestedProperties = ((NestedWildcardProperties)((Object)properties)).commonNestedProperties();
                    onlyNested = !(properties instanceof SingletonWildcardProperties);
                }
            }
            JenaModelHelper.buildAttributeResource(resourceClass, method, oslcPropertyDefinitionAnnotation, model, mainResource, value, nestedProperties, onlyNested);
        }
        if (object instanceof IExtendedResource) {
            IExtendedResource extendedResource = (IExtendedResource)object;
            HashMap<IExtendedResource, Resource> visitedResources = new HashMap<IExtendedResource, Resource>();
            JenaModelHelper.handleExtendedProperties(resourceClass, model, mainResource, extendedResource, properties, visitedResources);
        }
    }

    protected static void handleExtendedProperties(Class<?> resourceClass, Model model, Resource mainResource, IExtendedResource extendedResource, Map<String, Object> properties, Map<IExtendedResource, Resource> visitedResources) throws DatatypeConfigurationException, IllegalAccessException, InvocationTargetException, OslcCoreApplicationException {
        visitedResources.put(extendedResource, mainResource);
        for (URI type : extendedResource.getTypes()) {
            Resource typeResource;
            String propertyName = type.toString();
            if (properties != null && properties.get(propertyName) == null && !(properties instanceof NestedWildcardProperties) && !(properties instanceof SingletonWildcardProperties) || mainResource.hasProperty(RDF.type, (RDFNode)(typeResource = model.createResource(propertyName)))) continue;
            mainResource.addProperty(RDF.type, (RDFNode)typeResource);
        }
        Transformer transformer = JenaModelHelper.createTransformer();
        for (Map.Entry extendedProperty : extendedResource.getExtendedProperties().entrySet()) {
            QName qName = (QName)extendedProperty.getKey();
            String propertyName = qName.getNamespaceURI() + qName.getLocalPart();
            Map<String, Object> nestedProperties = null;
            boolean onlyNested = false;
            if (properties != null) {
                Map<String, Object> map = (Map<String, Object>)properties.get(propertyName);
                if (map != null) {
                    nestedProperties = map;
                } else if (properties instanceof SingletonWildcardProperties && !(properties instanceof NestedWildcardProperties)) {
                    nestedProperties = OSLC4JConstants.OSL4J_PROPERTY_SINGLETON;
                } else {
                    if (!(properties instanceof NestedWildcardProperties)) continue;
                    nestedProperties = ((NestedWildcardProperties)((Object)properties)).commonNestedProperties();
                    onlyNested = !(properties instanceof SingletonWildcardProperties);
                }
            }
            Property property = model.createProperty(propertyName);
            Object value = extendedProperty.getValue();
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object next : collection) {
                    JenaModelHelper.handleExtendedValue(resourceClass, next, model, mainResource, property, nestedProperties, onlyNested, visitedResources, transformer);
                }
                continue;
            }
            JenaModelHelper.handleExtendedValue(resourceClass, value, model, mainResource, property, nestedProperties, onlyNested, visitedResources, transformer);
        }
    }

    private static void handleExtendedValue(Class<?> objectClass, Object value, Model model, Resource resource, Property property, Map<String, Object> nestedProperties, boolean onlyNested, Map<IExtendedResource, Resource> visitedResources, Transformer transformer) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        if (value instanceof UnparseableLiteral) {
            if (onlyNested) {
                return;
            }
            UnparseableLiteral unparseable = (UnparseableLiteral)value;
            resource.addProperty(property, (RDFNode)model.createLiteral(unparseable.getRawValue()));
        } else if (value instanceof AnyResource) {
            AbstractResource any = (AbstractResource)value;
            if (!visitedResources.containsKey(any)) {
                Resource nestedResource;
                URI aboutURI = any.getAbout();
                if (aboutURI != null) {
                    if (OSLC4JUtils.relativeURIsAreDisabled() && !aboutURI.isAbsolute()) {
                        throw new OslcCoreRelativeURIException(AnyResource.class, "getAbout", aboutURI);
                    }
                    nestedResource = model.createResource(aboutURI.toString());
                } else {
                    nestedResource = model.createResource();
                }
                for (URI type : any.getTypes()) {
                    String propertyName = type.toString();
                    if (nestedProperties != null && nestedProperties.get(propertyName) == null && !(nestedProperties instanceof NestedWildcardProperties) && !(nestedProperties instanceof SingletonWildcardProperties)) continue;
                    nestedResource.addProperty(RDF.type, (RDFNode)model.createResource(propertyName));
                }
                JenaModelHelper.handleExtendedProperties(AnyResource.class, model, nestedResource, (IExtendedResource)any, nestedProperties, visitedResources);
                resource.addProperty(property, (RDFNode)nestedResource);
            } else {
                resource.addProperty(property, (RDFNode)visitedResources.get(any));
            }
        } else if (value.getClass().getAnnotation(OslcResourceShape.class) != null || value instanceof URI) {
            boolean xmlliteral = false;
            JenaModelHelper.handleLocalResource(objectClass, null, xmlliteral, value, model, resource, property, nestedProperties, onlyNested, null);
        } else if (value instanceof Date) {
            if (onlyNested) {
                return;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)value);
            RDFDatatype dataType = null;
            if (OSLC4JUtils.inferTypeFromShape()) {
                HashSet<String> rdfTypes = new HashSet<String>();
                rdfTypes = JenaModelHelper.getTypesFromResource(resource, rdfTypes);
                dataType = OSLC4JUtils.getDataTypeBasedOnResourceShapeType(rdfTypes, (Property)property);
            }
            if (dataType != null && dataType instanceof XSDDateType) {
                XSDDateTime valuec = new XSDDateTime(cal);
                valuec.narrowType(XSDDatatype.XSDdate);
                String valueDate = valuec.toString();
                if (valueDate != null && valueDate.endsWith("Z")) {
                    valueDate = valueDate.replaceAll("Z", "");
                }
                resource.addProperty(property, (RDFNode)model.createTypedLiteral(valueDate, (RDFDatatype)XSDDatatype.XSDdate));
            } else {
                resource.addProperty(property, (RDFNode)model.createTypedLiteral(cal));
            }
        } else if (value instanceof XMLLiteral) {
            XMLLiteral xmlLiteral = (XMLLiteral)value;
            Literal xmlString = model.createTypedLiteral(xmlLiteral.getValue(), XMLLiteralType.theXMLLiteralType);
            resource.addProperty(property, (RDFNode)xmlString);
        } else if (value instanceof Element) {
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource((Element)value);
            try {
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
            Literal xmlString = model.createLiteral(result.getWriter().toString(), true);
            resource.addProperty(property, (RDFNode)xmlString);
        } else if (value instanceof String) {
            if (onlyNested) {
                return;
            }
            resource.addProperty(property, (RDFNode)model.createLiteral((String)value));
        } else if (value instanceof Float) {
            if (onlyNested) {
                return;
            }
            Float f = (Float)value;
            Literal l = JenaModelHelper.toLiteral(model, f);
            resource.addProperty(property, (RDFNode)l);
        } else if (value instanceof Double) {
            if (onlyNested) {
                return;
            }
            Double d = (Double)value;
            Literal l = JenaModelHelper.toLiteral(model, d);
            resource.addProperty(property, (RDFNode)l);
        } else {
            if (onlyNested) {
                return;
            }
            resource.addProperty(property, (RDFNode)model.createTypedLiteral(value));
        }
    }

    private static Literal toLiteral(Model model, Float f) {
        if (f.compareTo(Float.valueOf(Float.POSITIVE_INFINITY)) == 0) {
            logger.warn("+INF float is serialised to the model");
            return model.createTypedLiteral("INF", XSDDatatype.XSDfloat.getURI());
        }
        if (f.compareTo(Float.valueOf(Float.NEGATIVE_INFINITY)) == 0) {
            logger.warn("-INF float is serialised to the model");
            return model.createTypedLiteral("-INF", XSDDatatype.XSDfloat.getURI());
        }
        return model.createTypedLiteral((Object)f, (RDFDatatype)XSDDatatype.XSDfloat);
    }

    private static Literal toLiteral(Model model, Double d) {
        if (d.compareTo(Double.POSITIVE_INFINITY) == 0) {
            logger.warn("+INF double is serialised to the model");
            return model.createTypedLiteral("INF", XSDDatatype.XSDdouble.getURI());
        }
        if (d.compareTo(Double.NEGATIVE_INFINITY) == 0) {
            logger.warn("-INF float is serialised to the model");
            return model.createTypedLiteral("-INF", XSDDatatype.XSDdouble.getURI());
        }
        return model.createTypedLiteral((Object)d, (RDFDatatype)XSDDatatype.XSDdouble);
    }

    private static void buildAttributeResource(Class<?> resourceClass, Method method, OslcPropertyDefinition propertyDefinitionAnnotation, Model model, Resource resource, Object value, Map<String, Object> nestedProperties, boolean onlyNested) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        OslcName nameAnnotation;
        String name;
        String propertyDefinition = propertyDefinitionAnnotation.value();
        if (!propertyDefinition.endsWith(name = (nameAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcName.class)) != null ? nameAnnotation.value() : JenaModelHelper.getDefaultPropertyName(method))) {
            throw new OslcCoreInvalidPropertyDefinitionException(resourceClass, method, propertyDefinitionAnnotation);
        }
        OslcValueType valueTypeAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcValueType.class);
        boolean xmlLiteral = valueTypeAnnotation != null && ValueType.XMLLiteral.equals((Object)valueTypeAnnotation.value());
        Property attribute = model.createProperty(propertyDefinition);
        Class<?> returnType = method.getReturnType();
        OslcRdfCollectionType collectionType = InheritedMethodAnnotationHelper.getAnnotation(method, OslcRdfCollectionType.class);
        ArrayList<RDFNode> rdfNodeContainer = collectionType != null && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(collectionType.namespaceURI()) && (RDF_LIST.equals(collectionType.collectionType()) || RDF_ALT.equals(collectionType.collectionType()) || RDF_BAG.equals(collectionType.collectionType()) || RDF_SEQ.equals(collectionType.collectionType())) ? new ArrayList<RDFNode>() : null;
        if (returnType.isArray()) {
            int length = Array.getLength(value);
            for (int index = 0; index < length; ++index) {
                Object object = Array.get(value, index);
                JenaModelHelper.handleLocalResource(resourceClass, method, xmlLiteral, object, model, resource, attribute, nestedProperties, onlyNested, rdfNodeContainer);
            }
            if (rdfNodeContainer != null) {
                RDFNode container = JenaModelHelper.createRdfContainer(collectionType, rdfNodeContainer, model);
                Statement s = model.createStatement(resource, attribute, container);
                model.add(s);
            }
        } else if (Collection.class.isAssignableFrom(returnType)) {
            Collection collection = (Collection)value;
            for (Object object : collection) {
                JenaModelHelper.handleLocalResource(resourceClass, method, xmlLiteral, object, model, resource, attribute, nestedProperties, onlyNested, rdfNodeContainer);
            }
            if (rdfNodeContainer != null) {
                RDFNode container = JenaModelHelper.createRdfContainer(collectionType, rdfNodeContainer, model);
                Statement s = model.createStatement(resource, attribute, container);
                model.add(s);
            }
        } else {
            JenaModelHelper.handleLocalResource(resourceClass, method, xmlLiteral, value, model, resource, attribute, nestedProperties, onlyNested, null);
        }
    }

    private static RDFNode createRdfContainer(OslcRdfCollectionType collectionType, List<RDFNode> rdfNodeContainer, Model model) {
        if (RDF_LIST.equals(collectionType.collectionType())) {
            return model.createList(rdfNodeContainer.iterator());
        }
        Object container = RDF_ALT.equals(collectionType.collectionType()) ? model.createAlt() : (RDF_BAG.equals(collectionType.collectionType()) ? model.createBag() : model.createSeq());
        for (RDFNode node : rdfNodeContainer) {
            container.add(node);
        }
        return container;
    }

    private static void handleLocalResource(Class<?> resourceClass, Method method, boolean xmlLiteral, Object object, Model model, Resource resource, Property attribute, Map<String, Object> nestedProperties, boolean onlyNested, List<RDFNode> rdfNodeContainer) throws DatatypeConfigurationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, OslcCoreApplicationException {
        Object value;
        if (object == null) {
            return;
        }
        Class<?> objectClass = object.getClass();
        Literal nestedNode = null;
        IReifiedResource reifiedResource = object instanceof IReifiedResource ? (IReifiedResource)object : null;
        Object object2 = value = reifiedResource == null ? object : reifiedResource.getValue();
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            if (onlyNested) {
                return;
            }
            nestedNode = xmlLiteral ? model.createTypedLiteral(value.toString(), XMLLiteralType.theXMLLiteralType) : model.createLiteral(value.toString());
        } else if (value instanceof Float) {
            if (onlyNested) {
                return;
            }
            nestedNode = JenaModelHelper.toLiteral(model, (Float)value);
        } else if (value instanceof Double) {
            if (onlyNested) {
                return;
            }
            nestedNode = JenaModelHelper.toLiteral(model, (Double)value);
        } else if (value instanceof Boolean || value instanceof Number) {
            if (onlyNested) {
                return;
            }
            nestedNode = model.createTypedLiteral(value);
        } else if (value instanceof URI) {
            if (onlyNested) {
                return;
            }
            URI uri = (URI)value;
            if (OSLC4JUtils.relativeURIsAreDisabled() && !uri.isAbsolute()) {
                throw new OslcCoreRelativeURIException(resourceClass, method == null ? "<none>" : method.getName(), uri);
            }
            nestedNode = model.createResource(value.toString());
        } else if (value instanceof Date) {
            if (onlyNested) {
                return;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime((Date)value);
            RDFDatatype dataType = null;
            if (OSLC4JUtils.inferTypeFromShape()) {
                HashSet<String> rdfTypes = new HashSet<String>();
                rdfTypes = JenaModelHelper.getTypesFromResource(resource, rdfTypes);
                dataType = OSLC4JUtils.getDataTypeBasedOnResourceShapeType(rdfTypes, (Property)attribute);
            }
            if (dataType != null && dataType instanceof XSDDateType) {
                XSDDateTime valuec = new XSDDateTime((Calendar)calendar);
                valuec.narrowType(XSDDatatype.XSDdate);
                String valueDate = valuec.toString();
                if (valueDate != null && valueDate.endsWith("Z")) {
                    valueDate = valueDate.replaceAll("Z", "");
                }
                nestedNode = model.createTypedLiteral(valueDate, (RDFDatatype)XSDDatatype.XSDdate);
            } else {
                nestedNode = model.createTypedLiteral((Calendar)calendar);
            }
        } else if (objectClass.getAnnotation(OslcResourceShape.class) != null) {
            Resource nestedResource;
            String namespace = TypeFactory.getNamespace(objectClass);
            String name = TypeFactory.getName(objectClass);
            URI aboutURI = null;
            if (value instanceof IResource) {
                aboutURI = ((IResource)value).getAbout();
            }
            if (aboutURI != null) {
                if (OSLC4JUtils.relativeURIsAreDisabled() && !aboutURI.isAbsolute()) {
                    throw new OslcCoreRelativeURIException(objectClass, "getAbout", aboutURI);
                }
                nestedResource = model.createResource(aboutURI.toString(), (Resource)model.createProperty(namespace, name));
            } else {
                nestedResource = model.createResource((Resource)model.createProperty(namespace, name));
            }
            JenaModelHelper.buildResource(value, objectClass, model, nestedResource, nestedProperties);
            nestedNode = nestedResource;
        } else if (logger.isWarnEnabled()) {
            String objectClassName;
            String subjectClassName = resourceClass.getSimpleName();
            if ("".equals(subjectClassName)) {
                subjectClassName = resourceClass.getName();
            }
            if ("".equals(objectClassName = objectClass.getSimpleName())) {
                objectClassName = objectClass.getName();
            }
            logger.warn("Could not serialize " + objectClassName + " because it does not have an OslcResourceShape annotation (class: " + subjectClassName + ", method: " + method.getName() + ")");
        }
        if (nestedNode != null) {
            if (rdfNodeContainer != null) {
                if (reifiedResource != null) {
                    throw new IllegalStateException("Reified resource is not supported for rdf collection resources");
                }
                rdfNodeContainer.add((RDFNode)nestedNode);
            } else {
                Statement statement = model.createStatement(resource, attribute, (RDFNode)nestedNode);
                if (reifiedResource != null && nestedProperties != OSLC4JConstants.OSL4J_PROPERTY_SINGLETON) {
                    JenaModelHelper.addReifiedStatements(model, statement, reifiedResource, nestedProperties);
                }
                model.add(statement);
            }
        }
    }

    private static void addReifiedStatements(Model model, Statement statement, IReifiedResource<?> reifiedResource, Map<String, Object> nestedProperties) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, DatatypeConfigurationException, OslcCoreApplicationException {
        ReifiedStatement reifiedStatement = statement.createReifiedStatement();
        JenaModelHelper.buildResource(reifiedResource, reifiedResource.getClass(), model, (Resource)reifiedStatement, nestedProperties);
        if (reifiedStatement.listProperties().toList().size() == 4) {
            reifiedStatement.removeProperties();
            logger.debug("An empty reified statement was stripped from the model");
        }
    }

    private static String getDefaultPropertyName(Method method) {
        String methodName = method.getName();
        int startingIndex = methodName.startsWith(METHOD_NAME_START_GET) ? METHOD_NAME_START_GET_LENGTH : METHOD_NAME_START_IS_LENGTH;
        int endingIndex = startingIndex + 1;
        String lowercasedFirstCharacter = methodName.substring(startingIndex, endingIndex).toLowerCase(Locale.ENGLISH);
        if (methodName.length() == endingIndex) {
            return lowercasedFirstCharacter;
        }
        return lowercasedFirstCharacter + methodName.substring(endingIndex);
    }

    private static void recursivelyCollectNamespaceMappings(Map<String, String> namespaceMappings, Class<?> resourceClass) {
        Class<?>[] interfaces;
        Class<?> superClass;
        OslcSchema oslcSchemaAnnotation = resourceClass.getPackage().getAnnotation(OslcSchema.class);
        if (oslcSchemaAnnotation != null) {
            OslcNamespaceDefinition[] oslcNamespaceDefinitionAnnotations;
            for (OslcNamespaceDefinition oslcNamespaceDefinitionAnnotation : oslcNamespaceDefinitionAnnotations = oslcSchemaAnnotation.value()) {
                String prefix = oslcNamespaceDefinitionAnnotation.prefix();
                String namespaceURI = oslcNamespaceDefinitionAnnotation.namespaceURI();
                namespaceMappings.put(prefix, namespaceURI);
            }
            Class customNamespaceProvider = oslcSchemaAnnotation.customNamespaceProvider();
            if (!customNamespaceProvider.isInterface()) {
                try {
                    IOslcCustomNamespaceProvider customNamespaceProviderImpl = (IOslcCustomNamespaceProvider)customNamespaceProvider.newInstance();
                    Map customNamespacePrefixes = customNamespaceProviderImpl.getCustomNamespacePrefixes();
                    if (null != customNamespacePrefixes) {
                        namespaceMappings.putAll(customNamespacePrefixes);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("The custom namespace provider implementation: " + customNamespaceProvider.getClass().getName() + ", must have a public no args construtor", e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("The custom namespace provider must not be a abstract, nor interface class and must have a public no args constructor", e);
                }
            }
        }
        if ((superClass = resourceClass.getSuperclass()) != null) {
            JenaModelHelper.recursivelyCollectNamespaceMappings(namespaceMappings, superClass);
        }
        if ((interfaces = resourceClass.getInterfaces()) != null) {
            for (Class<?> interfac : interfaces) {
                JenaModelHelper.recursivelyCollectNamespaceMappings(namespaceMappings, interfac);
            }
        }
    }

    private static void ensureNamespacePrefix(String prefix, String namespace, Map<String, String> namespaceMappings) {
        if (!namespaceMappings.containsValue(namespace)) {
            if (!namespaceMappings.containsKey(prefix)) {
                namespaceMappings.put(prefix, namespace);
            } else {
                int index = 1;
                while (true) {
                    String newPrefix;
                    if (!namespaceMappings.containsKey(newPrefix = prefix + index)) {
                        namespaceMappings.put(newPrefix, namespace);
                        return;
                    }
                    ++index;
                }
            }
        }
    }

    private static String getVisitedResourceName(Resource resource) {
        String visitedResourceName = resource.getURI() != null ? resource.getURI() : resource.getId().toString();
        return visitedResourceName;
    }

    private static Transformer createTransformer() {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            return transformer;
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }
}

