/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.mapping;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.core.mapping.AbstractResourceMappingScope;
import org.eclipse.team.internal.core.mapping.CompoundResourceTraversal;

public class ResourceMappingInputScope
extends AbstractResourceMappingScope {
    ISynchronizationScope wrappedScope;

    public ResourceMappingInputScope(ISynchronizationScope wrappedScope) {
        this.wrappedScope = wrappedScope;
    }

    @Override
    public ResourceMapping[] getInputMappings() {
        return this.wrappedScope.getInputMappings();
    }

    @Override
    public ResourceMapping[] getMappings() {
        return this.getInputMappings();
    }

    @Override
    public ResourceTraversal[] getTraversals() {
        ResourceMapping[] mappings;
        CompoundResourceTraversal result = new CompoundResourceTraversal();
        ResourceMapping[] resourceMappingArray = mappings = this.getMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            ResourceTraversal[] traversals = this.getTraversals(mapping);
            result.addTraversals(traversals);
            ++n2;
        }
        return result.asTraversals();
    }

    @Override
    public ResourceTraversal[] getTraversals(ResourceMapping mapping) {
        if (!this.contains(mapping)) {
            return null;
        }
        return this.wrappedScope.getTraversals(mapping);
    }

    private boolean contains(ResourceMapping mapping) {
        ResourceMapping[] mappings;
        ResourceMapping[] resourceMappingArray = mappings = this.getMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping child = resourceMappingArray[n2];
            if (child.equals((Object)mapping)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean hasAdditionalMappings() {
        return false;
    }

    @Override
    public boolean hasAdditonalResources() {
        return false;
    }

    @Override
    public ISynchronizationScope asInputScope() {
        return this;
    }

    @Override
    public IProject[] getProjects() {
        return this.wrappedScope.getProjects();
    }

    @Override
    public ResourceMappingContext getContext() {
        return this.wrappedScope.getContext();
    }

    @Override
    public void refresh(ResourceMapping[] mappings) {
        this.wrappedScope.refresh(mappings);
    }
}

