/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorInput;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class OpenDiagramCommand
extends AbstractCommand {
    private EObject _element = null;

    public OpenDiagramCommand(String label, EObject element) {
        super(label, null);
        this.setElement(element);
    }

    protected EObject getElement() {
        return this._element;
    }

    protected void setElement(EObject element) {
        this._element = element;
    }

    public OpenDiagramCommand(EObject element) {
        this(DiagramUIMessages.Command_openDiagram, element);
    }

    public boolean canExecute() {
        return this.getElement() instanceof Diagram;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        try {
            TransactionUtil.getEditingDomain((EObject)this.getElement()).runExclusive(new Runnable(){

                @Override
                public void run() {
                    Diagram diagram = null;
                    if (OpenDiagramCommand.this.getElement() instanceof Diagram) {
                        diagram = (Diagram)OpenDiagramCommand.this.getElement();
                    }
                    if (diagram != null) {
                        DiagramEditorInput diagramInput = new DiagramEditorInput(diagram);
                        IEditorPart editor = null;
                        editor = EditorService.getInstance().openEditor((IEditorInput)diagramInput);
                        if (editor == null) {
                            throw new UnsupportedOperationException();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"doExecute()", (Throwable)e);
            return new CommandResult((IStatus)new Status(4, DiagramUIPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e));
        }
        return CommandResult.newOKCommandResult();
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

