/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.traceability.engine;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.types.TypesPackage;

public final class TraceabilityVisitorUtil {
    private static final List<Class<?>> PRIMITIVE_CLASSES = new ArrayList();
    private static final List<EClassifier> PRIMITIVE_CLASSIFIERS = new ArrayList<EClassifier>();

    static {
        PRIMITIVE_CLASSES.add(Character.class);
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getEChar());
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getECharacterObject());
        PRIMITIVE_CLASSES.add(String.class);
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getEString());
        PRIMITIVE_CLASSES.add(Short.class);
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getEShort());
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getEShortObject());
        PRIMITIVE_CLASSES.add(Integer.class);
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getEInt());
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getEIntegerObject());
        PRIMITIVE_CLASSES.add(Long.class);
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getELong());
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getELongObject());
        PRIMITIVE_CLASSES.add(BigInteger.class);
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getEBigInteger());
        PRIMITIVE_CLASSES.add(Float.class);
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getEFloat());
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getEFloatObject());
        PRIMITIVE_CLASSES.add(Double.class);
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getEDouble());
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getEDoubleObject());
        PRIMITIVE_CLASSES.add(BigDecimal.class);
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getEBigDecimal());
        PRIMITIVE_CLASSES.add(Boolean.class);
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        PRIMITIVE_CLASSIFIERS.add((EClassifier)EcorePackage.eINSTANCE.getEBooleanObject());
    }

    private TraceabilityVisitorUtil() {
    }

    public static boolean isPrimitive(Collection<?> collection) {
        boolean isPrimitiveCollection = true;
        Iterator<?> valueIterator = collection.iterator();
        while (valueIterator.hasNext() && isPrimitiveCollection) {
            isPrimitiveCollection = TraceabilityVisitorUtil.isPrimitive(valueIterator.next());
        }
        return isPrimitiveCollection;
    }

    public static boolean isPrimitive(Object value) {
        Class<?> valueClass;
        if (value == null) {
            return false;
        }
        boolean result = false;
        result = value instanceof EClassifier ? TraceabilityVisitorUtil.isPrimitive((EClassifier)value) : (value instanceof Collection ? TraceabilityVisitorUtil.isPrimitive((Collection)value) : (value instanceof Enumerator ? true : ((valueClass = value.getClass()).isPrimitive() ? true : PRIMITIVE_CLASSES.contains(valueClass))));
        return result;
    }

    public static boolean isPrimitive(EClassifier classifier) {
        if (classifier instanceof PrimitiveType) {
            return true;
        }
        return PRIMITIVE_CLASSIFIERS.contains(classifier);
    }

    public static boolean isPrimitiveCollection(EClassifier classifier) {
        if (TypesPackage.eINSTANCE.getCollectionType().isInstance((Object)classifier)) {
            return TraceabilityVisitorUtil.isPrimitive(((CollectionType)classifier).getElementType());
        }
        return false;
    }
}

