/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.RedundantComparatorFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;

public class RedundantComparatorCleanUpCore
extends AbstractCleanUpCore {
    public RedundantComparatorCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public RedundantComparatorCleanUpCore() {
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        return new CleanUpRequirementsCore(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.redundant_comparator");
    }

    @Override
    public ICleanUpFixCore createFixCore(CleanUpContextCore context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.redundant_comparator")) {
            return null;
        }
        return RedundantComparatorFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.redundant_comparator")) {
            result.add(MultiFixMessages.RedundantComparatorCleanUp_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.redundant_comparator")) {
            return "Collections.sort(listToSort);\n\n\n\n\n\n";
        }
        return "Collections.sort(listToSort, new Comparator<Date>() {\n    @Override\n    public int compare(Date o1, Date o2) {\n        return o1.compareTo(o2);\n    }\n});\n";
    }
}

