/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Connection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEditPart;

public class DCompartmentConnectionRefreshMgr
extends ShapeCompartmentEditPart.ConnectionRefreshMgr {
    private Set<ConnectionNodeEditPart> edgeToEdges = new HashSet<ConnectionNodeEditPart>();
    private Predicate safeConnection = new Predicate(){

        public boolean apply(Object input) {
            boolean selected = true;
            if (input instanceof ConnectionEditPart) {
                ConnectionEditPart part = (ConnectionEditPart)input;
                selected = false;
                if (part.getSource() != null && part.getTarget() != null && part.getFigure() instanceof Connection) {
                    Connection connection = (Connection)part.getFigure();
                    selected = connection.getConnectionRouter().getConstraint(connection) != null;
                }
            }
            return selected;
        }
    };

    protected Set getSpecificConnectionNodes(ShapeCompartmentEditPart scep) {
        HashSet endPoints = new HashSet();
        HashMap<Edge, DEdgeEditPart> edgeToEdge = new HashMap<Edge, DEdgeEditPart>();
        Object modelObject = scep.getModel();
        if (scep.getViewer() != null && modelObject instanceof View && ((View)modelObject).getDiagram() != null) {
            Diagram diagram = ((View)modelObject).getDiagram();
            Map registry = scep.getViewer().getEditPartRegistry();
            EList edges = diagram.getEdges();
            for (Edge edge : edges) {
                Object cep;
                EditPart endPoint = (EditPart)registry.get(edge.getSource());
                if (endPoint instanceof DEdgeEditPart) {
                    edgeToEdge.put(edge, (DEdgeEditPart)endPoint);
                }
                if (this.isChildOf((EditPart)scep, endPoint) || endPoint != null && endPoint.equals(scep.getParent())) {
                    cep = registry.get(edge);
                    if (cep == null) continue;
                    endPoints.add(cep);
                    continue;
                }
                endPoint = (EditPart)registry.get(edge.getTarget());
                if (endPoint instanceof DEdgeEditPart) {
                    edgeToEdge.put(edge, (DEdgeEditPart)endPoint);
                }
                if (!this.isChildOf((EditPart)scep, endPoint) && (endPoint == null || !endPoint.equals(scep.getParent())) || (cep = registry.get(edge)) == null) continue;
                endPoints.add(cep);
            }
            Set cles = edgeToEdge.keySet();
            for (Edge edge : cles) {
                Object cep;
                DEdgeEditPart edgeEditPart = (DEdgeEditPart)edgeToEdge.get(edge);
                if (!endPoints.contains(edgeEditPart) || (cep = registry.get(edge)) == null) continue;
                this.edgeToEdges.add((ConnectionNodeEditPart)cep);
            }
        }
        return endPoints;
    }

    protected Set getConnectionNodes(ShapeCompartmentEditPart scep) {
        Set connectionsNodes = this.getSpecificConnectionNodes(scep);
        if (connectionsNodes != null) {
            Iterable filteredConnectionNodes = Iterables.filter((Iterable)connectionsNodes, (Predicate)this.safeConnection);
            return Sets.newHashSet((Iterable)filteredConnectionNodes);
        }
        return connectionsNodes;
    }

    protected void refreshConnections(ShapeCompartmentEditPart scep) {
        super.refreshConnections(scep);
        for (ConnectionNodeEditPart cep : this.edgeToEdges) {
            Connection connection = (Connection)cep.getFigure();
            IGraphicalEditPart source = (IGraphicalEditPart)this.getSourceEditPart((ConnectionEditPart)cep);
            IGraphicalEditPart target = (IGraphicalEditPart)this.getTargetEditPart((ConnectionEditPart)cep);
            if (source == null || target == null) {
                connection.setVisible(false);
                continue;
            }
            if (!source.getFigure().isShowing() || !target.getFigure().isShowing()) {
                connection.setVisible(false);
                continue;
            }
            cep.refresh();
        }
        this.edgeToEdges.clear();
    }
}

