/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.text.edits.TextEditGroup;

public class UnwrapNewArrayOperation
extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
    private final ArrayCreation node;
    private final Expression call;

    public UnwrapNewArrayOperation(ArrayCreation node, Expression call) {
        this.node = node;
        this.call = call;
    }

    @Override
    public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
        ListRewrite listRewrite;
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        if (this.call instanceof ClassInstanceCreation) {
            listRewrite = rewrite.getListRewrite((ASTNode)this.call, ClassInstanceCreation.ARGUMENTS_PROPERTY);
        } else if (this.call instanceof MethodInvocation) {
            listRewrite = rewrite.getListRewrite((ASTNode)this.call, MethodInvocation.ARGUMENTS_PROPERTY);
        } else if (this.call instanceof SuperMethodInvocation) {
            listRewrite = rewrite.getListRewrite((ASTNode)this.call, SuperMethodInvocation.ARGUMENTS_PROPERTY);
        } else {
            return;
        }
        TextEditGroup group = this.createTextEditGroup(FixMessages.UnusedCodeFix_RemoveUnnecessaryArrayCreation_description, cuRewrite);
        if (this.node.getInitializer() != null && this.node.getInitializer().expressions() != null) {
            List expressionsInArray = this.node.getInitializer().expressions();
            int i = 1;
            while (i < expressionsInArray.size()) {
                listRewrite.insertLast((ASTNode)ASTNodes.createMoveTarget(rewrite, (Expression)expressionsInArray.get(i)), group);
                ++i;
            }
            if (expressionsInArray.isEmpty()) {
                listRewrite.remove((ASTNode)this.node, group);
            } else {
                listRewrite.replace((ASTNode)this.node, (ASTNode)ASTNodes.createMoveTarget(rewrite, (Expression)expressionsInArray.get(0)), group);
            }
        } else {
            listRewrite.remove((ASTNode)this.node, group);
        }
    }
}

