/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import java.util.Collections;
import java.util.List;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.ResizeKind;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.diagram.description.style.Side;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;

public class DNodeQuery {
    private final DNode node;

    public DNodeQuery(DNode node) {
        this.node = node;
    }

    public boolean allowsVerticalResize() {
        ResizeKind allowed = this.node.getResizeKind();
        return allowed == ResizeKind.NSEW_LITERAL || allowed == ResizeKind.NORTH_SOUTH_LITERAL;
    }

    public boolean allowsHorizontalResize() {
        ResizeKind allowed = this.node.getResizeKind();
        return allowed == ResizeKind.NSEW_LITERAL || allowed == ResizeKind.EAST_WEST_LITERAL;
    }

    public boolean hasLabelOnBorder() {
        NodeStyleDescription style;
        NodeMapping actualMapping = this.node.getActualMapping();
        if (actualMapping != null && (style = actualMapping.getStyle()) != null) {
            LabelPosition labelPosition = style.getLabelPosition();
            return labelPosition.equals((Object)LabelPosition.BORDER_LITERAL);
        }
        return false;
    }

    public boolean hasNonEmptyNameDefinition() {
        NodeStyleDescription style;
        boolean hasEmptyNameDefinition = true;
        NodeMapping actualMapping = this.node.getActualMapping();
        if (actualMapping != null && (style = actualMapping.getStyle()) != null) {
            String labelExpression = style.getLabelExpression();
            hasEmptyNameDefinition = labelExpression.trim().length() != 0;
        }
        return hasEmptyNameDefinition;
    }

    public List<Side> getForbiddenSide() {
        NodeStyle nodeStyle = this.node.getOwnedStyle();
        StyleDescription styleDescription = nodeStyle.getDescription();
        if (styleDescription instanceof NodeStyleDescription) {
            return ((NodeStyleDescription)styleDescription).getForbiddenSides();
        }
        return Collections.emptyList();
    }
}

