/*
 * Decompiled with CFR 0.152.
 */
package adaptorinterface;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResourcePropertyOccurs implements Enumerator
{
    EXACTLY_ONE(0, "exactlyOne", "exactlyOne"),
    ZERO_OR_ONE(1, "zeroOrOne", "zeroOrOne"),
    ZERO_OR_MANY(2, "zeroOrMany", "zeroOrMany"),
    ONE_OR_MANY(3, "oneOrMany", "oneOrMany");

    public static final int EXACTLY_ONE_VALUE = 0;
    public static final int ZERO_OR_ONE_VALUE = 1;
    public static final int ZERO_OR_MANY_VALUE = 2;
    public static final int ONE_OR_MANY_VALUE = 3;
    private static final ResourcePropertyOccurs[] VALUES_ARRAY;
    public static final List<ResourcePropertyOccurs> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ResourcePropertyOccurs[]{EXACTLY_ONE, ZERO_OR_ONE, ZERO_OR_MANY, ONE_OR_MANY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public String toStringNumeric() {
        switch (this) {
            case EXACTLY_ONE: {
                return "[1]";
            }
            case ZERO_OR_ONE: {
                return "[0..1]";
            }
            case ZERO_OR_MANY: {
                return "[0..*]";
            }
            case ONE_OR_MANY: {
                return "[1..*]";
            }
        }
        return "[*..*]";
    }

    public static ResourcePropertyOccurs get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResourcePropertyOccurs result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResourcePropertyOccurs getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResourcePropertyOccurs result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResourcePropertyOccurs get(int value) {
        switch (value) {
            case 0: {
                return EXACTLY_ONE;
            }
            case 1: {
                return ZERO_OR_ONE;
            }
            case 2: {
                return ZERO_OR_MANY;
            }
            case 3: {
                return ONE_OR_MANY;
            }
        }
        return null;
    }

    private ResourcePropertyOccurs(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

